/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class BeanInfoCache {
    private static HashMap descriptorsCache = new HashMap();
    private static HashMap methodCache = new HashMap();

    private BeanInfoCache() {
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        descriptors = (PropertyDescriptor[])descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(beanClass, descriptors);
        BeanInfoCache.addMethodMap(beanClass, descriptors);
        return descriptors;
    }

    private static Map addMethodMap(Class beanClass, PropertyDescriptor[] descriptors) {
        int length = descriptors.length;
        HashMap<String, Method[]> methodMap = new HashMap<String, Method[]>();
        for (int i2 = 0; i2 < length; ++i2) {
            Method[] methods = new Method[]{descriptors[i2].getReadMethod(), descriptors[i2].getWriteMethod()};
            methodMap.put(descriptors[i2].getName(), methods);
        }
        methodCache.put(beanClass, methodMap);
        return methodMap;
    }

    private static Map addMethodMap(Class beanClass) {
        PropertyDescriptor[] descriptors = BeanInfoCache.getPropertyDescriptors(beanClass);
        return BeanInfoCache.addMethodMap(beanClass, descriptors);
    }

    private static Method[] getMethods(Class beanClass, String name) {
        Map methodMap = (Map)methodCache.get(beanClass);
        if (methodMap == null) {
            methodMap = BeanInfoCache.addMethodMap(beanClass);
        }
        return (Method[])methodMap.get(name);
    }

    public static Method getReadMethod(Class beanClass, String name) {
        Method[] methods = BeanInfoCache.getMethods(beanClass, name);
        if (methods == null) {
            return null;
        }
        return methods[0];
    }

    public static Method getWriteMethod(Class beanClass, String name) {
        Method[] methods = BeanInfoCache.getMethods(beanClass, name);
        if (methods == null) {
            return null;
        }
        return methods[1];
    }
}

