/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class ExcelCSVLexer {
    public static final int YYEOF = -1;
    private static final int YY_BUFFERSIZE = 16384;
    public static final int BEFORE = 1;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 3;
    public static final int AFTER = 2;
    private static final String yycmap_packed = "\n\u0000\u0001\u0002\u0002\u0000\u0001\u0001\u0014\u0000\u0001\u0003\t\u0000\u0001\u0004\uffd3\u0000";
    private static final char[] yycmap = ExcelCSVLexer.yy_unpack_cmap("\n\u0000\u0001\u0002\u0002\u0000\u0001\u0001\u0014\u0000\u0001\u0003\t\u0000\u0001\u0004\uffd3\u0000");
    private static final int[] yy_rowMap = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 30, 40, 45, 30, 50, 30, 55, 30, 60, 65, 70};
    private static final String yy_packed0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0006\u0001\u0007\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0006\u0001\u0007\u0002\u0011\u0001\u0005\u0002\u0000\u0001\u0005\u0003\u0000\u0001\u0007\u0007\u0000\u0003\b\u0001\u0012\u0001\b\u0001\n\u0002\u0000\u0001\n\u0003\u0000\u0001\f\u0002\u0000\u0003\r\u0001\u0013\u0001\r\u0001\u000f\u0002\u0000\u0001\u000f\u0001\u0000\u0001\u0011\u0002\u0000\u0002\u0011\u0003\u0000\u0001\b\u0004\u0000\u0001\r\u0001\u0000";
    private static final int[] yytrans = ExcelCSVLexer.yy_unpack();
    private static final int YY_UNKNOWN_ERROR = 0;
    private static final int YY_ILLEGAL_STATE = 1;
    private static final int YY_NO_MATCH = 2;
    private static final int YY_PUSHBACK_2BIG = 3;
    private static final String[] YY_ERROR_MSG = new String[]{"Unkown internal scanner error", "Internal error: unknown state", "Error: could not match input", "Error: pushback value was too large"};
    private static final byte[] YY_ATTRIBUTE = new byte[]{0, 0, 1, 1, 1, 1, 9, 0, 9, 1, 1, 9, 0, 9, 1, 9, 1, 1, 1};
    private Reader yy_reader;
    private int yy_state;
    private int yy_lexical_state = 0;
    private char[] yy_buffer = new char[16384];
    private int yy_markedPos;
    private int yy_pushbackPos;
    private int yy_currentPos;
    private int yy_startRead;
    private int yy_endRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean yy_atBOL = true;
    private boolean yy_atEOF;
    private String commentDelims = "";
    private boolean addLine = true;
    private int lines = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            String t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            ExcelCSVLexer shredder = new ExcelCSVLexer(in);
            while ((t = shredder.getNextToken()) != null) {
                System.out.println("" + shredder.getLineNumber() + " " + t);
            }
            return;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private String unescape(String s) {
        if (s.indexOf(34, 1) == s.length() - 1) {
            return s.substring(1, s.length() - 1);
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (int i2 = 1; i2 < s.length() - 1; ++i2) {
            char c = s.charAt(i2);
            char c1 = s.charAt(i2 + 1);
            if (c == '\"' && c1 == '\"') {
                ++i2;
                sb.append("\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setCommentStart(String commentDelims) {
        this.commentDelims = commentDelims;
    }

    public int getLineNumber() {
        return this.lines;
    }

    ExcelCSVLexer(Reader in) {
        this.yy_reader = in;
    }

    ExcelCSVLexer(InputStream in) throws Exception {
        this(new InputStreamReader(in, "JISAutoDetect"));
    }

    private static int[] yy_unpack() {
        int[] trans = new int[75];
        int offset = 0;
        offset = ExcelCSVLexer.yy_unpack(yy_packed0, offset, trans);
        return trans;
    }

    private static int yy_unpack(String packed, int offset, int[] trans) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            int value = packed.charAt(i2++);
            do {
                trans[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static char[] yy_unpack_cmap(String packed) {
        char[] map2 = new char[65536];
        int i2 = 0;
        int j = 0;
        while (i2 < 18) {
            int count = packed.charAt(i2++);
            char value = packed.charAt(i2++);
            do {
                map2[j++] = value;
            } while (--count > 0);
        }
        return map2;
    }

    private boolean yy_refill() throws IOException {
        int numRead;
        if (this.yy_startRead > 0) {
            System.arraycopy(this.yy_buffer, this.yy_startRead, this.yy_buffer, 0, this.yy_endRead - this.yy_startRead);
            this.yy_endRead -= this.yy_startRead;
            this.yy_currentPos -= this.yy_startRead;
            this.yy_markedPos -= this.yy_startRead;
            this.yy_pushbackPos -= this.yy_startRead;
            this.yy_startRead = 0;
        }
        if (this.yy_currentPos >= this.yy_buffer.length) {
            char[] newBuffer = new char[this.yy_currentPos * 2];
            System.arraycopy(this.yy_buffer, 0, newBuffer, 0, this.yy_buffer.length);
            this.yy_buffer = newBuffer;
        }
        if ((numRead = this.yy_reader.read(this.yy_buffer, this.yy_endRead, this.yy_buffer.length - this.yy_endRead)) < 0) {
            return true;
        }
        this.yy_endRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.yy_atEOF = true;
        this.yy_endRead = this.yy_startRead;
        if (this.yy_reader != null) {
            this.yy_reader.close();
        }
    }

    public final void yyreset(Reader reader) throws IOException {
        this.yyclose();
        this.yy_reader = reader;
        this.yy_atBOL = true;
        this.yy_atEOF = false;
        this.yy_startRead = 0;
        this.yy_endRead = 0;
        this.yy_pushbackPos = 0;
        this.yy_markedPos = 0;
        this.yy_currentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.yy_lexical_state = 0;
    }

    public final int yystate() {
        return this.yy_lexical_state;
    }

    public final void yybegin(int newState) {
        this.yy_lexical_state = newState;
    }

    public final String yytext() {
        return new String(this.yy_buffer, this.yy_startRead, this.yy_markedPos - this.yy_startRead);
    }

    public final char yycharat(int pos) {
        return this.yy_buffer[this.yy_startRead + pos];
    }

    public final int yylength() {
        return this.yy_markedPos - this.yy_startRead;
    }

    private void yy_ScanError(int errorCode) {
        String message;
        try {
            message = YY_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = YY_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    private void yypushback(int number) {
        if (number > this.yylength()) {
            this.yy_ScanError(3);
        }
        this.yy_markedPos -= number;
    }

    public String getNextToken() throws IOException {
        int yy_endRead_l = this.yy_endRead;
        char[] yy_buffer_l = this.yy_buffer;
        char[] yycmap_l = yycmap;
        int[] yytrans_l = yytrans;
        int[] yy_rowMap_l = yy_rowMap;
        byte[] yy_attr_l = YY_ATTRIBUTE;
        block26: while (true) {
            int yy_input;
            int yy_markedPos_l = this.yy_markedPos;
            int yy_action = -1;
            this.yy_currentPos = this.yy_startRead = yy_markedPos_l;
            int yy_currentPos_l = this.yy_startRead;
            int yy_startRead_l = this.yy_startRead;
            this.yy_state = this.yy_lexical_state;
            while (true) {
                if (yy_currentPos_l < yy_endRead_l) {
                    yy_input = yy_buffer_l[yy_currentPos_l++];
                } else {
                    if (this.yy_atEOF) {
                        yy_input = -1;
                        break;
                    }
                    this.yy_currentPos = yy_currentPos_l;
                    this.yy_markedPos = yy_markedPos_l;
                    boolean eof = this.yy_refill();
                    yy_currentPos_l = this.yy_currentPos;
                    yy_markedPos_l = this.yy_markedPos;
                    yy_buffer_l = this.yy_buffer;
                    yy_endRead_l = this.yy_endRead;
                    if (eof) {
                        yy_input = -1;
                        break;
                    }
                    yy_input = yy_buffer_l[yy_currentPos_l++];
                }
                int yy_next = yytrans_l[yy_rowMap_l[this.yy_state] + yycmap_l[yy_input]];
                if (yy_next == -1) break;
                this.yy_state = yy_next;
                byte yy_attributes = yy_attr_l[this.yy_state];
                if ((yy_attributes & 1) != 1) continue;
                yy_action = this.yy_state;
                yy_markedPos_l = yy_currentPos_l;
                if ((yy_attributes & 8) == 8) break;
            }
            this.yy_markedPos = yy_markedPos_l;
            switch (yy_action) {
                case 2: 
                case 14: 
                case 20: {
                    continue block26;
                }
                case 3: 
                case 16: 
                case 21: {
                    continue block26;
                }
                case 9: {
                    this.yybegin(2);
                    return this.yytext();
                }
                case 22: {
                    continue block26;
                }
                case 8: {
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    this.yybegin(1);
                    return "";
                }
                case 23: {
                    continue block26;
                }
                case 5: 
                case 6: {
                    this.addLine = true;
                    this.yybegin(0);
                }
                case 24: {
                    continue block26;
                }
                case 10: 
                case 11: {
                    this.yybegin(0);
                    this.addLine = true;
                    return "";
                }
                case 25: {
                    continue block26;
                }
                case 4: {
                    String text;
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    if (this.commentDelims.indexOf((text = this.yytext()).charAt(0)) == -1) {
                        this.yybegin(2);
                        return text;
                    }
                    this.yybegin(3);
                }
                case 26: {
                    continue block26;
                }
                case 18: {
                    this.yybegin(2);
                    return this.unescape(this.yytext());
                }
                case 27: {
                    continue block26;
                }
                case 15: {
                    this.yybegin(1);
                }
                case 28: {
                    continue block26;
                }
                case 17: {
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    this.yybegin(2);
                    return this.unescape(this.yytext());
                }
                case 29: {
                    continue block26;
                }
                case 13: {
                    this.yybegin(1);
                    return "";
                }
                case 30: {
                    continue block26;
                }
            }
            if (yy_input == -1 && this.yy_startRead == this.yy_currentPos) {
                this.yy_atEOF = true;
                switch (this.yy_lexical_state) {
                    case 1: {
                        this.yybegin(0);
                        this.addLine = true;
                        return "";
                    }
                    case 20: {
                        continue block26;
                    }
                }
                return null;
            }
            this.yy_ScanError(2);
        }
    }
}

