/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.displaytag.decorator.ColumnDecorator;

public class AutolinkColumnDecorator
implements ColumnDecorator {
    public static final ColumnDecorator INSTANCE = new AutolinkColumnDecorator();
    private static final String URL_DELIM = "://";
    private static final String[] URLS_PREFIXES = new String[]{"http", "https", "ftp"};

    public String decorate(Object columnValue) {
        int urlBegin;
        if (columnValue == null) {
            return null;
        }
        String work = columnValue.toString();
        StringBuffer buffer = new StringBuffer();
        while ((urlBegin = work.indexOf(64)) != -1) {
            int j;
            int start = 0;
            int end = work.length() - 1;
            for (j = urlBegin; j >= 0; --j) {
                if (!Character.isWhitespace(work.charAt(j))) continue;
                start = j + 1;
                break;
            }
            for (j = urlBegin; j <= end; ++j) {
                if (!Character.isWhitespace(work.charAt(j))) continue;
                end = j - 1;
                break;
            }
            String email = work.substring(start, end + 1);
            buffer.append(work.substring(0, start)).append("<a href=\"mailto:").append(email + "\">").append(email).append("</a>");
            if (end == work.length()) {
                work = "";
                continue;
            }
            work = work.substring(end + 1);
        }
        work = buffer.toString() + work;
        buffer = new StringBuffer();
        while ((urlBegin = work.indexOf(URL_DELIM)) != -1) {
            int fullUrlBegin = urlBegin;
            StringBuffer prefixBuffer = new StringBuffer(10);
            for (int j = fullUrlBegin - 1; j >= 0; --j) {
                if (Character.isWhitespace(work.charAt(j))) {
                    fullUrlBegin = j + 1;
                    break;
                }
                fullUrlBegin = j;
                prefixBuffer.append(work.charAt(j));
            }
            if (!ArrayUtils.contains(URLS_PREFIXES, StringUtils.reverse(prefixBuffer.toString()))) {
                buffer.append(work.substring(0, urlBegin + 3));
                work = work.substring(urlBegin + 3);
                continue;
            }
            int urlEnd = work.length();
            for (int j = urlBegin; j < urlEnd; ++j) {
                if (!Character.isWhitespace(work.charAt(j))) continue;
                urlEnd = j;
                break;
            }
            String url = work.substring(fullUrlBegin, urlEnd);
            buffer.append(work.substring(0, fullUrlBegin)).append("<a href=\"").append(url).append("\">").append(url).append("</a>");
            if (urlEnd >= work.length()) {
                work = "";
                continue;
            }
            work = work.substring(urlEnd);
        }
        buffer.append(work);
        return buffer.toString();
    }
}

