/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleRowSetMetaData;

public class OracleJDBCRowSet
implements RowSet {
    private String dataSource;
    private String dataSourceName;
    private String url;
    private String username;
    private String password;
    private Connection connection;
    private static boolean driverManagerInitialized;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;
    private int fetchSize;
    private int fetchDirection;
    private int rowsetType;
    private RowSetEvent rowsetEvent;
    private Vector listener = new Vector();
    private boolean escapeProcessing;
    private String command;
    private boolean readOnly;
    private int concurrency;
    private int transactionIsolation;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private Map typeMap;

    public OracleJDBCRowSet() {
        this.rowsetEvent = new RowSetEvent(this);
        driverManagerInitialized = false;
        this.escapeProcessing = false;
        this.rowsetType = 1005;
        this.fetchDirection = 1002;
        this.readOnly = true;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.fetchSize = 0;
        this.queryTimeout = 0;
        this.url = "";
        this.username = "";
        this.password = "";
        this.command = "";
        this.typeMap = new HashMap();
        this.concurrency = 1007;
        this.transactionIsolation = 2;
    }

    public boolean absolute(int n2) throws SQLException {
        boolean bl = this.resultSet.absolute(n2);
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        int n2 = 0;
        while (n2 < this.listener.size()) {
            if (this.listener.elementAt(n2).equals(rowSetListener)) {
                return;
            }
            ++n2;
        }
        this.listener.add(rowSetListener);
    }

    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.resultSet.afterLast();
            this.notifyCursorMovement();
        }
    }

    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.resultSet.beforeFirst();
            this.notifyCursorMovement();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
        this.notifyRowSetChanged();
    }

    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
        this.notifyRowSetChanged();
    }

    public void execute() throws SQLException {
        this.connection = this.getConnection(this);
        this.connection.setTransactionIsolation(this.getTransactionIsolation());
        this.connection.setTypeMap(this.getTypeMap());
        this.preparedStatement = this.connection.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        this.preparedStatement.setFetchSize(this.getFetchSize());
        this.preparedStatement.setFetchDirection(this.getFetchDirection());
        this.preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        this.preparedStatement.setMaxRows(this.getMaxRows());
        this.preparedStatement.setQueryTimeout(this.getQueryTimeout());
        this.preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        this.resultSet = this.preparedStatement.executeQuery();
        this.notifyRowSetChanged();
    }

    public int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string);
    }

    public boolean first() throws SQLException {
        boolean bl = this.resultSet.first();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public Array getArray(int n2) throws SQLException {
        return this.resultSet.getArray(n2);
    }

    public Array getArray(String string) throws SQLException {
        return this.resultSet.getArray(string);
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.resultSet.getAsciiStream(n2);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.resultSet.getAsciiStream(string);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.resultSet.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.resultSet.getBigDecimal(n2, n3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.resultSet.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.resultSet.getBigDecimal(string, n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.resultSet.getBinaryStream(n2);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.resultSet.getBinaryStream(string);
    }

    public Blob getBlob(int n2) throws SQLException {
        return this.resultSet.getBlob(n2);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.resultSet.getBlob(string);
    }

    public boolean getBoolean(int n2) throws SQLException {
        return this.resultSet.getBoolean(n2);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    public byte getByte(int n2) throws SQLException {
        return this.resultSet.getByte(n2);
    }

    public byte getByte(String string) throws SQLException {
        return this.resultSet.getByte(string);
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this.resultSet.getBytes(n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.resultSet.getBytes(string);
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        return this.resultSet.getCharacterStream(n2);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.resultSet.getCharacterStream(string);
    }

    public Clob getClob(int n2) throws SQLException {
        return this.resultSet.getClob(n2);
    }

    public Clob getClob(String string) throws SQLException {
        return this.resultSet.getClob(string);
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        Connection connection = this.connection;
        if (connection != null && !connection.isClosed()) {
            return connection;
        }
        if (rowSet.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(rowSet.getDataSourceName());
                return dataSource.getConnection(rowSet.getUsername(), rowSet.getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
            }
        }
        if (rowSet.getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = rowSet.getUrl();
            String string2 = rowSet.getUsername();
            String string3 = rowSet.getPassword();
            if (string.equals("") || string2.equals("") || string3.equals("")) {
                throw new SQLException("One or more of the authenticating parameter not set");
            }
            return DriverManager.getConnection(string, string2, string3);
        }
        return null;
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Date getDate(int n2) throws SQLException {
        return this.resultSet.getDate(n2);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(n2, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(string, calendar);
    }

    public double getDouble(int n2) throws SQLException {
        return this.resultSet.getDouble(n2);
    }

    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public float getFloat(int n2) throws SQLException {
        return this.resultSet.getFloat(n2);
    }

    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    public int getInt(int n2) throws SQLException {
        return this.resultSet.getInt(n2);
    }

    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    public long getLong(int n2) throws SQLException {
        return this.resultSet.getLong(n2);
    }

    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new OracleRowSetMetaData(this.resultSet.getMetaData());
    }

    public Object getObject(int n2) throws SQLException {
        return this.resultSet.getObject(n2);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.resultSet.getObject(n2, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.resultSet.getObject(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.resultSet.getObject(string, map);
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public Ref getRef(int n2) throws SQLException {
        return this.resultSet.getRef(n2);
    }

    public Ref getRef(String string) throws SQLException {
        return this.resultSet.getRef(string);
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public short getShort(int n2) throws SQLException {
        return this.resultSet.getShort(n2);
    }

    public short getShort(String string) throws SQLException {
        return this.resultSet.getShort(string);
    }

    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    public String getString(int n2) throws SQLException {
        return this.resultSet.getString(n2);
    }

    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    public Time getTime(int n2) throws SQLException {
        return this.resultSet.getTime(n2);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(n2, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.resultSet.getTime(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.resultSet.getTimestamp(n2);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(n2, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(string, calendar);
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.rowsetType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public URL getURL(int n2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public URL getURL(String string) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.resultSet.getUnicodeStream(n2);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.resultSet.getUnicodeStream(string);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
        this.notifyRowSetChanged();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean last() throws SQLException {
        boolean bl = this.resultSet.last();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        boolean bl = this.resultSet.next();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    private final void notifyCursorMovement() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).cursorMoved(this.rowsetEvent);
                ++n3;
            }
        }
    }

    private final void notifyRowChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).rowChanged(this.rowsetEvent);
                ++n3;
            }
        }
    }

    private final void notifyRowSetChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).rowSetChanged(this.rowsetEvent);
                ++n3;
            }
        }
    }

    private final void notifyUpdateListeners() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).rowChanged(this.rowsetEvent);
                ++n3;
            }
        }
    }

    public boolean previous() throws SQLException {
        boolean bl = this.resultSet.previous();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public boolean relative(int n2) throws SQLException {
        boolean bl = this.resultSet.relative(n2);
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        int n2 = 0;
        while (n2 < this.listener.size()) {
            if (this.listener.elementAt(n2).equals(rowSetListener)) {
                this.listener.remove(n2);
            }
            ++n2;
        }
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.preparedStatement.setArray(n2, array);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.preparedStatement.setAsciiStream(n2, inputStream, n3);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(n2, bigDecimal);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.preparedStatement.setBinaryStream(n2, inputStream, n3);
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(n2, blob);
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.preparedStatement.setBoolean(n2, bl);
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.preparedStatement.setByte(n2, by);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.preparedStatement.setBytes(n2, byArray);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.preparedStatement.setCharacterStream(n2, reader, n3);
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.preparedStatement.setClob(n2, clob);
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n2) throws SQLException {
        this.concurrency = n2;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.preparedStatement.setDate(n2, date);
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.preparedStatement.setDate(n2, date, calendar);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.preparedStatement.setDouble(n2, d2);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.fetchDirection = n2;
        this.resultSet.setFetchDirection(this.fetchDirection);
    }

    public void setFetchSize(int n2) throws SQLException {
        this.fetchSize = n2;
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.preparedStatement.setFloat(n2, f2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.preparedStatement.setInt(n2, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.preparedStatement.setLong(n2, l2);
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        this.maxFieldSize = n2;
    }

    public void setMaxRows(int n2) throws SQLException {
        this.maxRows = n2;
    }

    public void setNull(int n2, int n3) throws SQLException {
        this.preparedStatement.setNull(n2, n3);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.preparedStatement.setNull(n2, n3, string);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.preparedStatement.setObject(n2, object);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.preparedStatement.setObject(n2, object, n3);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.preparedStatement.setObject(n2, object, n3, n4);
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.queryTimeout = n2;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
        this.connection.setReadOnly(bl);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.preparedStatement.setRef(n2, ref);
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.preparedStatement.setShort(n2, s2);
    }

    public void setString(int n2, String string) throws SQLException {
        this.preparedStatement.setString(n2, string);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.preparedStatement.setTime(n2, time);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.preparedStatement.setTime(n2, time, calendar);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(n2, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.preparedStatement.setTimestamp(n2, timestamp, calendar);
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        this.transactionIsolation = n2;
    }

    public void setType(int n2) throws SQLException {
        this.rowsetType = n2;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void updateArray(int n2, Array array) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateArray(String string, Array array) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.resultSet.updateAsciiStream(n2, inputStream, n3);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream, n2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(n2, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(string, bigDecimal);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.resultSet.updateBinaryStream(n2, inputStream, n3);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream, n2);
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(n2, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(string, bl);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.resultSet.updateByte(n2, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.resultSet.updateByte(string, by);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(n2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(string, byArray);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.resultSet.updateCharacterStream(n2, reader, n3);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader, n2);
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.resultSet.updateDate(n2, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.resultSet.updateDate(string, date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.resultSet.updateDouble(n2, d2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.resultSet.updateDouble(string, d2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.resultSet.updateFloat(n2, f2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.resultSet.updateFloat(string, f2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.resultSet.updateInt(n2, n3);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.resultSet.updateInt(string, n2);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.resultSet.updateLong(n2, l2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.resultSet.updateLong(string, l2);
    }

    public void updateNull(int n2) throws SQLException {
        this.resultSet.updateNull(n2);
    }

    public void updateNull(String string) throws SQLException {
        this.resultSet.updateNull(string);
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.resultSet.updateObject(n2, object);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.resultSet.updateObject(n2, object, n3);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.resultSet.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.resultSet.updateObject(string, object, n2);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
        this.notifyUpdateListeners();
        this.notifyRowSetChanged();
        this.notifyRowChanged();
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.resultSet.updateShort(n2, s2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.resultSet.updateShort(string, s2);
    }

    public void updateString(int n2, String string) throws SQLException {
        this.resultSet.updateString(n2, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.resultSet.updateString(string, string2);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.resultSet.updateTime(n2, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.resultSet.updateTime(string, time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(n2, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(string, timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }
}

