/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.DatumWithConnection;

public class BLOB
extends DatumWithConnection
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess dbaccess;
    int dbChunkSize;
    boolean isFree = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:25:57_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected BLOB() {
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        BLOB.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = this.getPhysicalConnection().createBlobDBAccess();
        this.dbChunkSize = -1;
    }

    public long length() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (n2 < 0 || l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
        }
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = new byte[]{};
        } else {
            long l3 = 0L;
            byte[] byArray2 = new byte[n2];
            l3 = this.getBytes(l2, n2, byArray2);
            if (l3 > 0L) {
                if (l3 == (long)n2) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l3];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l3);
                }
            }
        }
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().position(this, byArray, l2);
    }

    public long position(Blob blob, long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().position(this, (BLOB)blob, l2);
    }

    public int getBytes(long l2, int n2, byte[] byArray) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().getBytes(this, l2, n2, byArray);
    }

    public int putBytes(long l2, byte[] byArray) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setBytes(l2, byArray);
    }

    public int putBytes(long l2, byte[] byArray, int n2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setBytes(l2, byArray, 0, n2);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setBinaryStream(0L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n2;
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        int n3 = n2 = this.getChunkSize();
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static BLOB empty_lob() throws SQLException {
        return BLOB.getEmptyBLOB();
    }

    public static BLOB getEmptyBLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        return bLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        boolean bl = (this.shareBytes()[5] & 0x10) != 0;
        return bl;
    }

    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setBinaryStream(l2);
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public void trim(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.truncate(l2);
    }

    public static BLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            DatabaseError.throwSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or to DURATION_CALL");
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return BLOB.getDBAccess(oracleConnection).createTemporaryBlob(oracleConnection, bl, n3);
    }

    public static void freeTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return;
        }
        bLOB.freeTemporary();
    }

    public static boolean isTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return false;
        }
        return bLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().isOpen(this);
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().putBytes(this, l2, byArray, 0, byArray != null ? byArray.length : 0);
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().putBytes(this, l2, byArray, n2, n3);
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2);
    }

    public void truncate(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (l2 < 0L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "'len' should be >= 0. ");
        }
        this.getDBAccess().trim(this, l2);
    }

    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n2) {
        return new BLOB[n2];
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 98);
            }
            this.dbaccess = this.getInternalConnection().createBlobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
        }
        return this.dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createBlobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return super.getJavaSqlConnection();
    }
}

