/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorSettingException;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private transient String[] derivedGauge = new String[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient int[] status = new int[16];
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient Timer timer = null;

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("start", "the string monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (!this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("stop", "the string monitor is already deactivated");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int n) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.insertStringElementAt(this.derivedGauge, "", n);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n);
            this.insertintElementAt(this.status, 2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        String string3 = null;
        Object var8_7 = null;
        Object object = null;
        String string4 = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            block21: {
                try {
                    if (!this.isActive) break block21;
                    if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                        if (object == null) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if ((this.alreadyNotifieds[n] & 8) != 0) {
                            return;
                        }
                        string4 = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(n, 8);
                        throw new MonitorSettingException("The string monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        if ((this.alreadyNotifieds[n] & 1) != 0) {
                            return;
                        }
                        string4 = "jmx.monitor.error.mbean";
                        this.setAlreadyNotified(n, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        if ((this.alreadyNotifieds[n] & 2) != 0) {
                            return;
                        }
                        string4 = "jmx.monitor.error.attribute";
                        this.setAlreadyNotified(n, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mBeanException) {
                        if ((this.alreadyNotifieds[n] & 8) != 0) {
                            return;
                        }
                        string4 = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(n, 8);
                        throw new MonitorSettingException(mBeanException.getMessage());
                    }
                    catch (ReflectionException reflectionException) {
                        if ((this.alreadyNotifieds[n] & 2) != 0) {
                            return;
                        }
                        string4 = "jmx.monitor.error.attribute";
                        this.setAlreadyNotified(n, 2);
                        throw new MonitorSettingException(reflectionException.getMessage());
                    }
                    if (!(object instanceof String)) {
                        if ((this.alreadyNotifieds[n] & 4) != 0) {
                            return;
                        }
                        string4 = "jmx.monitor.error.type";
                        this.setAlreadyNotified(n, 4);
                        throw new MonitorSettingException("The observed attribute type must be a string type.");
                    }
                    this.resetAllAlreadyNotified(n);
                    this.updateDerivedGauge(object, n);
                    this.updateNotifications(n);
                }
                catch (MonitorSettingException monitorSettingException) {
                    bl = true;
                    string = string4;
                    l = this.derivedGaugeTimestamp[n];
                    string2 = monitorSettingException.getMessage();
                    string3 = this.derivedGauge[n];
                    var8_7 = null;
                    this.status[n] = 2;
                }
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, string3, var8_7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int n) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.removeStringElementAt(this.derivedGauge, n);
            this.removelongElementAt(this.derivedGaugeTimestamp, n);
            this.removeintElementAt(this.status, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.status[n] == 2) {
                if (this.derivedGauge[n].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        bl = true;
                        string = "jmx.monitor.string.matches";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        string3 = this.derivedGauge[n];
                        string4 = this.stringToCompare;
                    }
                    this.status[n] = 1;
                } else {
                    if (this.notifyDiffer) {
                        bl = true;
                        string = "jmx.monitor.string.differs";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        string3 = this.derivedGauge[n];
                        string4 = this.stringToCompare;
                    }
                    this.status[n] = 0;
                }
            } else if (this.status[n] == 0) {
                if (this.derivedGauge[n].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        bl = true;
                        string = "jmx.monitor.string.matches";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        string3 = this.derivedGauge[n];
                        string4 = this.stringToCompare;
                    }
                    this.status[n] = 1;
                }
            } else if (this.status[n] == 1 && !this.derivedGauge[n].equals(this.stringToCompare)) {
                if (this.notifyDiffer) {
                    bl = true;
                    string = "jmx.monitor.string.differs";
                    l = this.derivedGaugeTimestamp[n];
                    string2 = "";
                    string3 = this.derivedGauge[n];
                    string4 = this.stringToCompare;
                }
                this.status[n] = 0;
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, string3, string4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long l) throws IllegalArgumentException {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            super.setGranularityPeriod(l);
            if (this.isActive) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyDiffer(boolean bl) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.notifyDiffer = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyMatch(boolean bl) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.notifyMatch = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDerivedGauge(Object object, int n) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.derivedGaugeTimestamp[n] = new Date().getTime();
            this.derivedGauge[n] = (String)object;
        }
    }

    public String getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    String makeDebugTag() {
        return "StringMonitor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringToCompare(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The string to compare cannot be null.");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.stringToCompare = string;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            int n = this.indexOf(objectName);
            if (n != -1) {
                return this.derivedGaugeTimestamp[n];
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDerivedGauge(ObjectName objectName) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            int n = this.indexOf(objectName);
            if (n != -1) {
                return this.derivedGauge[n];
            }
            return null;
        }
    }

    private static class StringAlarmClock
    extends TimerTask {
        StringMonitor listener = null;

        public void run() {
            if (this.listener.isActive) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }

        public StringAlarmClock(StringMonitor stringMonitor) {
            this.listener = stringMonitor;
        }
    }
}

