/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.net.InetAddress;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.install.Setup;

public class ConfigWAS
extends Config {
    public ConfigWAS(ConfigurationData data) {
        super(data);
    }

    public void init() {
        String rmiPort = this.p_data.getProperties().getProperty("COMPIERE_JNP_PORT");
        if (rmiPort != null) {
            this.p_data.setAppsServerJNPPort(rmiPort);
        } else {
            this.p_data.setAppsServerJNPPort("2809");
        }
        this.p_data.setAppsServerJNPPort(true);
        this.p_data.setAppsServerWebPort("9080");
        this.p_data.setAppsServerWebPort(true);
        this.p_data.setAppsServerSSLPort("9443");
        this.p_data.setAppsServerSSLPort(true);
        this.p_data.setAppsServerJNPPortLabel(Setup.res.getString("JNDIPort"));
        this.p_data.setJavaType(ConfigurationData.JAVATYPE_IBM);
    }

    public String test() {
        String server = this.p_data.getAppsServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        InetAddress appsServer = null;
        String error = "Not correct: AppsServer = " + server;
        try {
            if (pass) {
                appsServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okAppsServer, "ErrorAppsServer", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: AppsServer = " + appsServer);
        this.setProperty("COMPIERE_APPS_SERVER", appsServer.getHostName());
        this.setProperty("COMPIERE_APPS_TYPE", this.p_data.getAppsServerType());
        int JNPPort = this.p_data.getAppsServerJNPPort();
        pass = !this.p_data.testPort(appsServer, JNPPort, false) && this.p_data.testServerPort(JNPPort);
        error = "Not correct: JNP Port = " + JNPPort;
        this.signalOK(this.getPanel().okJNPPort, "ErrorJNPPort", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: JNPPort = " + JNPPort);
        this.setProperty("COMPIERE_JNP_PORT", String.valueOf(JNPPort));
        int WebPort = this.p_data.getAppsServerWebPort();
        pass = !this.p_data.testPort("http", appsServer.getHostName(), WebPort, "/") && this.p_data.testServerPort(WebPort);
        error = "Not correct: Web Port = " + WebPort;
        this.signalOK(this.getPanel().okWebPort, "ErrorWebPort", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Web Port = " + WebPort);
        this.setProperty("COMPIERE_WEB_PORT", String.valueOf(WebPort));
        int sslPort = this.p_data.getAppsServerSSLPort();
        pass = !this.p_data.testPort("https", appsServer.getHostName(), sslPort, "/") && this.p_data.testServerPort(sslPort);
        error = "Not correct: SSL Port = " + sslPort;
        this.signalOK(this.getPanel().okSSLPort, "ErrorWebPort", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: SSL Port = " + sslPort);
        this.setProperty("COMPIERE_SSL_PORT", String.valueOf(sslPort));
        return null;
    }
}

