/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeButtonDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ButtonDrawData
extends DrawData {
    public ButtonDrawData() {
        this.state = new int[1];
    }

    HIThemeButtonDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeButtonDrawInfo info = new HIThemeButtonDrawInfo();
        info.version = 0;
        if ((this.style & 8) != 0) {
            info.kind = 0;
        }
        if ((this.style & 0x20) != 0) {
            info.kind = 1;
        }
        if ((this.style & 0x10) != 0) {
            info.kind = 2;
        }
        info.value = (state & 2) != 0 ? 1 : 0;
        if ((state & 8) != 0) {
            info.state = 2;
        } else if ((state & 0x10) != 0) {
            info.state = (state & 0x20) == 0 ? 1 : 7;
        } else {
            int n = info.state = (state & 0x20) == 0 ? 0 : 8;
        }
        if ((state & 0x80) != 0) {
            info.adornment |= 1;
        }
        if ((state & 4) != 0) {
            info.adornment |= 4;
        }
        return info;
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeButtonDrawInfo info = this.getInfo();
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        CGRect backRect = new CGRect();
        OS.HIThemeGetButtonBackgroundBounds(rect, info, backRect);
        rect.x += rect.x - backRect.x;
        rect.y += rect.y - backRect.y;
        rect.width -= backRect.width - rect.width;
        rect.height -= backRect.height - rect.height;
        CGRect labelRect = this.clientArea != null ? new CGRect() : null;
        OS.HIThemeDrawButton(rect, info, gc.handle, 0, labelRect);
        if (this.clientArea != null) {
            this.clientArea.x = (int)labelRect.x;
            this.clientArea.y = (int)labelRect.y;
            this.clientArea.width = (int)labelRect.width;
            this.clientArea.height = (int)labelRect.height;
        }
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        HIThemeButtonDrawInfo info = this.getInfo();
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        CGRect backRect = new CGRect();
        OS.HIThemeGetButtonBackgroundBounds(rect, info, backRect);
        rect.x += rect.x - backRect.x;
        rect.y += rect.y - backRect.y;
        rect.width -= backRect.width - rect.width;
        rect.height -= backRect.height - rect.height;
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height).contains(position) ? 0 : -1;
    }
}

