/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.registerer.preferences.internal;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.registerer.preferences.internal.RegexUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class ConditionDialog
extends Dialog {
    private static final String unclassify = "Not Classify";
    private String type = null;
    private String regex = null;
    private boolean editable = true;
    private Combo typeCombo = null;
    private Text nameText = null;
    private Text testText = null;
    private Button testBtn = null;
    private Label testLabel = null;
    private SelectionListener listener = null;

    public ConditionDialog(Shell parentShell, String type, String regex, boolean editable) {
        super(parentShell);
        if (type.equals("Unclassified")) {
            type = unclassify;
        }
        this.type = type;
        this.regex = regex;
        this.editable = editable;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = (Composite)super.createDialogArea(parent);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite(base, 2048);
        comp.setLayout((Layout)new GridLayout(4, false));
        comp.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(comp, 131072);
        GridData lgd = new GridData();
        lgd.horizontalSpan = 2;
        nameLabel.setLayoutData((Object)lgd);
        nameLabel.setText("File name(Regular expression)");
        this.nameText = new Text(comp, 2052);
        GridData ngd = new GridData(768);
        ngd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)ngd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.nameText.setEditable(this.editable);
        this.nameText.setEnabled(this.editable);
        Label typeLabel = new Label(comp, 131072);
        GridData tgd = new GridData();
        tgd.horizontalSpan = 1;
        typeLabel.setLayoutData((Object)tgd);
        typeLabel.setText("Type name");
        this.typeCombo = new Combo(comp, 8);
        ArrayList typedocs = FrameworkPlugin.getAllTypeDocuments();
        int i = 0;
        while (i < typedocs.size()) {
            if (TypeDomImpl.getDialogMode((Document)((Document)typedocs.get(i)))) {
                String tname = TypeDomImpl.getTypeName((Document)((Document)typedocs.get(i)));
                if (tname.equals("Unclassified")) {
                    tname = unclassify;
                }
                this.typeCombo.add(tname);
                this.typeCombo.setData(tname, (Object)TypeDomImpl.getPluginID((Document)((Document)typedocs.get(i))));
            }
            ++i;
        }
        GridData tcgd = new GridData(768);
        tcgd.horizontalSpan = 3;
        this.typeCombo.setLayoutData((Object)tcgd);
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Group grp = new Group(comp, 0);
        grp.setLayout((Layout)new GridLayout(4, false));
        GridData ggd = new GridData(1808);
        ggd.horizontalSpan = 4;
        grp.setLayoutData((Object)ggd);
        this.testText = new Text((Composite)grp, 2052);
        GridData ttgd = new GridData(768);
        ttgd.horizontalSpan = 3;
        this.testText.setLayoutData((Object)ttgd);
        this.testText.setText("Input test string");
        this.testText.selectAll();
        this.testText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    ConditionDialog.this.listener.widgetSelected(null);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.testBtn = new Button((Composite)grp, 0);
        GridData tbgd = new GridData();
        tbgd.horizontalSpan = 1;
        this.testBtn.setLayoutData((Object)tbgd);
        this.testBtn.setText("test");
        this.listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String teststr = ConditionDialog.this.testText.getText();
                if (teststr.length() == 0 || ConditionDialog.this.nameText.getText().length() == 0) {
                    return;
                }
                teststr = RegexUtils.convert(teststr);
                Pattern p = Pattern.compile(RegexUtils.convert(ConditionDialog.this.nameText.getText()));
                Matcher m = p.matcher(teststr);
                if (m.matches()) {
                    ConditionDialog.this.testLabel.setText("Matched.");
                } else {
                    ConditionDialog.this.testLabel.setText("Not matched.");
                }
            }
        };
        this.testBtn.addSelectionListener(this.listener);
        this.testLabel = new Label((Composite)grp, 0);
        GridData tlgd = new GridData(768);
        tlgd.horizontalSpan = 4;
        this.testLabel.setLayoutData((Object)tlgd);
        this.testLabel.setAlignment(0x1000000);
        this.typeCombo.select(0);
        if (this.type != null) {
            this.typeCombo.setText(this.type);
        }
        if (this.regex != null) {
            this.nameText.setText(this.regex);
        }
        return base;
    }

    protected void initializeBounds() {
        this.getShell().setSize(480, 240);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int button) {
        if (button == 0) {
            try {
                if (this.nameText.getText().trim().length() == 0) {
                    throw new Exception();
                }
                Pattern.compile(RegexUtils.convert(this.nameText.getText()));
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Illegal regular exp.", (String)"Illegal regular expression.");
                return;
            }
            this.regex = this.nameText.getText();
            this.type = this.typeCombo.getText();
            this.setReturnCode(button);
            this.close();
        } else if (button == 1) {
            this.setReturnCode(button);
            this.close();
        }
    }

    public String getType() {
        if (this.type.equals(unclassify)) {
            return "Unclassified";
        }
        return this.type;
    }

    public String getRegex() {
        return this.regex;
    }
}

