/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser.actions;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.projectbrowser.ProjectFileMap;
import jp.sourceforge.concierge.plugin.projectbrowser.ProjectUtils;
import jp.sourceforge.concierge.plugin.projectbrowser.RefreshDialog;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.ProjectBrowserAction;
import jp.sourceforge.concierge.plugin.registerer.preferences.RegistererPreferencePage;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshAction
extends ProjectBrowserAction {
    private boolean extContains(String ext, ArrayList<String> exts) {
        int i = 0;
        while (i < exts.size()) {
            if (ext.compareToIgnoreCase(exts.get(i)) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ArrayList<String> getAllFiles(String dir, ArrayList<String> exts) {
        ArrayList<String> files = new ArrayList<String>();
        File f = new File(dir);
        File[] cf = f.listFiles();
        int i = 0;
        while (i < cf.length) {
            if (!cf[i].getName().startsWith(".")) {
                if (cf[i].isDirectory()) {
                    files.addAll(this.getAllFiles(cf[i].getAbsolutePath(), exts));
                } else {
                    String fp = cf[i].getAbsolutePath();
                    if (this.extContains(FilenameUtils.getExtension((String)fp), exts)) {
                        files.add(cf[i].getAbsolutePath());
                    }
                }
            }
            ++i;
        }
        return files;
    }

    private ProjectFileMap createFileMap(String pfile, ArrayList<Document> pfdocs) {
        int i = 0;
        while (i < pfdocs.size()) {
            String pfp = DataDomImpl.getFilePath((Document)pfdocs.get(i));
            if (pfile.equals(pfp)) {
                return new ProjectFileMap(pfile, pfile);
            }
            ++i;
        }
        return new ProjectFileMap(pfile, null);
    }

    private ArrayList<String> getNotLinkedDocumentFiles(ArrayList<Document> pfdocs) {
        ArrayList<String> nolinkfiles = new ArrayList<String>();
        int i = 0;
        while (i < pfdocs.size()) {
            String pfp = DataDomImpl.getFilePath((Document)pfdocs.get(i));
            File f = new File(pfp);
            if (!f.exists()) {
                nolinkfiles.add(pfp);
            }
            ++i;
        }
        return nolinkfiles;
    }

    private Document getPrjDocument(ArrayList<Document> pfdocs, String file) {
        int i = 0;
        while (i < pfdocs.size()) {
            String pfp = DataDomImpl.getFilePath((Document)pfdocs.get(i));
            if (pfp.equals(file)) {
                return pfdocs.get(i);
            }
            ++i;
        }
        return null;
    }

    public RefreshAction(TableViewer pv, TableViewer cv) {
        super(pv, cv);
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection)this.projectview.getSelection();
        if (sel == null || sel.isEmpty()) {
            return;
        }
        Document prjdoc = (Document)sel.getFirstElement();
        ArrayList<Document> pfdocs = ProjectUtils.getProjectFiles(prjdoc);
        ArrayList exts = RegistererPreferencePage.getExtensions();
        String prjpath = DataDomImpl.getFilePath((Document)prjdoc);
        ArrayList<String> prjfiles = this.getAllFiles(prjpath, exts);
        ArrayList<ProjectFileMap> maps = new ArrayList<ProjectFileMap>();
        int i = 0;
        while (i < prjfiles.size()) {
            ProjectFileMap pfm = this.createFileMap(prjfiles.get(i), pfdocs);
            if (!pfm.hasDocument()) {
                maps.add(pfm);
            }
            ++i;
        }
        ArrayList<String> nolinkfiles = this.getNotLinkedDocumentFiles(pfdocs);
        ArrayList<ProjectFileMap> nomaps = new ArrayList<ProjectFileMap>();
        int i2 = 0;
        while (i2 < nolinkfiles.size()) {
            nomaps.add(new ProjectFileMap(null, nolinkfiles.get(i2)));
            ++i2;
        }
        if (maps.size() == 0 && nomaps.size() == 0) {
            MessageDialog.openInformation((Shell)this.projectview.getControl().getShell(), (String)"Not need to refresh", (String)"No need to refresh the project.");
            return;
        }
        RefreshDialog rd = new RefreshDialog(this.projectview.getControl().getShell());
        rd.setFileMap(maps);
        rd.setNoFileMap(nomaps);
        rd.setPrjDocuments(nolinkfiles);
        if (rd.open() == 1) {
            return;
        }
        ArrayList<Document> adocs = new ArrayList<Document>();
        ArrayList<Document> udocs = new ArrayList<Document>();
        Document tdoc = TypeManager.getTypeDocument((String)"Project");
        maps = rd.getFileMap();
        int i3 = 0;
        while (i3 < maps.size()) {
            ProjectFileMap pfm = maps.get(i3);
            if (!pfm.isLinked() && !pfm.isNoOperation()) {
                Document rdoc = null;
                if (pfm.needRegister()) {
                    rdoc = FrameworkPlugin.getDocumentByFilePath((String)pfm.projectfile);
                    if (rdoc == null) {
                        rdoc = DataDomImpl.createDocument((Document)tdoc);
                        DataDomImpl.setFilePath((Document)rdoc, (String)pfm.projectfile);
                        adocs.add(rdoc);
                    } else {
                        DataDomImpl.addDataOfType((Document)rdoc, (Document)tdoc);
                        udocs.add(rdoc);
                    }
                } else {
                    rdoc = this.getPrjDocument(pfdocs, pfm.docfile);
                    if (rdoc != null) {
                        DataDomImpl.setFilePath((Document)rdoc, (String)pfm.projectfile);
                        udocs.add(rdoc);
                    }
                }
            }
            ++i3;
        }
        ArrayList<Document> ddocs = new ArrayList<Document>();
        if (rd.deleteUnlinkedItems()) {
            int i4 = 0;
            while (i4 < pfdocs.size()) {
                String pfp = DataDomImpl.getFilePath((Document)pfdocs.get(i4));
                File f = new File(pfp);
                if (!f.exists()) {
                    ddocs.add(pfdocs.get(i4));
                }
                ++i4;
            }
        }
        ArrayList<Request> reqs = new ArrayList<Request>();
        if (adocs.size() > 0) {
            reqs.add(new Request(1, adocs, "data"));
        }
        if (udocs.size() > 0) {
            reqs.add(new Request(3, udocs, "data"));
        }
        if (ddocs.size() > 0) {
            reqs.add(new Request(2, ddocs, "data"));
        }
        FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.projectbrowser");
    }
}

