/*
 * CongaRequest IuWFNg
 *
 *   XmlHttpRequest găNGXgMsC
 *   MXMLf[^ responseViewer, valueSetter ֐ɂĉ߂C
 *   hLg̍XVsȂB
 * 
 *  ͂ł XML ̌`:
 *    ^O2ށBЂƂ c ^O̒  e ^OLqB
 *    e ^O̒ e ^O c ^OLq邱Ƃ͂łȂB
 *    F
 *      <c>
 *        <e>...</e>
 *        <e>...</e>
 *      </c>
 *
 *    c ^O responseViewer ֐߂Ce ^O̓e߂ valueSetter 
 *    ֐߂BresponseViewer  valueSetter p҂ɂݒ\Ȃ̂
 *    ^Ȏ͔CӐݒ\CWIɂ͈ȉ̂̂B
 *
 *    c ^Ȏ : 
 *       is-error G[݂邩ǂB
 *       message G[bZ[W
 *
 *    e ^Ȏ
 *       type Mf[^̃^CvBvalueSetter ֐̃ZN^ƂȂB
 *       id lݒ肷ΏۂƂȂIuWFNg idB
 *       is-error G[f[^ǂB
 *
 *  RXgN^F
 *     CongaRequest
 *      @param method NGXg methodiPOST ܂ GETjw肷B
 *                    w肪Ȃꍇ POST ݒ肳B
 *      @param requestForm NGXgf[^\ẑ߂ form w肷B
 *                         w肪Ȃꍇ document.forms[0] ݒ肳B
 *
 *  \bh:
 *     send(url, requestData) NGXgMsȂB
 *      @param url         NGXgM URLBwK{B
 *      @param requestData NGXgΏۃf[^BNGXgΏۃf[^
 *                         Ԃ function NGXgΏۃf[^̂
 *                         炩włB
 *                         ̈w肵ȂꍇCRXgN^ 
 *                         requestForm Ŏw肵 form ̓eMΏ
 *                         f[^ƂĎgpB
 *
 *  vpeB ( [ ]̓ftHgl ) :
 *     method NGXg̃\bh [RXgN^ method Ŏw肳ꂽl]
 *
 *     contentType NGXg ContentType [application/x-www-form-urlencoded;charset=UTF-8]
 *
 *     async 񓯊M邩ǂ [false]
 *
 *     requestForm [RXgN^ requestForm Ŏw肳ꂽl]
 *
 *     valueSetter type  valueSetter ֐̘Azz
 *        ftHgݒ:
 *          this.valueSetter["inner"] = conga_setValue2Inner;
 *          this.valueSetter["window"] = conga_setValue2Window;
 *          this.valueSetter["self"] = conga_setValue2Self;
 *          this.valueSetter["alert"] = conga_setValue4Alert;
 *          this.valueSetter["confirm"] = conga_setValue4Confirm;
 *          this.valueSetter["method"] = conga_setValue4Method;
 *          this.valueSetter["script"] = conga_setValue4Script;
 *          this.valueSetter["message"] = conga_showMessage;
 *          this.valueSetter["default"] = conga_setValue4Default;
 *
 *     responseViewer Me\邽߂̊֐ [conga_viewResponse]
 *
 *     parse XML ߂邽߂̊֐ [conga_parseXml]
 *
 *     xmlHttpRequestFactory XmlHttpRequest IuWFNg쐬֐ [conga_createXmlHttpRequest]
 *
 *     send NGXgM֐ [conga_send]
 *
 *     upload t@CAbv[hpNGXgM֐ [conga_upload]
 *
 *     download t@C_E[hpNGXgM֐ [conga_download]
 */


/**
 * CongaRequest IuWFNg̃RXgN^B
 *
 * @param method NGXg methodiPOST ܂ GETjw肷B
 *               w肪Ȃꍇ POST ݒ肳B
 * @param requestForm NGXgf[^\ẑ߂ form w肷B
 *                    w肪Ȃꍇ document.forms[0] ݒ肳B
 */
function CongaRequest(method, requestForm) {
	if(!arguments[0]) {
		method = "POST";
	}
	if(!arguments[1]) {
		requestForm = document.forms[0];
	}

	this.method = method;
	this.contentType = "application/x-www-form-urlencoded;charset=UTF-8";
	this.async = false;

	this.requestForm = requestForm;
	this.valueSetter = new Array();
	this.valueSetter["default"] = conga_setValue4Default;
	this.valueSetter["inner"] = conga_setValue2Inner;
	this.valueSetter["window"] = conga_setValue2Window;
	this.valueSetter["self"] = conga_setValue2Self;
	this.valueSetter["alert"] = conga_setValue4Alert;
	this.valueSetter["confirm"] = conga_setValue4Confirm;
	this.valueSetter["method"] = conga_setValue4Method;
	this.valueSetter["script"] = conga_setValue4Script;
	this.valueSetter["message"] = conga_showMessage;

	this.responseViewer = conga_viewResponse;
	this.parse = conga_parseXml;
	this.xmlHttpRequestFactory = conga_createXmlHttpRequest;

	this.send = conga_send;
}

/**
 * NGXgMsB
 * @param url NGXgM URLBwK{B
 * @param requestData NGXgΏۃf[^BNGXgΏۃf[^
 *                    Ԃ function NGXgΏۃf[^̂
 *                    炩włB
 *                    ̈w肵ȂꍇCRXgN^ 
 *                    requestForm Ŏw肵 form ̓eMΏ
 *                    f[^ƂĎgpB
 */
function conga_send(url, requestData) {
	if(!arguments[1]) {
		requestData = null;
	}

	var data = null;
	if(requestData instanceof Function) {
		data = requestData();
	}
	else if(requestData) {
		data = requestData;
	}
	else if(this.requestForm) {
		data = conga_getFormData(this.requestForm);
	}

	data = "_nga.async=" + ((this.async)?"true":"false") + "&" + data;

	var xmlreq = this.xmlHttpRequestFactory();
	var valueSetter = this.valueSetter;
	var responseViewer = this.responseViewer;
	var parse = this.parse;

	xmlreq.onreadystatechange =function () {
		if(xmlreq.readyState == 4 ){
			responseViewer(xmlreq, valueSetter, parse);
		}
	}

	xmlreq.open(this.method, url, this.async);
	xmlreq.setRequestHeader('Content-Type',this.contentType);
	xmlreq.send(data);
}


/**
 * XmlHttpRequest IuWFNg쐬B
 * @return XmlHttpRequest IuWFNgB
 */
function conga_createXmlHttpRequest() {
	if(window.ActiveXObject) {
		try {
			return new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch(e) {
			try {
				return new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e2) {
				return null;
			}
		}
	}
	else if(window.XMLHttpRequest) {
		var xmlhttp = new XMLHttpRequest();
		return xmlhttp;

	}
	else {
		return null;
	}
}

/**
 * Ŏw肳ꂽ form IuWFNg瑗MΏۃf[^쐬B
 * @param form MΏ formB
 * @return MΏۃf[^B
 */
function conga_getFormData(form) {
	var arr = new Array();
	var index = 0;
	var length = form.elements.length;
	for(var i = 0; i < length; i++) {
		var elem = form.elements[i];
		if(!elem.name) {
			continue;
		}

		if(index > 0) {
			arr[index++] = "&";
		}
		arr[index++] = elem.name;
		arr[index++] = "=";
		arr[index++] = elem.value;
	}
	return arr.join("");
}

/**
 * Mf[^\B
 * @param xmlreq XMLHttpRequest IuWFNgB
 * @param valueSetter CongaRequest.valueSetter (Azz)B
 * @param parse XML p[TB
 */
function conga_viewResponse(xmlreq, valueSetter, parse) {
	if(xmlreq.status!=200 || xmlreq.getResponseHeader("Content-Type").indexOf("text/xml")!=0) {
		var w = window.open("about:blank", "nga_error", "width=600,height=400,top=0,left=0,resizable=yes,scrollbars=yes,status=no");
		w.document.write(xmlreq.responseText);
		w.document.close();
		return;
	}

	var doc = xmlreq.responseXML.getElementsByTagName("c").item(0);
	parse(doc, valueSetter);
}

/**
 * XML hLg̉͂sȂB
 * @param doc hLgIuWFNgB
 */
function conga_parseXml(doc, valueSetter) {
	if(!arguments[0]) {
		doc = document.getElementsByTagName("xml").item(0).getElementsByTagName("c").item(0);
	}
	if(!arguments[1]) {
		valueSetter = this.valueSetter;
	}

	var message = doc.getAttribute("message");
	var errorc = doc.getAttribute("is-error")=="true";
	var list = doc.getElementsByTagName("e");
	var length = list.length;
	var defaultValueSetter = valueSetter["default"];

	for(var i=0; i<length; i++) {
		var item = list.item(i);
		var id = item.getAttribute("id");
		var type = item.getAttribute("type");
		var msg = item.getAttribute("message");

		if(msg && !message) {
			message = msg;
		}

		var vs = valueSetter[type];
		if(!vs) {
			vs = defaultValueSetter;
		}

		var value = null;
		if(item.firstChild) {
			value = item.firstChild.nodeValue;
		}

		vs(id, type, value, item.getAttribute("is-error")=="true", errorc, item);
	}

	if(message) {
		var vs = valueSetter["message"];
		if(!vs) {
			vs = conga_showMessage;
		}
		vs(null, "message", message, false, errorc, null);
	}
}


/**
 * type="window" ŌĂяo valueSetterB
 * VEChEJ̒ɒlo͂B
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue2Window(id, type, value, errore, errorc, etag) {
	if(!errorc) {
		var option = etag.getAttribute("option");
		if(!option) {
			option = "";
		}
		if(!id) {
			id = "window";
		}
		var w = window.open("about:blank", id, option)
		w.document.write(value);
		w.document.close();
	}
}

/**
 * type="self" ŌĂяo valueSetterB
 * ݃EChEɕ\Ăew肳ꂽlŏ㏑B
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue2Self(id, type, value, errore, errorc, etag) {
	if(!errorc) {
		document.clear();
		document.write(value);
		document.close();
	}
}

/**
 * type="inner" ŌĂяo valueSetterB
 * w肳ꂽl id Ŏw肳ꂽ^O innerHTML vpeBƂĐݒ肷B
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue2Inner(id, type, value, errore, errorc, etag) {
	var elem = document.getElementById(id);
	if(elem && !errorc) {
		if(value) {
			elem.innerHTML = value;
		}
		else {
			elem.innerHTML = "";
		}
	}
}

/**
 * type="script" ŌĂяo valueSetterB
 * w肳ꂽl javascript ƂĎsB
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue4Script(id, type, value, errore, errorc, etag) {
	if(!errorc) {
		eval(value);
	}
}

/**
 * type="method" ŌĂяo valueSetterB
 * w肳ꂽl id Ŏw肳ꂽIuWFNg̃\bhƂĎsB
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue4Method(id, type, value, errore, errorc, etag) {
	var elem = document.getElementById(id);
	var command = etag.getAttribute("command");
	if(elem && command && !errorc) {
		if(elem.handler) {
			eval("elem.handler." + command);
		}
		else {
			eval("elem." + command);
		}
	}
}

/**
 * type="alert" ŌĂяo valueSetterB
 * message Ŏw肳ꂽ alert \B
 * ܂Crequest w肳ĂꍇC̑̒l URL Ƃ݂ȂāCNGXgMsȂB
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue4Alert(id, type, value, errore, errorc, etag) {
	if(!errorc) {
		var text = etag.getAttribute("message");
		var req = etag.getAttribute("request");
		var method = etag.getAttribute("method");
		if(!method) {
			method = "POST";
		}

		window.alert(text);
		if(req){
			new CongaRequest(method).send(req, "");
		}
	}
}

/**
 * type="confirm" ŌĂяo valueSetterB
 * message Ŏw肳ꂽ confirm \B
 * ܂Crequest-if-ok w肳COK{^ꂽꍇC
 * ̑̒l URL Ƃ݂ȂāCNGXgMsȂB
 * ܂Crequest-if-cancel w肳CCancel{^ꂽꍇC
 * ̑̒l URL Ƃ݂ȂāCNGXgMsȂB
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue4Confirm(id, type, value, errore, errorc, etag) {
	if(!errorc) {
		var text = etag.getAttribute("message");
		var reqIfYes = etag.getAttribute("request-if-ok");
		var reqIfNo = etag.getAttribute("request-if-cancel");
		var method = etag.getAttribute("method");
		if(!method) {
			method = "POST";
		}

		if(window.confirm(text)) {
			new CongaRequest(method).send(reqIfYes, "");
		}
		else if(reqIfNo){
			new CongaRequest(method).send(reqIfNo, "");
		}
	}
}

/**
 * type w肪ȂꍇC邢́Cw肳Ă type ɊY valueSetter o^
 * ȂꍇɌĂяoB
 * id Ŏw肳ꂽ id IuWFNg value ƂĒlZbgB
 *
 * @param id e^O id Ŏw肳ꂽlB
 * @param type e^O type Ŏw肳ꂽlB
 * @param value e^ÕeLXglB
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB
 */
function conga_setValue4Default(id, type, value, errore, errorc, etag) {

	var elem = document.getElementById(id);

	if(!elem) {
		return;
	}

	if(errore) {
		elem.style.backgroundColor = "pink";
	}
	else {
		elem.style.backgroundColor = "white";
		if(value==null) {
			elem.value = "";
		}
		else {
			elem.value = value;
		}
	}

	var disabled = etag.getAttribute("disabled");
	if(disabled) {
		if(disabled=="true") {
			elem.disabled = true;
		}
		else {
			elem.disabled = false;
		}
	}
}

/**
 * G[bZ[W\sȂB
 *
 * @param id e^O id Ŏw肳ꂽlB(null)
 * @param type e^O type Ŏw肳ꂽlB"message"
 * @param value e^ÕeLXglB(null)
 * @param errore e^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param errorc c^O is-error  "true" ݒ肳Ăꍇ trueCȊȌꍇ falseB
 * @param etag e^Om[hIuWFNgB(null)
 */
function conga_showMessage(id, type, value, errore, errorc, etag) {
	window.alert(value);
}

