function _iwidgets_editEvent(event) {
	if(!event) {
		event = window.event;
		event.target = event.srcElement;
		event.posX = event.offsetX;
		event.posY = event.offsetY;
	}
	else {
		event.posX = event.pageX;
		event.posY = event.pageY;
	}
	return event;
}

function _iwidgets_movable_onmousedown(event){
	event = _iwidgets_editEvent(event);
	this.movable=event.target;
	if (!this.movable.handler) {
		return true;
	}

	if(event.pageX) {
		this.startX=event.posX - parseInt(this.movable.handler.target.style.left);
		this.startY=event.posY - parseInt(this.movable.handler.target.style.top);
	}
	else {
		this.startX = event.posX + 10;
		this.startY = event.posY + 16;
	}
	document.onmousemove = _iwidgets_movable_onmousemove;
	document.onmouseup = _iwidgets_movable_onmouseup;
	event.cancelBubble = true;
}

function _iwidgets_movable_onmouseup(event) {
	if(!this.movable) {
		return true;
	}

	event = _iwidgets_editEvent(event);
	this.movable = null;
	event.cancelBubble = true;
	return false;
}

function _iwidgets_movable_onmousemove(event) {
   if (!this.movable) {
      return true;
   }

   if (!this.movable.handler) {
      return true;
   }

	event = _iwidgets_editEvent(event);

	if (event.pageX) {
		if(!this.movable.type || this.movable.type=="x") {
			this.movable.handler.target.style.left = (event.pageX - this.startX);
		}
		if(!this.movable.type || this.movable.type=="y") {
			this.movable.handler.target.style.top = (event.pageY - this.startY);
		}
	}else {
		if(!this.movable.type || this.movable.type=="x") {
			this.movable.handler.target.style.left = event.clientX - this.startX + document.body.scrollLeft;
		}
		if(!this.movable.type || this.movable.type=="y") {
			this.movable.handler.target.style.top = event.clientY - this.startY + document.body.scrollTop;
		}
	}

	if(this.movable.handler.onmousemove) {
		this.movable.handler.onmousemove(this.movable.handler.target.style.left, this.movable.handler.target.style.top);
	}

	event.cancelBubble = true;
	return false;
}

////// --- IDiv --- //////

function IDiv(container, width, height) {

	var idiv = document.createElement("div");
	idiv.handler = this;
	idiv.handler.target = idiv;
	idiv.style.backgroundColor = "black";
	idiv.style.position = "absolute";
	idiv.style.fontSize = "1pt";
	idiv.style.width = width;
	idiv.style.height = height;

	container.style.position = "relative";
	container.appendChild(idiv);

	this.setPosition = function(left, top) {
		idiv.style.left = left;
		idiv.style.top = top;
	};

	this.setSize = function(width, height) {
		idiv.style.width = width;
		idiv.style.height = height;
	}

	this.setColor = function(color) {
		idiv.style.backgroundColor = color;
	}

	this.setContent = function(text) {
		idiv.innerHTML = text;
	}

	document.onmousedown = _iwidgets_movable_onmousedown;
}


////// --- IBorder --- //////

function IBorder(container, type, length, width) {
	if(!arguments[3]) {
		width = 2;
	}

	var border = document.createElement("div");
	border.handler = this;
	border.handler.target = border;
	border.style.backgroundColor = "black";
	border.style.position = "absolute";
	border.style.fontSize = "1pt";

	container.style.position = "relative";
	container.appendChild(border);

	if(type.charAt(0)=="v" || type.charAt(0)=="V" ) {
		border.type = "x";
		border.style.width = width;
		border.style.height = length;
		border.style.cursor = "e-resize";
	}
	else {
		border.type = "y";
		border.style.width = length;
		border.style.height = width;
		border.style.cursor = "n-resize";
	}

	this.setPosition = function(l, t) {
		border.style.left = l;
		border.style.top = t;
	}

	this.setLength = function(len) {
		if(type.charAt(0)=="v" || type.charAt(0)=="V" ) {
			border.style.height = len;
		}
		else {
			border.style.width = len;
		}
	}

	this.setColor = function(color) {
		border.style.backgroundColor = color;
	}

	document.onmousedown = _iwidgets_movable_onmousedown;

}



////// --- IWindow --- //////

function IWindow(title) {
	if(!arguments[0]) {
		title = "";
	}

	if(!IWindow.prototype.winList) {
		IWindow.prototype.winList = new Array();
		IWindow.prototype.hideAll = function() {
			var list = IWindow.prototype.winList;
			for(var i=0; i<list.length; i++) {
				list[i].hide();
			}
		};
		IWindow.prototype.showAll = function() {
			var list = IWindow.prototype.winList;
			for(var i=0; i<list.length; i++) {
				list[i].show();
			}
		};
	}
	IWindow.prototype.winList.push(this);
	

	var id = new Date().getTime() + Math.random();
	var titleBarId = id + '-title-bar';
	var titleId = id + '-title';
	var closeButtonId = id + '-close-button';
	var content = document.createElement("div");

	var win = document.createElement("div");
	win.className = "iwindow";
	win.id = id;
	document.body.appendChild(win);

	

	win.innerHTML = "<div class='title-bar' id='" + titleBarId + "' ><span class='l'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><span class='text' id='" + titleId + "'>" + title + "</span><span class='r' id='" + closeButtonId + "'>&nbsp;</span></div>"
	win.style.position = "absolute";

	content.style.overflow = "auto";

	win.appendChild(content);

	var title = document.getElementById(titleId);
	var titleBar = document.getElementById(titleBarId);
	var closeButton = document.getElementById(closeButtonId);

	this.titleBar = titleBar;
	this.content = content;
	titleBar.handler = this;
	titleBar.handler.target = win;

	var bottomBorder = new IBorder(document.body, "h", 100,10);
	var rightBorder = new IBorder(document.body, "v", 100,10);
	var topBorder = new IBorder(document.body, "h", 100,10);
	var leftBorder = new IBorder(document.body, "v", 100,10);

	var rightBottom = new IDiv(document.body, 10,10);
	rightBottom.target.style.cursor = "nw-resize";
	var leftBottom = new IDiv(document.body, 10,10);
	leftBottom.target.style.cursor = "sw-resize";
	var rightTop = new IDiv(document.body, 10,10);
	rightTop.target.style.cursor = "ne-resize";
	var leftTop = new IDiv(document.body, 10,10);
	leftTop.target.style.cursor = "nw-resize";

	bottomBorder.target.style.backgroundColor = "";
	rightBorder.target.style.backgroundColor = "";
	topBorder.target.style.backgroundColor = "";
	leftBorder.target.style.backgroundColor = "";
	rightBottom.target.style.backgroundColor = "";
	leftBottom.target.style.backgroundColor = "";
	rightTop.target.style.backgroundColor = "";
	leftTop.target.style.backgroundColor = "";

	var thisobj = this;
	this.onhide = null;

	this.setVisibleBorders = function(visibility) {
		bottomBorder.target.style.visibility = visibility;
		rightBorder.target.style.visibility = visibility;
		topBorder.target.style.visibility = visibility;
		leftBorder.target.style.visibility = visibility;
		rightBottom.target.style.visibility = visibility;
		leftBottom.target.style.visibility = visibility;
		rightTop.target.style.visibility = visibility;
		leftTop.target.style.visibility = visibility;
	}

	this.show = function() {
		win.style.visibility = "visible";
		thisobj.setVisibleBorders(win.style.visibility);
		thisobj.initzIndex();
	};

	this.hide = function() {
		win.style.visibility = "hidden";
		thisobj.setVisibleBorders(win.style.visibility);
		if(thisobj.onhide) {
			thisobj.onhide();
		}
	};

	this.initBorders = function() {
		var left = parseInt(win.style.left);
		var top = parseInt(win.style.top);
		var width = parseInt(win.style.width);
		var height = parseInt(win.style.height);

		bottomBorder.setPosition(left, top+height-5);
		bottomBorder.setLength(width);
		rightBorder.setPosition(left+width-5, top);
		rightBorder.setLength(height);

		topBorder.setPosition(left, top-5);
		topBorder.setLength(width);

		leftBorder.setPosition(left-5, top);
		leftBorder.setLength(height);

		rightBottom.setPosition(left+width-5, top+height-5);
		leftBottom.setPosition(left-5, top+height-5);

		rightTop.setPosition(left+width-5, top-5);
		leftTop.setPosition(left-5, top-5);
	}

	this.initBorderzIndex = function() {
		bottomBorder.target.style.zIndex = win.style.zIndex + 1;
		rightBorder.target.style.zIndex = win.style.zIndex + 2;
		topBorder.target.style.zIndex = win.style.zIndex + 3;
		leftBorder.target.style.zIndex = win.style.zIndex + 4;
		rightBottom.target.style.zIndex = win.style.zIndex + 5;
		leftBottom.target.style.zIndex = win.style.zIndex + 6;
		rightTop.target.style.zIndex = win.style.zIndex + 7;
		leftTop.target.style.zIndex = win.style.zIndex + 8;
	}

	this.initzIndex = function() {
		IWindow.prototype.maxZIndex = parseInt(IWindow.prototype.maxZIndex) + 10;
		win.style.zIndex = IWindow.prototype.maxZIndex;
		thisobj.initBorderzIndex();
	}

	this.setBounds = function(left, top, width, height) {
		if(height <= titleBar.offsetHeight) {
			thisobj.initBorders();
			return false;
		}
		if(width <= 40) {
			thisobj.initBorders();
			return false;
		}

		win.style.left = left;
		win.style.top = top;
		win.style.width = width;
		win.style.height = height;
		content.style.width = width-4;
		content.style.height = height - titleBar.offsetHeight;

		thisobj.initBorders();

		return true;
	};



	bottomBorder.onmousemove = function(left, top) {
		var h = parseInt(top) - parseInt(win.style.top);
		thisobj.setBounds(parseInt(win.style.left), parseInt(win.style.top), parseInt(win.style.width), h);
	};

	rightBorder.onmousemove = function(left, top) {
		var w = parseInt(left) - parseInt(win.style.left);
		thisobj.setBounds(parseInt(win.style.left), parseInt(win.style.top), w, parseInt(win.style.height));
	};

	topBorder.onmousemove = function(left, top) {
		var h = parseInt(win.style.height) - (parseInt(top) - parseInt(win.style.top));
		thisobj.setBounds(parseInt(win.style.left), parseInt(top), parseInt(win.style.width), h);
	};

	leftBorder.onmousemove = function(left, top) {
		var w = parseInt(win.style.width) - (parseInt(left) - parseInt(win.style.left));
		thisobj.setBounds(parseInt(left), parseInt(win.style.top), w, parseInt(win.style.height));
	};

	rightBottom.onmousemove = function(left, top) {
		var h = parseInt(top) - parseInt(win.style.top);
		var w = parseInt(left) - parseInt(win.style.left);
		thisobj.setBounds(parseInt(win.style.left), parseInt(win.style.top), w, h);
	};

	leftBottom.onmousemove = function(left, top) {
		var h = parseInt(top) - parseInt(win.style.top);
		var w = parseInt(win.style.width) - (parseInt(left) - parseInt(win.style.left));
		thisobj.setBounds(parseInt(left), parseInt(win.style.top), w, h);
	}

	rightTop.onmousemove = function(left, top) {
		var h = parseInt(win.style.height) - (parseInt(top) - parseInt(win.style.top));
		var w = parseInt(left) - parseInt(win.style.left);
		thisobj.setBounds(parseInt(win.style.left), parseInt(top), w, h);
	};

	leftTop.onmousemove = function(left, top) {
		var h = parseInt(win.style.height) - (parseInt(top) - parseInt(win.style.top));
		var w = parseInt(win.style.width) - (parseInt(left) - parseInt(win.style.left));
		thisobj.setBounds(parseInt(left), parseInt(top), w, h);
	}

	this.setTitle = function(text) {
		title.innerHTML = text;
	}

	this.setContent = function(text) {
		content.innerHTML = text;
	}

	if(IWindow.prototype.maxZIndex) {
		IWindow.prototype.maxZIndex = parseInt(IWindow.prototype.maxZIndex) + 1;
		win.style.zIndex = IWindow.prototype.maxZIndex;
	}
	else {
		if(!win.style.zIndex) {
			win.style.zIndex = 1;
		}
		IWindow.prototype.maxZIndex = win.style.zIndex;
	}
	thisobj.initBorderzIndex();

	win.onmousedown = thisobj.initzIndex;

	document.onmousedown = _iwidgets_movable_onmousedown;

	closeButton.onclick = function() {
		thisobj.hide();
	};

	this.onmousemove = function(left, top) {
		thisobj.initBorders();
	}

}
