/*
 *CongaServletAdapterMultiCaster.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet;

import java.lang.reflect.Method;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import nga.servlet.spi.CongaServletAdapter;
import nga.util.ConfigurationException;

/**
 * web.xml ɓo^ꂽS CongaServletAdapter ̌ĂяosȂB
 */
class CongaServletAdapterMultiCaster extends CongaServletAdapter {
	
	private CongaServletAdapter[] adapters;

	/**
	 * CongaServletAdapterMultiCaster 쐬B
	 */
	public CongaServletAdapterMultiCaster(
			List<Class<? extends CongaServletAdapter>> adapterClassList) {
		adapters = new CongaServletAdapter[adapterClassList.size()];
		for(int i=0; i<adapters.length; i++) {
			Class<? extends CongaServletAdapter> adapterClass = adapterClassList.get(i);
			try {
				adapters[i] = adapterClass.newInstance();
			}
			catch (Exception e) {
				throw new ConfigurationException(e);
			}
		}
	}

	/**
	 * @see CongaServletAdapter#init(CongaServlet)
	 */
	@Override
	public void init(CongaServlet servlet) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].init(servlet);
		}
	}

	/**
	 * @see CongaServletAdapter#destroy(CongaServlet)
	 */
	@Override
	public void destroy(CongaServlet servlet) {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].destroy(servlet);
		}
	}

	/**
	 * @see CongaServletAdapter#sessionCreated(ServiceInfo)
	 */
	@Override
	public void sessionCreated(ServiceInfo serviceInfo) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].sessionCreated(serviceInfo);
		}
	}

	/**
	 * @see CongaServletAdapter#sessionDestroyed(CongaServlet, HttpSession)
	 */
	@Override
	public void sessionDestroyed(CongaServlet servlet, HttpSession session) {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].sessionDestroyed(servlet, session);
		}
	}

	/**
	 * @see CongaServletAdapter#begin(ServiceInfo)
	 */
	@Override
	public void begin(ServiceInfo serviceInfo) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].begin(serviceInfo);
		}
	}

	/**
	 * @see CongaServletAdapter#end(ServiceInfo, String)
	 */
	@Override
	public void end(ServiceInfo serviceInfo, String requestId) {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].end(serviceInfo, requestId);
		}
	}

	/**
	 * @see CongaServletAdapter#abort(ServiceInfo, Throwable)
	 */
	@Override
	public void abort(ServiceInfo serviceInfo, Throwable exception) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].abort(serviceInfo, exception);
		}
	}

	/**
	 * @see CongaServletAdapter#checkParameter(ServiceInfo, Object, Method, Object[])
	 */
	@Override
	public boolean checkParameter(ServiceInfo serviceInfo, Object controller, Method method, Object[] param) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			if(!adapters[i].checkParameter(serviceInfo, controller, method, param)) {
				return false;
			}
		}
		return true;
	}

	/**
	 * @see CongaServletAdapter#editResult(ServiceInfo, Object, Method, Object)
	 */
	@Override
	public void editResult(ServiceInfo serviceInfo, Object controller, Method method, Object resultObject) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].editResult(serviceInfo, controller, method, resultObject);
		}
	}
	
	/**
	 * @see CongaServletAdapter#forwarding(ServiceInfo, String, String)
	 */
	@Override
	public void forwarding(ServiceInfo serviceInfo, String oldRequestId, String newRequestId) throws ServletException {
		for(int i=0; i<adapters.length; i++) {
			adapters[i].forwarding(serviceInfo, oldRequestId, newRequestId);
		}
	}

}
