/*
 *ErrorInfo.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.servlet;

import java.util.*;

import nga.util.Resource;

/**
 * G[B
 * ЂƂ̃G[bZ[WCЂƂ̗OC{@link ErrorInfo.Item G[}ێ邱ƂłB
 */
public class ErrorInfo extends HashMap<String, ErrorInfo.Item> {

	private static final long serialVersionUID = 1L;

	private Resource resource;
	
	/** G[bZ[W */
	private String errorMessage;

	/** O */
	private Throwable exception;
	
	/**
	 * ErrorInfo 쐬B
	 * @param resource \[XB
	 */
	public ErrorInfo(Resource resource) {
		this.resource = resource;
	}

	/**
	 * G[bZ[WZbgB
	 * @param message bZ[WB
	 * @param args bZ[WB
	 */
	public ErrorInfo setMessage(String message, Object... args) {
		if(errorMessage==null) {
			errorMessage = resource.message(message, args);
		}
		return this;
	}

	/**
	 * G[bZ[W擾B
	 * @return G[bZ[WB
	 */
	public String getErrorMessage() {
		if(errorMessage==null && getException()!=null) {
			return getException().getMessage();
		}
		return errorMessage;
	}

	/**
	 * OZbgB
	 * @param exception OB
	 */
	public void setException(Throwable exception) {
		if(errorMessage==null) {
			this.exception = exception;
		}
	}

	/**
	 * O擾B
	 * @return OB
	 */
	public Throwable getException() {
		return exception;
	}

	/**
	 * G[ڂǉB
	 * @param name G[ږB
	 */
	public ErrorInfo add(String name) {
		add(new Item(name));
		return this;
	}

	/**
	 * G[ڂǉB
	 * @param name G[ږB
	 * @param value G[ƂȂڒlB
	 */
	public ErrorInfo add(String name, String value) {
		Item item = new Item(name);
		item.setValue(value);
		add(item);
		return this;
	}

	/**
	 * G[ڂǉB
	 * @param name G[ږB
	 * @param value G[ƂȂڒlB
	 * @param message bZ[WB
	 * @param args bZ[WB
	 */
	public ErrorInfo add(String name, String value, String message, Object... args) {
		Item item = new Item(name);
		item.setValue(value);
		item.setMessage(resource.message(message, args));
		add(item);
		return this;
	}


	/**
	 * G[ڂǉB
	 * @param item G[ځB
	 */
	public ErrorInfo add(Item item) {
		put(item.getName(), item);
		return this;
	}

	/**
	 * G[ƂȂڂ̒l擾B
	 * @param name ږB
	 * @return G[ƂȂڂ̒lB
	 */	
	public Object getValue(String name) {
		Item item = get(name);
		if(item==null) {
			return null;
		}
		else {
			return item.getValue();
		}
	}
	
	/**
	 * ̃IuWFNgɐݒ肳Ă郊\[X擾B
	 * @return \[XB
	 */
	public Resource getResource() {
		return resource;
	}

	/**
	 * ̃CX^XɃG[񂪑݂邩ǂԂB
	 * @return G[񂪑݂ꍇ trueB
	 */
	public boolean hasError() {
		return errorMessage!=null || exception!=null || !isEmpty();
	}

	/**
	 * G[ځB
	 */
	public static class Item implements java.io.Serializable {

		private static final long serialVersionUID = 1L;

		/** G[ږ */
		private String name;

		/** G[ڂɐݒ肳Ăl */
		private Object value;

		/**̍ڂɊւG[bZ[W */
		private String message;

		/**
		 * G[ڂ쐬B
		 * @param name ږB
		 */
		public Item(String name) {
			this.setName(name);
		}

		/**
		 * ̍ڂ̖OZbgB
		 * @param name ̍ڂ̖OB
		 */
		private void setName(String name) {
			this.name = name;
		}

		/**
		 * ̍ڂ̖O擾B
		 * @return ̍ڂ̖OB
		 */
		public String getName() {
			return name;
		}

		/**
		 * ̍ڂɊւG[bZ[WZbgB
		 * @param message ̍ڂɊւG[bZ[WB
		 */
		public void setMessage(String message) {
			this.message = message;
		}

		/**
		 * ̍ڂɊւG[bZ[W擾B
		 * @return ̍ڂɊւG[bZ[WB
		 */
		public String getMessage() {
			return message;
		}

		/**
		 * G[ƂȂlZbgB
		 * @param value G[ƂȂlB
		 */
		public void setValue(Object value) {
			this.value = value;
		}

		/**
		 * G[ƂȂl擾B
		 * @return valueB
		 */
		public Object getValue() {
			return value;
		}

	}
}
