/*
 *InfoLogger.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.adapter;

import java.lang.reflect.Method;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.CongaServletAdapter;

/**
 * Ă΂ꂽƂɂOB
 */
public class InfoLogger extends CongaServletAdapter {
	
	private long beginingTime;
	private long checkingTime;

	/**
	 * InfoLogger 쐬B
	 */
	public InfoLogger() {
		super();
	}

	/**
	 * @see CongaServletAdapter#init(CongaServlet)
	 */
	@Override
	public void init(CongaServlet servlet) throws ServletException {
		servlet.log("init");
	}

	/**
	 * @see CongaServletAdapter#destroy(CongaServlet)
	 */
	@Override
	public void destroy(CongaServlet servlet) {
		servlet.log("destroy");
	}

	/**
	 * @see CongaServletAdapter#sessionCreated(ServiceInfo)
	 */
	@Override
	public void sessionCreated(ServiceInfo serviceInfo) throws ServletException {
		serviceInfo.getServlet().log(
			"sessionCreated (" + serviceInfo.getSession().getId() + ") " + serviceInfo.getRequestId()
		);
	}

	/**
	 * @see CongaServletAdapter#sessionDestroyed(CongaServlet, HttpSession)
	 */
	@Override
	public void sessionDestroyed(CongaServlet servlet, HttpSession session) {
		servlet.log("sessionDestroyed (" +  session.getId()  + ")");
	}

	/**
	 * @see CongaServletAdapter#begin(ServiceInfo)
	 */
	@Override
	public void begin(ServiceInfo serviceInfo) throws ServletException {
		serviceInfo.getServlet().log("begin: " + serviceInfo.getRequestId());
		beginingTime = System.currentTimeMillis();
	}

	/**
	 * @see CongaServletAdapter#end(ServiceInfo, String)
	 */
	@Override
	public void end(ServiceInfo serviceInfo, String requestId) {
		serviceInfo.getServlet().log("end:   " + requestId + " [" + (System.currentTimeMillis() - beginingTime) + "ms]");
	}

	/**
	 * @see CongaServletAdapter#abort(ServiceInfo, Throwable)
	 */
	@Override
	public void abort(ServiceInfo serviceInfo, Throwable exception) throws ServletException {
		serviceInfo.getServlet().log("abort: " + serviceInfo.getRequestId() + " [" + (System.currentTimeMillis() - beginingTime) + "ms]");
	}

	/**
	 * @see CongaServletAdapter#checkParameter(ServiceInfo, Object, Method, Object[])
	 */
	@Override
	public boolean checkParameter(ServiceInfo serviceInfo, Object controller, Method method, Object[] param) throws ServletException {
		serviceInfo.getServlet().log("exec-s:" + serviceInfo.getRequestId() + " (" + method.getDeclaringClass().getName() + "." + method.getName() + ")");
		checkingTime = System.currentTimeMillis();
		return true;
	}

	/**
	 * @see CongaServletAdapter#editResult(ServiceInfo, Object, Method, Object)
	 */
	@Override
	public void editResult(ServiceInfo serviceInfo, Object controller, Method method, Object resultObject) throws ServletException {
		serviceInfo.getServlet().log("exec-e:" + serviceInfo.getRequestId() + " (" + method.getDeclaringClass().getName() + "." + method.getName() + ") [" + (System.currentTimeMillis() - checkingTime) + "ms]");
	}
	
	/**
	 * @see CongaServletAdapter#forwarding(ServiceInfo, String, String)
	 */
	@Override
	public void forwarding(ServiceInfo serviceInfo, String oldRequestId, String newRequestId) throws ServletException {
		serviceInfo.getServlet().log("fwd   :" + oldRequestId + " -> " + newRequestId);
	}
}
