/*
 *DefaultParameterParser.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.parser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import nga.model.UpdatableByText;
import nga.servlet.NameUtil;
import nga.servlet.ServiceInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.spi.ParameterParser;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;
import nga.util.Resource;

/**
 * {@link nga.servlet.spi.ParameterParser ParameterParser} ̃ftHgB
 */
public class DefaultParameterParser implements ParameterParser {
	

	private Resource resource = new Resource("nga.servlet.dsp.Message");

	private Map<Class, PropertyValueParser> valueParserMap = new HashMap<Class, PropertyValueParser>();

	private Map<String, Object> containers = new HashMap<String, Object>(400);
	private Object topContainer;
	private PropertyInfoMap propertyInfoMap;
	
	private PropertyInfo emptyPropertyInfo = new PropertyInfo();
	
	private ObjectOperator objectOperator = new ObjectOperator();
	
	private PropertyValue propertyValue;

	/**
	 * DefaultParameterParser 쐬B
	 */
	public DefaultParameterParser() {
	}

	/**
	 * w肵NX̃vpeB邽߂ PropertyValueParser o^B
	 * @param type ΏۃNXB
	 * @param parser PropertyValueParserB
	 */
	public void registerValueParser(Class type, PropertyValueParser parser) {
		valueParserMap.put(type, parser);
		valueParserMap.put(parser.getClass(), parser);
	}

	/**
	 * @see nga.servlet.spi.ParameterParser#parse(ServiceInfo)
	 */
	public boolean parse(ServiceInfo serviceInfo) throws IOException, ServletException {
		HttpServletRequest request = serviceInfo.getRequest();
		containers.clear();
		topContainer = serviceInfo.getPageObject();
		this.propertyInfoMap = serviceInfo.getPropertyInfoMap();
		this.propertyValue = new PropertyValue(serviceInfo);
		boolean success = true;

		for(Enumeration enu = request.getParameterNames(); enu.hasMoreElements(); ) {
			@SuppressWarnings("unchecked") 
			String key = (String)enu.nextElement();
			if(key.charAt(0)=='_') { // '_' Ŏn܂镶͖B
				continue;
			}
			try {
				if(!set(key, request.getParameter(key))) {
					success = false;
				}
			}
			catch (IllegalAccessException e) {
				throw new ServletException(e);
			}
			catch (InvocationTargetException e) {
				throw new ServletException(e.getCause());
			}
		}
		return success;
	}

	/**
	 * w肳ꂽÕtB[hɒlZbgB
	 * @param fullName lZbgtB[h̖OB
	 * @param value ZbglB
	 */
	@SuppressWarnings({"unchecked"})
	private boolean set(String fullName, String value) throws IllegalAccessException, InvocationTargetException {
		Object container = getContainer(NameUtil.getContainerName(fullName));
		if(container==null) {
			// ݒΏۃReiȂ
			throw new ConfigurationException(message("m_no_container", NameUtil.getContainerName(fullName)));
		}
		
		String fieldName = NameUtil.getFieldName(fullName);

		objectOperator.init(container, fieldName, NameUtil.getIndex(fullName));


		PropertyInfo pi = propertyInfoMap.get(fieldName);
		if(pi==null) {
			emptyPropertyInfo.setName(fullName);
			pi = emptyPropertyInfo;
		}
		Object forUpdate = objectOperator.getUpdatableObject();
		propertyValue.setup(fullName, value, pi, forUpdate);

		PropertyValueParser parser = getParameterValueParser(pi, objectOperator.type);
		if(parser.parse(propertyValue)) {
			objectOperator.set(propertyValue.getObject());
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * w肳ꂽ property ^OɓK PropertyValueParser 擾B
	 * @param pi property ^OB
	 * @return ΏۃvpeB̃NXB
	 */
	private PropertyValueParser getParameterValueParser(PropertyInfo pi, Class type) {
		if(pi!=null) {
			String parserName = pi.get("parser");
			if(parserName!=null) {
				return getPropertyParser(parserName);
			}
		}
		
		PropertyValueParser parser = valueParserMap.get(type);
		if(parser==null) {
			if(UpdatableByText.class.isAssignableFrom(type)) {
				parser = PropertyValueParserCollection.FOR_TEXTCONVERTIBLE;
			}
			else {
				throw new ConfigurationException(message("m_no_parser", type.getSimpleName()));
			}
		}
		return parser;
	}
	
	/**
	 * w肳ꂽO PropertyValueParser 擾B
	 * @param parserName PropertyParser B
	 * @return PropertyValueParserB
	 */
	@SuppressWarnings("unchecked")
	private PropertyValueParser getPropertyParser(String parserName)  {
		PropertyValueParser parser = valueParserMap.get(parserName);
		if(parser==null) {
			Class c;
			try {
				c = Class.forName(parserName);
				parser = (PropertyValueParser)c.newInstance();
				valueParserMap.put(c, parser);
			}
			catch (Exception e) {
				throw new ConfigurationException(message("invalid_class", parserName), e);
			}
		}
		return parser;
	}

	
	/**
	 * w肳ꂽÕvpeB̃Rei擾 
	 * @parma name vpeBB
	 */
	@SuppressWarnings("unchecked")
	private Object getContainer(String name) throws IllegalAccessException, InvocationTargetException {
		if(name==null) {
			return topContainer;
		}

		Object o = containers.get(name);
		if(o==null) {
			Object con = getContainer(NameUtil.getContainerName(name));

			if(con==null) {
				return null; // Ȃ
			}

			Method m = MethodOperator.getGetterMethod(con.getClass(), NameUtil.getFieldName(name));
			Class rt = m.getReturnType();
			o = MethodOperator.get(m, con);
			if(o==null) {
				return null; // Ȃ
			}

			if(rt.isArray()) {
				o = Array.get(o, NameUtil.getIndex(name));
			}
			else if(List.class.isAssignableFrom(rt)) {
				o = ((List)o).get(NameUtil.getIndex(name));
			}

			containers.put(name, o);
		}

		return o;
	}

	/**
	 * bZ[WԂB
	 * @param key bZ[WB
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	private String message(String key, Object... args) {
		return resource.message(key, args);
	}


	/**
	 * IuWFNgҁB
	 */
	private class ObjectOperator{
		Class type;
		Object container;
		Method setterMethod;
		UpdatableByText object;
		Class arrayType;
		Object array;
		String fieldName;
		int index;
		
		/**
		 * ΏۃIuWFNg UpdatableByText ̏ꍇCԂB
		 * @return UpdatableByText ȃIuWFNgB
		 */
		public UpdatableByText getUpdatableObject() {
			return object;
		}
		
		/**
		 * w肳ꂽlZbgB
		 * @param value ZbglB
		 */
		@SuppressWarnings("unchecked")
		public void set(Object value) throws IllegalAccessException, InvocationTargetException {
			if(array!=null) {
				if(arrayType.isArray()) {
					Array.set(array, index, value);
				}
				else if(List.class.isAssignableFrom(arrayType)) {
					((List)array).set(index, value);
				}
				else {
					throw new ConfigurationException(message("m_invalid_list_type", fieldName, arrayType));
				}
			}
			else {
				MethodOperator.set(setterMethod, container, value);				
			}
		}
		
		/**
		 * z/Xg^̏ꍇ̏ݒsȂB
		 * @param container ReiIuWFNgB
		 * @param propertyName vpeBB
		 */
		@SuppressWarnings("unchecked")
		private void initArrayType(Object container, String propertyName) throws IllegalAccessException, InvocationTargetException {
			Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
			if(getterMethod==null) {
				throw new ConfigurationException(message("m_no_getter_method", container.getClass().getName(), propertyName));
			}
			arrayType = getterMethod.getReturnType();
			array = MethodOperator.get(getterMethod, container);
			
			if(array==null) {
				// null zɂ͐ݒłȂ
				throw new ConfigurationException(message("m_null_array", propertyName));
			}

			// z̏ꍇ
			if(arrayType.isArray()) {
				type = arrayType.getComponentType();
				if(UpdatableByText.class.isAssignableFrom(type)) {
					object = (UpdatableByText)Array.get(array, index);
				}				
			}
			// List ̏ꍇ
			else if(List.class.isAssignableFrom(arrayType)) {
				type = getClass((List)array);
				if(UpdatableByText.class.isAssignableFrom(type)) {
					object = (UpdatableByText)((List)array).get(index);
				}				
			}
			// ̑
			else {
				throw new ConfigurationException(message("m_invalid_list_type", propertyName, arrayType));
			}
		}

		/**
		 * ݒsȂB
		 * @param container ReiIuWFNgB
		 * @param propertyName vpeBB
		 * @param index CfbNXiz/Xg̏ꍇjB
		 */
		public void init(Object container, String propertyName, int index) throws IllegalAccessException, InvocationTargetException {
			this.type = null;
			this.object = null;
			this.array = null;
			this.arrayType = null;
			this.setterMethod = null;
			this.container = container;
			this.fieldName = propertyName;
			this.index = index;
			
			// index  -1 łȂꍇ́Carray ƂĐݒ肷B
			if(index>-1) {
				initArrayType(container, propertyName);
				return;
			}

			setterMethod = MethodOperator.getSetterMethod(container.getClass(), propertyName);

			if(setterMethod==null) {
				Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
				if(getterMethod==null) {
					throw new ConfigurationException(message("m_no_setter_method", container.getClass().getName(), propertyName));
				}
				type = getterMethod.getReturnType();
				if(UpdatableByText.class.isAssignableFrom(type)) {
					object = (UpdatableByText)MethodOperator.get(getterMethod, container);
				}
				else {
					throw new ConfigurationException(message("m_no_setter_method", container.getClass().getName(), propertyName));
				}
			}
			else {
				Class[] pt = setterMethod.getParameterTypes();
				if(pt==null || pt.length==0) {
					throw new ConfigurationException(message("m_invalid_setter_method", container.getClass().getName(), propertyName));
				}
				type = pt[0];
				if(UpdatableByText.class.isAssignableFrom(type)) {
					Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
					if(getterMethod!=null) {
						type = getterMethod.getReturnType();
						object = (UpdatableByText)MethodOperator.get(getterMethod, container);
					}
				}				
			}
		}

		/**
		 * Xg̗vfNX擾B
		 * @param list 擾郊XgB
		 * @return Xg̗vfNXB
		 */
		@SuppressWarnings("unchecked")
		private Class getClass(List list) {
			for(int i=0; i<list.size(); i++) {
				Object o = list.get(i);
				if(o!=null) {
					return o.getClass();
				}
			}
			return null;
		}


	}


}
