package nga.servlet.dsp.parser;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

import nga.servlet.ErrorInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.spi.ParameterParser;
import nga.util.ConfigurationException;
import nga.util.FormatUtil;
import nga.util.Resource;

/**
 * 񂩂IuWFNg֕ϊC͒ľ؂sȂB
 * @see ParameterParser
 */
public abstract class PropertyValueParser {

	/**
	 * 񂩂IuWFNg֕ϊC͒ľ؂sȂB
	 * @param propertyValue ΏۏB
	 * @return ɏI true ԂBsꍇɂ false ԂB
	 */
	public abstract boolean parse(PropertyValue propertyValue);

	/**
	 * K{͍ڃ`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkRequired(PropertyValue pv) {
		String value = pv.getValue();
		PropertyInfo constraints = pv.getPropertyInfo();
		if(value==null || value.length()==0) {
			if(!constraints.get("required", false)) {
				return true;
			}
			else {
				ErrorInfo errorInfo = pv.getErrorInfo();
				String name = pv.getName();
				String label = constraints.get("label");
				if(label!=null) {
					errorInfo.add(name, null, "m_required2", label);
				}
				else {
					errorInfo.add(name, null, "m_required1");
				}
				return false;
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ̒J}폜B
	 * @param val ΏەB
	 */
	protected String delC(String val) {
		if(val==null) {
			return null;
		}

		int len = val.length();
		if(len==0) {
			return null;
		}

		StringBuilder sb = new StringBuilder(len);
		for(int i=0; i<len; i++) {
			char c = val.charAt(i);
			if(c!=',') {
				sb.append(c);
			}
		}

		if(len!=sb.length()) {
			return new String(sb);
		}
		else {
			return val;
		}
	}

	/**
	 * lw肵͈͓̔ǂ`FbNB
	 * @param value `FbNΏۂ̒lB
	 * @param len B
	 * @return `FbN OK ȂtrueBNG ̏ꍇ falseB
	 */	
	protected boolean check(long value, int len) {
		return value < Math.pow(10, len);
	}

	/**
	 * l`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkNum(PropertyValue pv) {

		// K{̓`FbNsȂB
		if(!checkRequired(pv)) {
			return false;
		}

		PropertyInfo constraints = pv.getPropertyInfo();
		int ilen = constraints.get("ilen", -1); // 
		int flen = constraints.get("flen", -1); // 
		String label = constraints.get("label");

		String name = pv.getName();
		String value = pv.getValue();
		ErrorInfo errorInfo = pv.getErrorInfo();

		if(flen>-1) {
			//bigdecimal `FbN
			BigDecimal num = new BigDecimal(value);
			double d= num.setScale(0, BigDecimal.ROUND_DOWN).doubleValue();

			if(num.scale() > flen || d >= Math.pow(10, ilen)) {
				if(label!=null) {
						errorInfo.add(name, value, "m_ilen_flen2", ilen, flen, label);
				}
				else {
						errorInfo.add(name, value, "m_ilen_flen1", ilen, flen);
				}
				return false;
			}
			return true;
		}
		else if(ilen>0) {
			long num = Long.parseLong(value);
			if(num >= Math.pow(10, ilen)) {
				if(label!=null) {
						errorInfo.add(name, value, "m_ilen2", ilen, label);
				}
				else {
						errorInfo.add(name, value, "m_ilen1", ilen);
				}
			}
			
		}

		return true;
	}
	
	/**
	 * NumberFormatException B
	 * @param pv ΏۏB
	 * @return falseB
	 */
	protected boolean handleNumberFormatException(PropertyValue pv) {
		String label = pv.getPropertyInfo().get("label");
		String name = pv.getName();
		String value = pv.getValue();
		ErrorInfo errorInfo = pv.getErrorInfo();

		if(label!=null) {
			errorInfo.add(name, value, "m_number_format_exception2", label);
		}
		else {
			errorInfo.add(name, value, "m_number_format_exception1");
		}
		return false;
	}

	/**
	 * tϊsȂB
	 * @param pv ΏۏB
	 * @return ϊoꍇ trueBϊłȂꍇ falseB
	 */
	protected boolean toDate(PropertyValue pv, String defaultFormat) {
		if(!checkRequired(pv)) {
			return false;
		}
		
		String value = pv.getValue();
		if(value==null || value.length()==0) {
			pv.setObject(null);
			return true;
		}

		PropertyInfo pi = pv.getPropertyInfo();
		String name = pv.getName();
		ErrorInfo errorInfo = pv.getErrorInfo();

		String format = pi.get("format", defaultFormat);
		java.util.Date d = FormatUtil.parse(value, format);
		if(d==null) {
			String label = pi.get("label");
			if(label!=null) {
				errorInfo.add(name, value, "m_format_exception2", format, label);
			}
			else {
				errorInfo.add(name, value, "m_format_exception1", format);
			}
			return false;
		}
		pv.setObject(d);
		return true;
	}

	/**
	 * 񒷃`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkLength(PropertyValue pv) {
		PropertyInfo constraints = pv.getPropertyInfo();
		String value = pv.getValue();

		int length = constraints.get("length", 0);
		if(length > 0 && value.length() > length) {
			ErrorInfo errorInfo = pv.getErrorInfo();
			String name = pv.getName();
			String label = constraints.get("label");
			if(label!=null) {
				errorInfo.add(name, value, "m_length2", length, label);
			}
			else {
				errorInfo.add(name, value, "m_length1", length);
			}
			return false;
		}
		
		return true;
	}
	
	/**
	 * oCg`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkByteLength(PropertyValue pv) {
		PropertyInfo constraints = pv.getPropertyInfo();
		int bytelength = constraints.get("bytelength", 0);
		String systemEncoding = pv.getServiceInfo().getSystemEncoding();
		try {
			String value = pv.getValue();
			if(bytelength > 0 && value.getBytes(systemEncoding).length > bytelength) {
				ErrorInfo errorInfo = pv.getErrorInfo();
				String name = pv.getName();
				String label = constraints.get("label");
				if(label!=null) {
					errorInfo.add(name, value, "m_bytelength2", bytelength, label);
				}
				else {
					errorInfo.add(name, value, "m_bytelength1", bytelength);
				}
				return false;
			}
		}
		catch (UnsupportedEncodingException e) {
			throw new ConfigurationException(
				Resource.getMessage(
					"nga.servlet.dsp.Message", "m_unsupported_encoding", systemEncoding
				), e
			);
		}
		return true;
	}

	/**
	 * `FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkCharType(PropertyValue pv) {
		PropertyInfo constraints = pv.getPropertyInfo();
		String chartype = constraints.get("chartype");
		String value = pv.getValue();
		if(chartype!=null && !value.matches(chartype)) {
			ErrorInfo errorInfo = pv.getErrorInfo();
			String name = pv.getName();
			String label = constraints.get("label");
			String comment = constraints.get("chartype-comment", chartype);
			if(label!=null) {
				errorInfo.add(name, value, "m_chartype2", comment, label);
			}
			else {
				errorInfo.add(name, value, "m_chartype1", comment);
			}
			return false;
		}
		return true;
	}

}