/*
 *CSVDownloader.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;


import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;

import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.util.ConfigurationException;
import nga.util.FormatUtil;
import nga.util.MethodOperator;
import nga.util.Resource;

/**
 * CSVt@C_E[hp {@link nga.servlet.spi.ResultWriter ResultWriter}B
 */
public class CSVDownloader extends Downloader {
	
	/**
	 * ͂݋L^CvB
	 */
	public enum QuoteType {
		/** KvɉĕɈ͂݋L */ AUTO, 
		/** ɂ͕K͂݋L */ STRING, 
		/** ͂݋LȂ */ NO
	};

	/**
	 * ͂݋L^CvB
	 */
	private QuoteType quoteType = QuoteType.NO;

	/**
	 * f~^B
	 */
	private String delimiter = ",";

	/**
	 * o͐B
	 */
	private ServletOutputStream outputStream;
	
	/**
	 * o͓ȅB
	 */
	private TargetInfoList targetInfoList;

	/**
	 * CSVDownloader 쐬B
	 */
	public CSVDownloader() {
		super();
	}

	/**
	 * ͂݋L^Cvݒ肷B
	 * @param string ͂݋L^CvB
	 */
	private void setQuoteType(String type) {
		if("AUTO".equals(type)) {
			quoteType = QuoteType.AUTO;
		}
		else if("STRING".equals(type)) {
			quoteType = QuoteType.STRING;
		}
		else {
			quoteType = QuoteType.NO;
		}
	}

	/**
	 * ssB
	 */
	protected void println() throws IOException {
		outputStream.println();
	}

	/**
	 * ̏o͂sȂB
	 * @param text o͑ΏەB
	 * @param quote ͂݋Lt邩ǂB
	 */
	private void print(String text, boolean quote) throws IOException {
		outputStream.print(convert(text, quote));
		if(delimiter!=null) {
			outputStream.print(delimiter);
		}
	}

	/**
	 * o͑Ώە̐`sȂB
	 * @param text o͑ΏەB
	 * @param quote ͂݋Lt邩ǂB
	 * @return `ꂽB
	 */
	private String convert(String text, boolean quote) {
		if(text==null) {
			text = "";
		}

		boolean qt = false;

		if(quoteType==QuoteType.STRING && quote) {
			qt = true;
		}
		else if(quoteType==QuoteType.NO) {
			qt = false;
		}
		else {
			if(delimiter!=null) {
				qt = (text.indexOf(delimiter)>=0);
			}
		}

		if(qt) {
			return "\"" + text + "\"";
		}
		else {
			return text;
		}
	}


	/**
	 * w肵loB
	 * @param value olB
	 */
	public void print(String value) throws IOException {
		print(value, true);
	}

	/**
	 * w肵loB
	 * @param value olB
	 */
	public void print(long value) throws IOException {
		print(String.valueOf(value), false);
	}

	/**
	 * w肵loB
	 * @param value olB
	 */
	public void print(double value) throws IOException {
		print(String.valueOf(value), false);
	}

	/**
	 * BigDecimal loB
	 * @param value olB
	 */
	public void print(BigDecimal value) throws IOException {
		if(value==null) {
			print("", false);
		}
		else {
			print(value.toString(), false);
		}
	}

	/**
	 * w肵 BigDecimal loB
	 * @param value olB
	 * @param scale B
	 */
	public void print(BigDecimal value, int scale) throws IOException {
		if(value==null) {
			value = new BigDecimal("0");
		}

		print(value.setScale(scale, BigDecimal.ROUND_DOWN).toString(), false);
	}


	/**
	 * oB
	 * @param value olB
	 * @param fmt o͏B
	 */
	public void print(Date value, String fmt) throws IOException {
		if(value==null) {
			print("", true);
		}
		else {
			print(FormatUtil.format(value, fmt), true);
		}
	}

	/**
	 * ͂݋L̕t擾B
	 * @return ͂݋L̕tB
	 */
	public QuoteType getQuoteType() {
		return quoteType;
	}

	/**
	 * wb_o͂Kvǂ𔻒肷B
	 * @return wb_o͂Kvȏꍇ trueB
	 */
	protected boolean hasHeader() {
		for(TargetInfo targetInfo : targetInfoList) {
			if(targetInfo.get("label", null)!=null) {
				return true;
			}
		}
		return false;
	}

	/**
	 * _E[ht@C̓eo͂B
	 * @param resultInfo ʏo͏B
	 * @param outputStream o͐B
	 * @param resultObject o͂eB
	 */
	@Override
	protected void write(ResultInfo resultInfo, ServletOutputStream outputStream, Object resultObject) 
			throws IOException, ServletException {
		delimiter = resultInfo.get("delimiter", ",");
		setQuoteType(resultInfo.get("quote-type", "NO"));
		this.outputStream = outputStream;
		
		targetInfoList = resultInfo.getTargetInfoList();

		String target = resultInfo.get("target", null);
		if(target!=null) {
			for(TargetInfo info : targetInfoList) {
				if(target.equals(info.getId())) {
					targetInfoList = info.getChildren();
					try {
						resultObject = MethodOperator.get(info.getValue(), resultObject);
					}
					catch (IllegalAccessException e) {
						throw new ServletException(e);
					}
					catch (InvocationTargetException e) {
						throw new ServletException(e.getCause());
					}
					break;
				}
			}
		}

		print(resultObject);
	}

	/**
	 * w肳ꂽIuWFNg̓eo͂B
	 * @param resultObject o͑ΏۃIuWFNgB
	 * @throws IOException
	 */
	protected void print(Object resultObject) throws IOException, ServletException {
		if(hasHeader()) {
			printHeader();
		}
		
		printDetail(resultObject);
	}
	
	/**
	 * wb_̏o͂sȂB
	 */
	@SuppressWarnings("unusedThrown")
	protected void printHeader() throws IOException, ServletException {
		for(TargetInfo targetInfo : targetInfoList) {
			print(targetInfo.get("label", ""));
		}
		println();
	}
	
	/**
	 * ו̏o͂sȂB
	 * @param resultObject o͑ΏہB
	 */
	@SuppressWarnings("unchecked")
	protected void printDetail(Object resultObject) throws IOException, ServletException {
		if(resultObject==null) {
			return;
		}

		// resultObject  array ̏ / list ̏B
		if(resultObject.getClass().isArray()) {
			printArray(resultObject);
		}
		else {
			if(!(resultObject instanceof List)) {
				throw new ConfigurationException(
					Resource.getMessage(
						"nga.servlet.dsp.Message", "m_invalid_list_type",
						"Object", resultObject.getClass().getName()
					)
				);
			}
			
			printList((List)resultObject);
		}
	}

	/**
	 * z̏o͂sȂB
	 * @param resultObject o͑ΏہB
	 */
	private void printArray(Object resultObject) throws IOException, ServletException {
		Map<String, Method> methodMap = MethodOperator.getGetterMethods(resultObject.getClass().getComponentType());
		int len = Array.getLength(resultObject);
		for(int i=0; i<len ;i++) {
			printLine(methodMap, Array.get(resultObject, i));
			println();
		}
	}
	
	/**
	 * Xg̏o͂sȂB
	 * @param resultObject o͑ΏہB
	 */
	@SuppressWarnings("unchecked")
	private void printList(List resultObject)throws IOException, ServletException {
		for(int i=0; i<resultObject.size(); i++) {
			Object line = resultObject.get(i);
			if(line!=null) {
				printLine(MethodOperator.getGetterMethods(line.getClass()), line);
			}
			println();
		}
	}
	
	/**
	 * s̏o͂sȂB
	 * @param methodMap \bh̃}bvB
	 * @param line Ps̏o͓eB
	 */
	private void printLine(Map<String, Method> methodMap, Object line) throws IOException, ServletException{
		for(int i=0; i<targetInfoList.size(); i++) {
			TargetInfo ti = targetInfoList.get(i);
			
			Object o = null;
			try {
				String valueName = ti.getValue();
				if(valueName!=null) {
					o = MethodOperator.get(methodMap.get(valueName), line);
				}
				if(o==null) {
					print("");
				}
				else if(o instanceof String) {
					print((String)o);
				}
				else if(o instanceof Date) {
					print((Date)o, ti.get("format", "yyyy/MM/dd"));
				}
				else if(o instanceof BigDecimal) {
					int scale = ti.get("scale", -1);
					if(scale==-1) {
						print((BigDecimal)o);
					}
					else {
						print((BigDecimal)o, scale);
					}
				}
				else {
					print(String.valueOf(o), false);
				}
			}
			catch (IllegalAccessException e) {
				throw new ServletException(e);
			}
			catch (InvocationTargetException e) {
				throw new ServletException(e.getCause());
			}
		}
	}
}
