/*
 *Downloader.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nga.servlet.ServiceInfo;
import nga.servlet.config.ResultInfo;

/**
 * _E[hp ResultWriterB
 */
public abstract class Downloader extends AbstractResultWriter {

	/**
	 * Downloader 쐬B
	 */
	public Downloader() {
		super();
	}

	/**
	 * t@C擾B
	 * @return t@CB
	 */
	protected String getFileName(ResultInfo resultInfo) {
		return resultInfo.get("file", "test.txt");
	}

	/**
	 * ContentType wp擾B
	 * @return ContentType wpB
	 */
	protected String getContentType(ResultInfo resultInfo, String charset) {
		return resultInfo.get("content-type", "application/octet-stream; charset=" + charset);
	}

	/**
	 * @see AbstractResultWriter#handleWrite(ServiceInfo)
	 */
	@Override
	protected void handleWrite(ServiceInfo serviceInfo) throws IOException, ServletException {
		HttpServletRequest request = serviceInfo.getRequest();
		HttpServletResponse response = serviceInfo.getResponse();
		ResultInfo resultInfo = serviceInfo.getResultInfo();

		setResponseHeader(request, response, resultInfo);
		write(resultInfo, response.getOutputStream(), serviceInfo.getResultObject());
	}

	/**
	 * _E[ht@C̓eo͂B
	 * @param resultInfo ʏo͏B
	 * @param outputStream o͐B
	 * @param resultObject o͂eB
	 */
	protected abstract void write(ResultInfo resultInfo, ServletOutputStream outputStream, Object resultObject) 
			throws IOException, ServletException;

	/**
	 * Response wb_̐ݒsB
	 * @param request NGXgB
	 * @param response X|XB
	 * @param resultInfo result ^ȌB
	 */
	protected void setResponseHeader(HttpServletRequest request, HttpServletResponse response,
			ResultInfo resultInfo) {
		response.setContentType(getContentType(resultInfo, request.getCharacterEncoding()));
		response.addHeader("Content-Disposition", 
        					"attachment; filename=\"" + getFileName(resultInfo) + "\"");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Expires", "0");
	}
	
}
