/*
 * SQLImplBase.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql.impl;

import java.sql.*;
import java.lang.reflect.*;
import java.lang.reflect.Array;
import java.util.*;

import nga.util.ConfigurationException;
import nga.util.Resource;
import nga.util.MethodOperator;


/**
 * Selecter, Updater, Where NX̂߂̋ʊNXB
 */
class SQLImplBase {

	/**
	 * p^ioChϐjB
	 */
	private class Parameter {
		private boolean prefix; // % L擪ɂꍇ trueB
		private boolean suffix; // % L𖖔ɂꍇ trueB
		private int index = -1; // @0@, @1@, @2@...
		private Method getterMethod;   // p^IuWFNg getter \bhB
		private Method setterMethod;   // p^IuWFNg setter \bhB
		
		private boolean isGettable() {
			return getterMethod!=null || index>-1;
		}
	}

	/**
	 * tB[hw莞̋؂蕶B
	 */
	private static final String FIELD_SEPARATOR = "@";

	/**
	 * OUT p[^LB
	 */
	private static final char OUT = '!';
	
	/**
	 * INOUT p[^LB
	 */
	private static final char INOUT = '#';

	private PreparedStatement statement;
	private boolean debugMode;
	
	/**
	 * "FROM" ̃CfbNXB
	 */
	private int fromIndex = -1;
	
	/**
	 * "WHERE" ̃CfbNXB
	 */
	private int whereIndex = -1;

	/**
	 * PreparedStatement ɓn߂̕ύX{ SQL B
	 */
	private String parsedSQL;
	
	/**
	 * p^IuWFNg̃NXB
	 */
	private Class template;

	/**
	 * p^̃XgB
	 */
	private List<Parameter> parameterList;

	/**
	 * p҂ݒ肵 SQL B
	 */
	private StringBuilder sql;
	
	/**
	 * f[^x[XRlNVB
	 */
	protected Connection connection;

	/**
	 * SQLImplBase 쐬B
	 * @param con f[^x[XRlNVB
	 * @param sql SQLB
	 */
	public SQLImplBase(Connection con, String sql) {
		if(con==null) {
			throw new IllegalArgumentException(message("m_connection_is_null"));
		}
		this.sql = new StringBuilder();
		append(sql);
		this.connection = con;
	}
	
	/**
	 * bZ[W擾sȂB
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 */
	protected String message(String key, Object... args) {
		return Resource.getMessage(getClass().getPackage().getName() + ".SQLImplMessage", key, args);
	}

	/**
	 * p^񃊃Xg쐬B
	 * @param template p^IuWFNg̃NXB
	 */
	private void createParameterList(Class template) {
		if(this.template!=null && this.template.equals(template)) {
			return;
		}
		
		close();
		this.template = template;
		if(template==null) {
			parameterList = Collections.emptyList();
			return;
		}

		Map<String, Method> setterMethods = null;
		Map<String, Method> getterMethods = null;
		if(!template.isArray()) {
			getterMethods = MethodOperator.getGetterMethods(template);
		}


		ArrayList<Parameter> list = new ArrayList<Parameter>((getterMethods!=null)? getterMethods.size() : 10);
		StringTokenizer st =
			new StringTokenizer(new String(sql).toUpperCase(), FIELD_SEPARATOR);

		while(st.hasMoreTokens()) {
			st.nextToken(); // ŏ͓ǂݔ΂
			if(!st.hasMoreTokens()) {
				break;
			}
			
			Parameter p = new Parameter();

			// vpeBi\bhj擾
			String fieldName = st.nextToken();
			if(fieldName.length()==0) {
				throw new ConfigurationException(message("m_invalid_parameter_1"));
			}

			char c = fieldName.charAt(0);
			if(c=='%' || c==OUT || c==INOUT) {
				if(fieldName.length()==1) {
					throw new ConfigurationException(message("m_invalid_parameter_2", Character.toString(c)));
				}
				fieldName = fieldName.substring(1);

				if(c=='%') {
					p.prefix = true;
				}
				else {
					if(setterMethods==null) {
						setterMethods = MethodOperator.getSetterMethods(template);
					}
				}
			}
			
			if(fieldName.charAt(fieldName.length()-1)=='%') {
				p.suffix = true;
				fieldName = fieldName.substring(0, fieldName.length()-1);
			}				

			if(c==OUT || c==INOUT) {
				if(setterMethods!=null) {
					p.setterMethod = setterMethods.get(fieldName);
				}
			}

			if(c!=OUT) {
				if(getterMethods!=null) {
					p.getterMethod = getterMethods.get(fieldName);
				}
				parseFieldName(p, fieldName);
			}

			list.add(p);
		}
		parameterList = list;
	}
	
	private void parseFieldName(Parameter p, String fieldName) {
		if(p.getterMethod!=null) {
			return;
		}

		try {
			p.index = Integer.parseInt(fieldName);
		}
		catch(NumberFormatException e) {
			String tname = template.getName();
			throw new ConfigurationException(message("m_no_getter_method", tname, fieldName));
		}
		
	}

	/**
	 * p^ZbgB
	 * @param stmt p^Zbg StatementB
	 * @param index p^ZbgʒuB
	 * @param type p^̌^B
	 * @param value p^̒lB
	 */
	private void setParameter(PreparedStatement stmt, int index, Class type, Object value) 
			throws SQLException {
		if(value==null) {
			if(type!=null) {
				stmt.setNull(index, SQLTypes.getSQLType(type));
			}
			else {
				stmt.setNull(index, SQLTypes.getSQLType(String.class));
			}
		}

		else if(type.equals(String.class))
			stmt.setString(index, (String)value);

		else if(type.equals(int.class) || type.equals(Integer.class))
			stmt.setInt(index, ((Integer)value).intValue());

		else if(type.equals(java.math.BigDecimal.class))
			stmt.setBigDecimal(index,(java.math.BigDecimal)value);

		else if(type.equals(java.sql.Timestamp.class))
			stmt.setTimestamp(index,(java.sql.Timestamp)value);

		else if(type.equals(java.sql.Date.class))
			stmt.setDate(index,(java.sql.Date)value);

		else if(type.equals(java.sql.Time.class))
			stmt.setTime(index,(java.sql.Time)value);

		else if(type.equals(boolean.class) || type.equals(Boolean.class))
			stmt.setBoolean(index,((Boolean)value).booleanValue());

		else if(type.equals(char.class) || type.equals(Character.class))
			stmt.setString(index, String.valueOf(((Character)value).charValue()));

		else if(type.equals(long.class) || type.equals(Long.class))
			stmt.setLong(index,((Long)value).longValue());

		else if(type.equals(short.class) || type.equals(Short.class))
			stmt.setShort(index,((Short)value).shortValue());

		else if(type.equals(float.class) || type.equals(Float.class))
			stmt.setFloat(index,((Float)value).floatValue());

		else if(type.equals(double.class) || type.equals(Double.class))
			stmt.setDouble(index,((Double)value).doubleValue());

		else if(type.equals(byte.class) || type.equals(Byte.class))
			stmt.setByte(index,((Byte)value).byteValue());

		else
			stmt.setObject(index, value);
		}


	/**
	 * w肳ꂽ̒ŗLȁi󔒂łȂjŏI擾B
	 * @param sql ׂ镶B
	 * @return ŏIB
	 */
	private char getLastChar(StringBuilder sql) {
		for(int i=sql.length()-1; i>=0; i--) {
			char c = sql.charAt(i);
			if(!Character.isWhitespace(c)) {
				return c;
			}
		}
		return '\0';
	}

	/**
	 * w肳ꂽ݂ SQL ̖ɒǉB
	 * @param str ǉ镶B
	 */
	private void append(String str) {
		String s = str.toUpperCase();
		int fi = s.lastIndexOf("FROM");
		if(fi != -1) {
			fromIndex = sql.length() + fi;
		}
		int wi = s.lastIndexOf("WHERE", (fi!=-1)?fi : 0);
		if(wi != -1) {
			whereIndex = sql.length() + wi;
		}
		sql.append(str);
	}

	/**
	 * Kvɉ "WHERE" ̒ǉsB
	 * @param s
	 * @return ǉ where Ŏn܂ꍇ true ԂB
	 */
	private boolean addWhere(String s) {
		if(whereIndex==-1 || whereIndex < fromIndex) {
			String t = s.trim();
			if(t.length() < 5 || !t.substring(0,5).equalsIgnoreCase("WHERE")) {
				handleAdd("WHERE");
			}
			handleAdd(s);
			return true;
		}
		return false;
	}


	// ȉ protected \bhB

	/**
	 * p҂ݒ肵 SQL 擾B
	 * @return p҂ݒ肵 SQL B
	 */
	protected StringBuilder getUserSQL() {
		return sql;
	}

	/**
	 * PreparedStatement Ŏs\ SQL ioChϐ ? ɕϊꂽ SQLj
	 * 擾B
	 * @param template p^IuWFNg̃NXB
	 * @return PreparedStatement Ŏs\ SQL B
	 */
	protected String getParsedSQL(Class template) {
		if(parsedSQL==null) {
			createParameterList(template);
			StringBuilder sb = new StringBuilder(sql.length());

			StringTokenizer st =
				new StringTokenizer(new String(sql), FIELD_SEPARATOR);

			while(st.hasMoreTokens()) {
				sb.append(st.nextToken());
				if(st.hasMoreTokens()) {
					sb.append('?');
					st.nextToken();
				}
			}

			parsedSQL = new String(sb);
		}
		return parsedSQL;
	}

	/**
	 * fobOo͂sB
	 * fobO[hɂȂĂƂɁCWo͂Ɏw肳ꂽbZ[Wo͂B
	 * fobO[hɂȂĂȂƂɂ͉o͂ȂB
	 * @param message \郁bZ[WB
	 */
	protected void debug(String message) {
		if(isDebugMode()) {
			System.out.println(message);
		}
	}

	/**
	 * PreparedStatement 擾B
	 * @param sql PreparedStatement 쐬̂߂ɓn SQL B
	 * @return PreparedStatementB
	 */
	protected PreparedStatement prepareStatement(String sql) throws SQLException {
		if(statement!=null) {
			statement.clearParameters();
			return statement;
		}
		else {
			statement = prepareStatement(connection, sql);
			return statement;
		}
	}
	
	/**
	 * PreparedStatement 擾B
	 * @param con f[^x[XRlNVB
	 * @param sql PreparedStatement 쐬̂߂ɓn SQL B
	 * @return PreparedStatementB
	 */
	protected PreparedStatement prepareStatement(Connection con, String sql) throws SQLException {
		return con.prepareStatement(sql);
	}


	/**
	 * SQL sԂ̌vJnB
	 */
	protected long start() {
		if(isDebugMode()) {
			System.out.print("**** START SQL EXEC: ");
		}
		return System.currentTimeMillis();
	}

	/**
	 * SQL sԂ̌vIo͂B
	 * @param startTime JnB
	 */
	protected void end(long startTime) {
		if(isDebugMode()) {
			debug("**** ENDED SQL EXEC: " + 
				(System.currentTimeMillis() - startTime) + "(ms)");
		}
	}

	/**
	 * w肳ꂽ PreparedStatement Ƀp^IuWFNg̓eZbgB
	 * @param ps ݒΏۂƂȂ PreparedStatementB
	 * @param parameters ݒeƂȂp^IuWFNgB
	 */
	protected void setParameter(PreparedStatement ps, Object parameters) 
			throws IllegalAccessException, InvocationTargetException, SQLException {
		for(int i=0; i<parameterList.size(); i++) {
			Parameter p = parameterList.get(i);

			if(p.setterMethod!=null) {
				Class type = p.setterMethod.getParameterTypes()[0];
				registerOutParameter((CallableStatement)ps, i+1, type);
			}

			if(p.isGettable()) {
				Object o = getObject(p, parameters);
				Class type = null;
				if(p.getterMethod!=null) {
					type = p.getterMethod.getReturnType();
				}
				else {
					type = (o!=null)? o.getClass() : Object.class;
				}

				if(p.prefix && p.suffix) {
					o = "%" + o + "%";
				}
				else if(p.prefix) {
					o = "%" + o;
				}
				else if(p.suffix) {
					o = o + "%";
				}

				setParameter(ps, i+1, type, o);				
			}
		}
	}
	
	/**
	 * ps Ɋi[ꂽsʂ obj ɃZbgBB
	 * @param ps
	 * @param obj
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 * @throws SQLException
	 */
	protected void getResult(CallableStatement ps, Object obj)
		throws IllegalAccessException, InvocationTargetException, SQLException {
		for(int i=0; i<parameterList.size(); i++) {
			Parameter p = parameterList.get(i);
			if(p.setterMethod!=null) {
				Object o = getResult(ps, p.setterMethod.getParameterTypes()[0], i+1);
				MethodOperator.set(p.setterMethod, obj, o);
			}
		}
	}
	
	private Object getResult(CallableStatement rs, Class type, int index) throws SQLException{
		if(type.equals(String.class))
			return rs.getString(index);

		else if(type.equals(int.class))
			return new Integer(rs.getInt(index));

		else if(type.equals(java.math.BigDecimal.class))
			return rs.getBigDecimal(index);

		else if(type.equals(java.sql.Timestamp.class))
			return rs.getTimestamp(index); 

		else if(type.equals(java.sql.Date.class))
			return rs.getDate(index);

		else if(type.equals(java.sql.Time.class))
			return rs.getTime(index);

		else if(type.equals(boolean.class))
			return new Boolean(rs.getBoolean(index));

		else if(type.equals(char.class)) {
			String s = rs.getString(index);
			if(rs.wasNull()) {
				return new Character('\0');
			}
			else {
				if(s!=null && s.length()>0) {
					return new Character(s.charAt(0));
				}
				else {
					return new Character('\0');
				}
			}
		}

		else if(type.equals(long.class))
			return new Long(rs.getLong(index));

		else if(type.equals(short.class))
			return new Short(rs.getShort(index));

		else if(type.equals(float.class))
			return new Float(rs.getFloat(index));

		else if(type.equals(double.class))
			return new Double(rs.getDouble(index));

		else if(type.equals(byte.class))
			return new Byte(rs.getByte(index));

		else if(type.equals(Integer.class))
			{
			int i = rs.getInt(index);
			if(rs.wasNull())
				return null;
			else
				return new Integer(i);
			}

		else if(type.equals(Boolean.class))
			{
			boolean b = rs.getBoolean(index);
			if(rs.wasNull())
				return null;
			else
				return new Boolean(b);
			}

		else if(type.equals(Long.class))
			{
			long l = rs.getLong(index);
			if(rs.wasNull())
				return null;
			else
				return new Long(l);
			}

		else if(type.equals(Short.class))
			{
			short s = rs.getShort(index);
			if(rs.wasNull())
				return null;
			else
				return new Short(s);
			}

		else if(type.equals(Float.class))
			{
			float f = rs.getFloat(index);
			if(rs.wasNull())
				return null;
			else
				return new Float(f);
			}

		else if(type.equals(Double.class))
			{
			double d = rs.getDouble(index);
			if(rs.wasNull())
				return null;
			else
				return new Double(d);
			}


		else if(type.equals(Byte.class))
			{
			byte b = rs.getByte(index);
			if(rs.wasNull())
				return null;
			else
				return new Byte(b);
			}

		else if(type.equals(Character.class)) {
			String s = rs.getString(index);
			if(rs.wasNull()) {
				return null;
			}
			else {
				if(s.length()>0) {
					return new Character(s.charAt(0));
				}
				else {
					return null;
				}
			}
		}
		else {
			return rs.getObject(index);
		}
	}
	
	/**
	 * @param ps
	 * @param i
	 * @param type
	 * @param o
	 * @throws SQLException 
	 */
	private void registerOutParameter(CallableStatement ps, int i, Class type) throws SQLException {
		ps.registerOutParameter(i, SQLTypes.getSQLType(type));
	}

	private Object getObject(Parameter p, Object parameters) throws IllegalAccessException, InvocationTargetException {
		if(p.index>-1) {
			return Array.get(parameters, p.index);
		}

		if(parameters!=null && parameters.getClass().isArray()) {
			parameters = Array.get(parameters, 0);
		}

		return MethodOperator.get(p.getterMethod, parameters);		
	}

	/**
	 * ݍ쐬Ă Statement N[YB
	 */
	protected void close() {
		try {
			if(statement!=null) {
				statement.close();
				statement = null;
			}
		}
		catch(Exception e) {
		}
	}


	/**
	 * s SQL Ƀp^IuWFNg̓eWJăfobO\B
	 * @param sql s SQL B
	 * @param params p^IuWFNgB
	 */
	protected void printSQL(String sql, Object params) {
		if(!isDebugMode()) {
			return;
		}

		try {
			StringBuilder sb = new StringBuilder(sql.length() + 100);
			if(params==null) {
				sb.append(sql);
			}
			else {
				StringTokenizer st = new StringTokenizer(sql, "?");
	
				for(int i=0; st.hasMoreTokens(); i++) {
					sb.append(st.nextToken());
					if(parameterList!=null && i < parameterList.size()) {
						Parameter p = parameterList.get(i);
						if(!p.isGettable()) {
							sb.append("?");
						}
						else {
							sb.append('\'');
							if(p.prefix) {
								sb.append("%");
							}
							sb.append(getObject(p, params));
							if(p.suffix) {
								sb.append("%");
							}
							sb.append('\'');
						}
					}
				}
			}

			sb.append(';');
			debug(new String(sb));
		}
		catch(Exception e) {
		}
	}


	/**
	 * ݂ Where ɂ܂񂪎w肳ĂȂꍇ true ԂB
	 * @return ݂ Where ɂ܂񂪎w肳ĂȂꍇ trueB
	 */
	protected boolean isEmpty() {
		return sql.length()==0;
	}

	/**
	 * ݂ SQL ̖ɕǉB
	 * @param s SQL̖ɒǉ镶B
	 */
	protected SQLImplBase handleAdd(String s) {
		parsedSQL = null;
		sql.append(' ');
		append(s);
		return this;
	}

	/**
	 * ݂ SQL ̖Ɂu"AND " + w肵vǉB<br>
	 * @param s SQL ̖ɒǉ镶B
	 */
	protected SQLImplBase handleAnd(String s) {
		if(addWhere(s)) {
			return this;
		}

		if(getLastChar(sql)=='('){
			handleAdd(s);
		}
		else {
			handleAdd("AND " + s);
		}
		return this;
	}

	/**
	 * ݂ SQL ̖Ɂu"OR " + w肵vǉB<br>
	 * @param s SQL ̖ɒǉ镶B
	 */
	protected SQLImplBase handleOr(String s) {
		if(addWhere(s)) {
			return this;
		}

		if(getLastChar(sql)=='('){
			handleAdd(s);
		}
		else {
			handleAdd("OR " + s);
		}
		return this;
	}

	

	// ȉ public \bhB

	/**
	 * ݃fobO[hǂ𒲂ׂB
	 * @return fobO[hȂ trueBfobO[hłȂ falseB
	 */
	public boolean isDebugMode() {
		return debugMode;
	}

	/**
	 * fobOԂݒ肷B
	 * @param mode fobO[h̏ꍇ true w肷B
	 */
	public void setDebugMode(boolean mode) {
		debugMode = mode;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return new String(sql);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void finalize() throws Throwable {
		close();
		super.finalize();
	}


	/**
	 * p^IuWFNg̃NX擾B
	 * @param o
	 * @return
	 */
	protected Class getTemplate(Object[] o) {
		if(o==null) {
			return null;
		}
		else if(o.length==1) {
			return Array.get(o, 0).getClass();
		}
		else {
			return o.getClass();
		}
	}
}
