/*
 * SQLTypes.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql.impl;

import java.sql.Types;

/**
 * Java f[^^SQL f[^^̑ΉtsB
 */
class SQLTypes {

	/*
	 * String --> SQLType ϊŎg^
	 */
	static int CharType = Types.VARCHAR;

	/*
	 * byte[] --> SQLType ϊŎg^
	 */
	static int BinType = Types.VARBINARY;



	/**
	 * Java NX SQL f[^^
	 * \萔(java.sql.Types Q)擾B
	 *
	 * @param Java NX
	 * @return SQL f[^^\萔
	 * @see java.sql.Types
	 */
	public static int getSQLType(Class javatype) {
		if(javatype.equals(String.class))
			return CharType;
		else if(javatype.equals(int.class) ||
				javatype.equals(Integer.class))
			return Types.INTEGER;
		else if(javatype.equals(long.class) ||
				javatype.equals(Long.class))
			return Types.BIGINT;
		else if(javatype.equals(float.class) ||
				javatype.equals(Float.class))
			return Types.REAL;
		else if(javatype.equals(double.class) ||
				javatype.equals(Double.class))
			return Types.DOUBLE;
		else if(javatype.equals(short.class) ||
				javatype.equals(Short.class))
			return Types.SMALLINT;
		else if(javatype.equals(byte.class) ||
				javatype.equals(Byte.class))
			return Types.TINYINT;
		else if(javatype.equals(boolean.class) ||
				javatype.equals(Boolean.class))
			return Types.BIT;
		else if(javatype.equals(java.math.BigDecimal.class))
			return Types.NUMERIC;
		else if(javatype.equals(java.sql.Date.class))
			return Types.DATE;
		else if(javatype.equals(java.sql.Time.class))
			return Types.TIME;
		else if(javatype.equals(java.sql.Timestamp.class) ||
				java.util.Date.class.isAssignableFrom(javatype))
			return Types.TIMESTAMP;
		else return Types.OTHER;
	}




	/**
	 * SQL f[^^\萔 Java NX擾B
	 *
	 * @param sqltype SQL f[^^\萔
	 * @param nullable Null ɂł邩ǂ
	 * @return Java NX
	 * @see java.sql.Types
	 */
	public static Class getJavaType(int sqltype, boolean nullable) {
		switch(sqltype) {
			case Types.BIGINT: 	return (nullable)?Long.class:long.class;
			case Types.BIT: 	return (nullable)?Boolean.class:boolean.class;
			case Types.CHAR: 	return String.class;
			case Types.DATE: 	return java.sql.Date.class;
			case Types.DECIMAL: return java.math.BigDecimal.class;
			case Types.DOUBLE: 	return (nullable)?Double.class:double.class;
			case Types.FLOAT: 	return (nullable)?Double.class:double.class;
			case Types.INTEGER: return (nullable)?Integer.class:int.class;
			case Types.LONGVARCHAR: return String.class;
			case Types.NUMERIC: return java.math.BigDecimal.class;
			case Types.REAL: 	return (nullable)?Float.class:float.class;
			case Types.SMALLINT: return (nullable)?Short.class:short.class;
			case Types.TIME: 	return java.sql.Time.class;
			case Types.TIMESTAMP: return java.sql.Timestamp.class;
			case Types.TINYINT: return (nullable)?Byte.class:byte.class;
			case Types.VARCHAR: return String.class;
			default: 			return Object.class;
		}
	}

}
