/*
 * SelecterImpl.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql.impl;

import java.util.*;
import java.sql.*;
import java.lang.reflect.*;

import nga.sql.Selecter;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;


/**
 * Selecter ̎NXB
 */
public class SelecterImpl<R> extends SQLImplBase implements Selecter<R>{

	/**
	 * ʊi[IuWFNgp setter \bh̃XgB
	 */
	private List<Method> methodList;

	/**
	 * ʊi[IuWFNg̃NXB
	 */
	private Class<? extends R> resultClass;

	private Where where;
	private int queryTimeout = -1;
	private int maxRows = Integer.MAX_VALUE;
	private boolean exceeded;

	/**
	 * SelecterImpl 쐬B
	 * @param con f[^x[XRlNVB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 */
	public SelecterImpl(Connection con, Class<? extends R> resultClass, String sql) {
		this(con, resultClass, sql, (Object[])null);
	}

	/**
	 * SelecterImpl 쐬B
	 * @param con f[^x[XRlNVB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @param parameterObject SQL ɖߍޒli[Ăp^IuWFNgB
	 */
	public SelecterImpl(Connection con, Class<? extends R> resultClass, String sql, Object... parameterObject) {
		super(con, "");
		this.resultClass = resultClass;
		createWhere(sql, parameterObject);
	}
	
	/**
	 * p^IuWFNg̍ւsB
	 * @param parameterObject SQL ɖߍޒli[Ăp^IuWFNgB
	 */
	public void setParameter(Object... parameterObject) {
		where.setParameter(parameterObject);
	}

	/**
	 * NG[̃^CAEgԁibj擾B
	 * @return NG[̃^CAEgԁibjB
	 */
	public int getQueryTimeout() {
		return queryTimeout;
	}

	/**
	 * NG[̃^CAEgԁibjZbgB
	 * @param queryTimeout NG[̃^CAEgԁibjB
	 */
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
	}


	/**
	 * ʂ̍ős擾B
	 * @return ʂ̍ősB
	 */
	public int getMaxRows() {
		return maxRows;
	}

	/**
	 * ʂ̍ősZbgB
	 * @param maxRows ʂ̍ősB
	 */
	public void setMaxRows(int maxRows) {
		this.maxRows = maxRows;
	}


	/**
	 * ʊi[IuWFNgp setter \bh̃Xg쐬B
	 * @param resultClass ʊi[IuWFNg̃NXB
	 */
	private void createMethodList() {
		if(methodList!=null) {
			return;
		}
		
		if(resultClass==null) {
			methodList = Collections.emptyList();
			return;
		}

		Map<String, Method> fieldMap = MethodOperator.getSetterMethods(resultClass);

		String temp = new String(where.getUserSQL()).toUpperCase();
		int index = temp.indexOf(" FROM ");
		if(index==-1) {
			throw new ConfigurationException(message("m_not_found_from", temp));
		}

		ArrayList<Method> list = new ArrayList<Method>(fieldMap.size());
		temp = temp.substring(0, index);

		// ֐̋Lq͉͑Ώە񂩂珜O
		if(temp.indexOf('(')>-1) {
			temp = removeFunc(temp);
		}

		StringTokenizer st = new StringTokenizer(temp, ",");
		for(int i=0; st.hasMoreTokens(); i++) {
			String s = st.nextToken().trim();
			s = s.substring(s.lastIndexOf(' ') + 1);
			int dotIndex = s.lastIndexOf('.');
			if(dotIndex>0) {
				s = s.substring(dotIndex+1);
			}
			Method field = fieldMap.get(s);
			if(field==null) {
				throw new ConfigurationException(message("m_no_setter_method", resultClass.getName(), s));
			}
			list.add(field);
		}
		methodList = list;
	}

	/**
	 * SELECT Ώۍږ̒o̍ۂɁC(...) ̕ SELECT Ώۍڂ珜OB
	 * @param s ͑ΏەB
	 * @return O̕B
	 */
	private String removeFunc(String s) {
		StringBuilder sb = new StringBuilder(s.length());
		int start = 0;
		for(int i=0; i<s.length(); i++) {
			char c = s.charAt(i);
			if(c=='(') {
				sb.append(s.substring(start, i));
				i = skip(s, i+1);
				start = i;
			}
		}
		sb.append(s.substring(start));
		return new String(sb);
	}

	/**
	 * ')' TC̎̈ʒuԂB
	 * @param s ͑ΏەB
	 * @param start ͊JnʒuB
	 * @return@')' ̎̈ʒuB
	 */
	private int skip(String s, int start) {
		int cnt = 0;
		for(int i=start; i<s.length(); i++) {
			char c = s.charAt(i);
			if(c=='(') {
				cnt++;
			}
			else if(c==')') {
				if(cnt<=0) {
					return i+1;
				}
				else {
					cnt--;
				}
			}
		}
		return s.length();
	}

	/**
	 * ݂ SQL ̖ɕǉB
	 * @param s SQL ̖ɒǉ镶B
	 * @return ݂ SQL IuWFNgB
	 */
	public Selecter<R> add(String s) {
		where.handleAdd(s);
		return this;
	}

	/**
	 * ݂ SQL ̖Ɂu"AND " + w肵vǉB<br>
	 * AC݂ SQL ̖̕ '(' ꍇ́C"AND" ͒ǉC
	 * w肳ꂽ݂̂ǉBB
	 * @param s SQL ̖ɒǉ镶B
	 * @return ݂ SQL IuWFNgB
	 */
	public Selecter<R> and(String s) {
		where.handleAnd(s);
		return this;
	}

	/**
	 * ݂ SQL ̖Ɂu"OR " + w肵vǉB<br>
	 * AC݂ SQL ̖̕ '(' ꍇ́C"OR" ͒ǉC
	 * w肳ꂽ݂̂ǉBB
	 * @param s SQL ̖ɒǉ镶B
	 * @return ݂ SQL IuWFNgB
	 */
	public Selecter<R> or(String s) {
		where.handleOr(s);
		return this;
	}

	
	/**
	 * V Where IuWFNgC Selecter ɃZbgB
	 * @param sql Where \镶B
	 * @param params Where ɖߍޒli[Ăp^IuWFNgB
	 */
	private Where createWhere(String sql, Object... params) {
		where = new Where(connection, sql, params);
		where.setDebugMode(isDebugMode());
		return where;
	}

	/**
	 * PreparedStatement Ŏs\ SQL ioChϐ ? ɕϊꂽ SQLj
	 * 擾B
	 * @param count true ̏ꍇ́Ccount pB
	 * @return 쐬 SQL B
	 */
	private String getParsedSQL(boolean count)  {
		createMethodList();
		String sql = where.getParsedSQL();
		if(count) {
			int index = new String(sql).toUpperCase().indexOf(" FROM ");
			return "SELECT COUNT(*) FROM " + sql.substring(index+6);
		}
		else {
			return sql;
		}
	}

	/**
	 * SELECT sCw肳ꂽNX̃CX^XXgɊi[ĕԂB
	 * @return SQLsʂi[XgBʂ 0 ̏ꍇ́Cvf 0 ̃XgƂȂB
	 */
	public List<R> find() throws SQLException {
		return find(new ArrayList<R>(100));
	}

	/**
	 * SELECT sCw肳ꂽXgɊi[ĕԂB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param list ʂ̊i[惊XgB
	 * @return  list Ɠ̃CX^XB
	 */
	public List<R> find(List<R> list) throws SQLException {
		if(list == null) {
			throw new IllegalArgumentException(message("m_argument_is_null"));
		}
		if(resultClass == null) {
			throw new IllegalArgumentException(message("m_resultclass_is_null"));
		}

		long startTime = start();
		ResultSet rs = null;
		try {
			rs = executeQuery(false);

			int maxRows = getMaxRows();
			for(int i=0; i<maxRows && rs.next(); i++) {
				R o = resultClass.newInstance();
				list.add(createResult(rs, o));
			}
			
			if(rs.next()) {
				setExceeded(true);
			}

			return list;
		}
		catch (InstantiationException e) {
			throw new ConfigurationException(e.getMessage(), e);
		} 
		catch (IllegalAccessException e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
		finally {
			close(rs);
			end(startTime);
		}
	}

	/**
	 * SELECT sCw肳ꂽIuWFNgɊi[ĕԂB
	 * ʂ 2 ȏ゠ꍇ́C1 ڂ̂ݎw肳ꂽIuWFNgɊi[B
	 * ̍ہC{@link #isExceeded() } ĂяoƁCtrue ԂB
	 * @return  object Ɠ̃CX^XBACʂ 0 ̏ꍇ́CnullB
	 */
	public R find(R object) throws SQLException {
		if(object == null) {
			throw new IllegalArgumentException(message("m_argument_is_null"));
		}
		if(resultClass == null) {
			throw new IllegalArgumentException(message("m_resultclass_is_null"));
		}

		long startTime = start();
		ResultSet rs = null;
		try {
			rs = executeQuery(false);
			
			if(!rs.next()) {
				return null; // ʃ[B
			}
			
			createResult(rs, object);

			if(rs.next()) {
				setExceeded(true); // ʂQȏ゠B
			}

			return object;
		}
		finally {
			close(rs);
			end(startTime);
		}

	}
	


	/**
	 * w肵 SELECT uSELECT COUNT(*) `vɕϊĎsC
	 * ̌擾B
	 * @return sʌB
	 */
	public int count() throws SQLException  {
		long startTime = start();
		ResultSet rs = null;
		try {
			rs = executeQuery(true);

			boolean b = rs.next();
			if(!b) {
				return 0;
			}
			else {
				return rs.getInt(1);
			}
		}
		finally {
			close(rs);
			end(startTime);
		}
	}
	
	/**
	 * SELECT sē ResultSet ̂܂܎擾B
	 * ̃\bhŎ擾 ResultSet ́@{@link #close(ResultSet)} \bhŃN[YKvB
	 * @return ResultSetB
	 */
	public ResultSet getResultSet() throws SQLException {
		long startTime = start();
		try {
			return executeQuery(false);
		}
		finally {
			end(startTime);
		}
	}

	/**
	 * sB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param count count̏ꍇ trueB
	 * @return ResultSet ʁB
	 */
	private ResultSet executeQuery(boolean count) throws SQLException {
		try {
			setExceeded(false);
			String sql = getParsedSQL(count);
			PreparedStatement ps = prepareStatement(sql);
	
			if(getQueryTimeout()>-1) {
				ps.setQueryTimeout(getQueryTimeout());
			}
			
			if(getMaxRows()!=Integer.MAX_VALUE) {
				ps.setMaxRows(getMaxRows() + 1);
			}
	
			if(where!=null) {
				where.setParameter(ps);
			}
	
			if(where!=null) {
				where.printSQL(sql);
			}
			else {
				this.printSQL(sql, null);
			}
	
			return ps.executeQuery();
		}
		catch(InvocationTargetException e) {
			throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
		}
		catch (IllegalAccessException e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
	}

	/**
	 * {@link #getResultSet() getResultSet()} \bhŎ擾 ResultSet  Statement N[YB
	 * @param rs N[Y ResultSetB
	 */
	public void close(ResultSet rs) {
		try {
			if(rs!=null) {
				rs.close();
			}
		}
		catch(Exception e) {
		}
		close();
	}

	/**
	 * ResultSet ̓eʃIuWFNgɊi[B
	 * @param rs ResultSet
	 * @param result i[挋ʃIuWFNgB
	 * @return i[ꂽʃIuWFNgB
	 * @throws SQLException
	 */
	private R createResult(ResultSet rs, R result) throws SQLException {
		try {
			for(int i=0; i<methodList.size() ; i++) {
				MethodOperator.set(methodList.get(i), result, 
					getResult(rs, methodList.get(i). getParameterTypes()[0], i+1));
			}
			return result;
		}
		catch(InvocationTargetException e) {
			throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
		}
		catch (IllegalAccessException e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
	}


	/**
	 * ResultSet ̎w񂩂f[^擾B
	 * @param rs ResultSetB
	 * @param type IuWFNǧ^B
	 * @param index ԍB
	 * @return 擾ꂽf[^B
	 */
	private Object getResult(ResultSet rs, Class type, int index) throws SQLException {
		if(type.equals(String.class))
			return rs.getString(index);

		else if(type.equals(int.class))
			return new Integer(rs.getInt(index));

		else if(type.equals(java.math.BigDecimal.class))
			return rs.getBigDecimal(index);

		else if(type.equals(java.sql.Timestamp.class))
			return rs.getTimestamp(index); 

		else if(type.equals(java.sql.Date.class))
			return rs.getDate(index);

		else if(type.equals(java.sql.Time.class))
			return rs.getTime(index);

		else if(type.equals(boolean.class))
			return new Boolean(rs.getBoolean(index));

		else if(type.equals(char.class)) {
			String s = rs.getString(index);
			if(rs.wasNull()) {
				return new Character('\0');
			}
			else {
				if(s!=null && s.length()>0) {
					return new Character(s.charAt(0));
				}
				else {
					return new Character('\0');
				}
			}
		}

		else if(type.equals(long.class))
			return new Long(rs.getLong(index));

		else if(type.equals(short.class))
			return new Short(rs.getShort(index));

		else if(type.equals(float.class))
			return new Float(rs.getFloat(index));

		else if(type.equals(double.class))
			return new Double(rs.getDouble(index));

		else if(type.equals(byte.class))
			return new Byte(rs.getByte(index));

		else if(type.equals(Integer.class))
			{
			int i = rs.getInt(index);
			if(rs.wasNull())
				return null;
			else
				return new Integer(i);
			}

		else if(type.equals(Boolean.class))
			{
			boolean b = rs.getBoolean(index);
			if(rs.wasNull())
				return null;
			else
				return new Boolean(b);
			}

		else if(type.equals(Long.class))
			{
			long l = rs.getLong(index);
			if(rs.wasNull())
				return null;
			else
				return new Long(l);
			}

		else if(type.equals(Short.class))
			{
			short s = rs.getShort(index);
			if(rs.wasNull())
				return null;
			else
				return new Short(s);
			}

		else if(type.equals(Float.class))
			{
			float f = rs.getFloat(index);
			if(rs.wasNull())
				return null;
			else
				return new Float(f);
			}

		else if(type.equals(Double.class))
			{
			double d = rs.getDouble(index);
			if(rs.wasNull())
				return null;
			else
				return new Double(d);
			}


		else if(type.equals(Byte.class))
			{
			byte b = rs.getByte(index);
			if(rs.wasNull())
				return null;
			else
				return new Byte(b);
			}

		else if(type.equals(Character.class)) {
			String s = rs.getString(index);
			if(rs.wasNull()) {
				return null;
			}
			else {
				if(s.length()>0) {
					return new Character(s.charAt(0));
				}
				else {
					return null;
				}
			}
		}
		else {
			return rs.getObject(index);
		}
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return where.toString();
	}

	/**
	 * exceeded ZbgB
	 * @param exceeded exceededB
	 */
	private void setExceeded(boolean exceeded) {
		this.exceeded = exceeded;
	}

	/**
	 * {@link #setMaxRows } Őݒ肵s𒴂sꂽꍇ ture ԂB
	 * @return {@link #setMaxRows } Őݒ肵s𒴂sꂽꍇ tureB
	 */
	public boolean isExceeded() {
		return exceeded;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDebugMode(boolean debug) {
		super.setDebugMode(debug);
		if(where!=null) {
			where.setDebugMode(debug);
		}
	}
	
}
