/*
 * Cache.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.util;

import java.util.*;

/**
 * ȈՃLbVB
 */
class Cache<K, V> {

	private int size;
	private Map<K,Value> values;
	private Value firstValue;
	private Value lastValue;

	private class Value {
		private K key;
		private V value;
		private Value prevValue;
		private Value nextValue;
	
		/**
		 * Value 쐬B
		 * @param value tB[h̒lB
		 */
		private Value(K k, V v) {
			key = k;
			value = v;
		}
	
		/**
		 * {@inheritDoc}
		 */
		public boolean equals(Object o) {
			if(o instanceof Cache.Value)
				return ((Value)o).key.equals(key) && 
							((Value)o).value.equals(value);
			else
				return false;
		}
	
		/**
		 * {@inheritDoc}
		 */
		public int hashCode() {
			return key.hashCode();
		}
	}
	
	/**
	 * LbV쐬B
	 * @param size LbV̍őeʁB
	 */
	public Cache(int size) {
		setMaxSize(size);
	}
	
	/**
	 * LbV쐬B<br>
	 * LbV̍őeʂ 50 ZbgB
	 */
	public Cache() {
		this(50);
	}
	
	/**
	 * LbV̍őeʂݒ肷B<br>
	 * ̃\bhĂяoƁC݊i[Ăl͑SăNAB
	 * @param size LbV̍őeʁB
	 * @exception IllegalArgumentException size  1 ꍇB
	 */
	public void setMaxSize(int size) {
		if(size < 1) {
			throw new IllegalArgumentException();
		}
		this.size = size;
		values = new HashMap<K, Value>(((int)(size/0.75f))+1,0.75f);
	}

	/**
	 * ݐݒ肳ĂLbV̍őeʂ擾B
	 * @return ݐݒ肳ĂLbV̍őeʁB
	 */
	public int getMaxSize() {
		return size;
	}

	/**
	 * LbVɒli[B
	 * @param key i[l\L[B
	 * @param value i[lB
	 */
	public V put(K key, V value) {
		if(value==null) {
			throw new NullPointerException();
		}

		Value v = values.get(key);
		V oldValue;

		if(v==null) {
			v = new Value(key, value);

			if(firstValue==null) {
				firstValue = v;
			}

			if(values.size()>=size) {
				remove(firstValue.key);
			}

			values.put(key, v);
			oldValue = null;
		}
		else {
			oldValue = v.value;
			v.value = value;

			if(v==lastValue) {
				return oldValue;
			}

			if(v.prevValue!=null) {
				v.prevValue.nextValue = v.nextValue;
			}

			if(v.nextValue!=null) {
				v.nextValue.prevValue = v.prevValue;
			}

			if(v==firstValue) {
				firstValue = v.nextValue;
			}
		}

		if(lastValue!=null) {
			lastValue.nextValue = v;
			v.prevValue = lastValue;
		}

		lastValue = v;
		v.nextValue = null;

		return oldValue;
	}


	/**
	 * w肵L[ɑΉlLbV擾B
	 * @param key 擾l̃L[B
	 * @return lB݂Ȃꍇ nullB
	 */
	public V get(K key) {
		Value v = values.get(key);
	
		if(v==null) {
			return null;
		}
	
		if(v!=lastValue) {
			if(v.prevValue!=null) {
				v.prevValue.nextValue = v.nextValue;
			}
	
			if(v.nextValue!=null) {
				v.nextValue.prevValue = v.prevValue;
			}
	
			if(v==firstValue) {
				firstValue = v.nextValue;
			}
	
			lastValue.nextValue = v;
			v.prevValue = lastValue;
	
			lastValue = v;
			v.nextValue = null;
		}
	
		return v.value;
	}

	/**
	 * w肵L[ɑΉlLbV폜B
	 * @param key 폜l̃L[B
	 * @return 폜ꂽlB
	 */
	public synchronized V remove(K key) {
		Value v = values.remove(key);

		if(v==null) {
			return null;
		}

		if(v.prevValue!=null) {
			v.prevValue.nextValue = v.nextValue;
		}

		if(v.nextValue!=null) {
			v.nextValue.prevValue = v.prevValue;
		}

		if(v==firstValue) {
			firstValue = v.nextValue;
		}

		if(v==lastValue) {
			lastValue = v.prevValue;
		}

		return v.value;
	}

	/**
	 * ݃LbVɊi[Ăl̐擾B
	 * @return ݃LbVɊi[Ăl̐B
	 */
	public int size() {
		return values.size();
	}

}

