/*
 *ConfigurationMap.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.util;

import java.util.HashMap;

/**
 * ukey=valuev`̐ݒt@C̓eۑĂ߂̃}bvB
 */
public class ConfigurationMap extends HashMap<String, String> {

	private static final long serialVersionUID = 1L;

	/**
	 * ConfigurationMap 쐬B
	 * @param initialCapacity
	 * @param loadFactor
	 */
	public ConfigurationMap(int initialCapacity, float loadFactor) {
		super(initialCapacity, loadFactor);
	}

	/**
	 * ConfigurationMap 쐬B
	 * @param initialCapacity
	 */
	public ConfigurationMap(int initialCapacity) {
		super(initialCapacity);
	}

	/**
	 * ConfigurationMap 쐬B
	 */
	public ConfigurationMap() {
		super();
	}

	/**
	 * w肵OɑΉl𕶎ƂĎ擾B
	 * @param key OB
	 * @param defaultValue OɑΉlݒ肳ĂȂꍇ̃ftHglB
	 * @return lB
	 */
	public String get(String key, String defaultValue) {
		String value = get(key);
		if(value==null) {
			return defaultValue;
		}
		return value;
	}

	/**
	 * w肵OɑΉl int lƂĎ擾B
	 * @param key OB
	 * @param defaultValue OɑΉlݒ肳ĂȂꍇ̃ftHglB
	 * @return lB
	 */
	public int get(String key, int defaultValue) {
		String value = get(key);
		if(value==null) {
			return defaultValue;
		}
		return Integer.parseInt(value);
	}

	/**
	 * w肵OɑΉl long lƂĎ擾B
	 * @param key OB
	 * @param defaultValue OɑΉlݒ肳ĂȂꍇ̃ftHglB
	 * @return lB
	 */
	public long get(String key, long defaultValue) {
		String value = get(key);
		if(value==null) {
			return defaultValue;
		}
		return Long.parseLong(value);
	}

	/**
	 * w肵OɑΉl boolean lƂĎ擾B
	 * @param key OB
	 * @param defaultValue OɑΉlݒ肳ĂȂꍇ̃ftHglB
	 * @return lB
	 */
	public boolean get(String key, boolean defaultValue) {
		String value = get(key);
		if(value==null) {
			return defaultValue;
		}
		return Boolean.parseBoolean(value);
	}


	/**
	 * w肵L[ɑΉboolean lݒ肷B
	 * @param key L[B
	 * @param value key Őݒ肷 boolean lB
	 */
	public void put(String key, boolean value) {
		put(key, String.valueOf(value));
	}

	/**
	 * w肵L[ɑΉ int lݒ肷B
	 * @param key L[B
	 * @param value key Őݒ肷 int lB
	 */
	public void put(String key, int value) {
		put(key, String.valueOf(value));
	}

	/**
	 * w肵L[ɑΉ long lݒ肷B
	 * @param key L[B
	 * @param value key Őݒ肷 long lB
	 */
	public void put(String key, long value) {
		put(key, String.valueOf(value));
	}

}
