/*
 * MethodOperator.java
 *
 * Copyright (C) 2005 ^
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.util;


import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

/**
 * \bh샆[eBeBB
 */
public class MethodOperator {

	private static final String GETTER_FLAG = "get";
	private static final String SETTER_FLAG = "set";
	
	// \bh̃LbVB
	private static Cache<Class, Map<String, Method>> rCache  = new Cache<Class, Map<String, Method>>(1000);
	private static Cache<Class, Map<String, Method>> wCache  = new Cache<Class, Map<String, Method>>(1000);


	/**
	 * setter \bhsB
	 * @param wm s郁\bhB
	 * @param object sΏۃIuWFNgB
	 * @param value ZbglB
	 */
	public static void set(Method wm, Object object, Object value) throws IllegalAccessException, InvocationTargetException {
		if(value==null)
			{
			wm.invoke
				(
				object,
				new Object[]{getNullValue(wm.getParameterTypes()[0])}
				);
			}
		else {
			wm.invoke(object,new Object[]{value});
		}
	}
	
	/**
	 * setter \bhsB
	 * @param wm s郁\bhB
	 * @param object sΏۃIuWFNgB
	 * @param value ZbglB
	 */
	public static void set(String wm, Object object, Object value) throws IllegalAccessException, InvocationTargetException {
		set(getSetterMethod(object.getClass(), wm), object, value);
	}
	
	/**
	 * setter \bh擾B
	 * @param c \bhsNXB
	 * @param methodName \bhB
	 * @return setter \bhB
	 */
	public static Method getSetterMethod(Class c, String methodName) {
		return getSetterMethods(c).get(methodName);
	}

	/**
	 * w肳ꂽNX primitive łꍇCnull ̑ɐݒ肷ׂl擾B
	 * primitive łȂꍇ́Cnull ԂB
	 * @param c `FbNNXB
	 * @return null  null l̑ɐݒ肷ׂlB
	 */
	private static Object getNullValue(Class c) {
		if(c.equals(Integer.TYPE))
			return new Integer(0);
		else if(c.equals(Boolean.TYPE))
			return new Boolean(false);
		else if(c.equals(Long.TYPE))
			return new Long(0);
		else if(c.equals(Short.TYPE))
			return new Short((short)0);
		else if(c.equals(Double.TYPE))
			return new Double(0);
		else if(c.equals(Float.TYPE))
			return new Float(0);
		else if(c.equals(Byte.TYPE))
			return new Byte((byte)0);
		else if(c.equals(Character.TYPE))
			return new Character((char)0);
		else
			return null;
	}
	
	/**
	 * getter \bhsB
	 * @param rm s郁\bhB
	 * @param object sΏۃIuWFNgB
	 * @return getter \bhɂĎ擾ꂽlB
	 */
	public static Object get(Method rm, Object object) throws IllegalAccessException, InvocationTargetException {
		return rm.invoke(object);
	}

	/**
	 * getter \bhsB
	 * @param rm s郁\bhB
	 * @param object sΏۃIuWFNgB
	 * @return getter \bhɂĎ擾ꂽlB
	 */
	public static Object get(String rm, Object object) throws IllegalAccessException, InvocationTargetException {
		return get(getGetterMethods(object.getClass()).get(rm), object);
	}

	/**
	 * getter \bh擾B
	 * @param c \bhsNXB
	 * @param methodName \bhB
	 * @return getter \bhB
	 */
	public static Method getGetterMethod(Class c, String methodName) {
		return getGetterMethods(c).get(methodName);
	}

	/**
	 * w肳ꂽNXŗp\ setter \bh[O-\bh]}bv擾B
	 * @param c \bh}bv擾NXB
	 * @return \bh}bvB
	 */
	public static Map<String, Method> getSetterMethods(Class c) {
		Map<String, Method> map = wCache.get(c);
		if(map==null) {
			map = createMethodMap(c, SETTER_FLAG);
			wCache.put(c, map);
		}
		return map;
	}

	/**
	 * w肳ꂽNXŗp\ getter \bh[O-\bh]}bv擾B
	 * @param c \bh}bv擾NXB
	 * @return \bh}bvB
	 */
	public static Map<String, Method> getGetterMethods(Class c) {
		Map<String, Method> map = rCache.get(c);
	
		if(map==null) {
			map = createMethodMap(c, GETTER_FLAG);
			rCache.put(c, map);
		}
	
		return map;
	}

	/**
	 * w肳ꂽNXŗp\ȃ\bh[O-\bh]}bv쐬B
	 * @param c \bh}bv쐬NXB
	 * @param flag getter\bh/setter\bhʂtOB
	 * @return \bh}bvB
	 */
	private static Map<String, Method> createMethodMap(Class c, String flag) {
		@SuppressWarnings("serial")
		Map<String, Method> table = new HashMap<String, Method>(){
			public Method get(Object name) {
				try {
					String s = (String)name;
					return super.get((s!=null)? s.toUpperCase() : null);
				}
				catch(ClassCastException e) {
					return super.get(name);
				}
			}
		};
	
		// SĂ Method 擾
		Method method[] = c.getMethods();
	
		for(int i=0;i<method.length;i++)
			{
			String name = method[i].getName();
			String prop = null;
	
			if(flag==GETTER_FLAG && name.startsWith("is") && name.length()>2)
				{
				// vpeBL[ɂă\bho^
				prop = name.substring(2);
				}
			else if(name.startsWith(flag) && name.length()>3 && !exMethod(name))
				{
				// vpeBL[ɂă\bho^
				prop = name.substring(3);
				}
	
			if(prop==null)
				continue;
			else if(prop.length()==1)
				table.put(prop.toUpperCase(),method[i]);
			else
				table.put(prop.substring(0,1).toUpperCase()+
							prop.substring(1).toUpperCase(),
							method[i]);
			}
	
		return table;
	}

	/**
	 * uO郁\bhvǂ𒲂ׂ
	 * @param name \bh
	 * @return uO郁\bhv̏ꍇ true
	 */
	private static boolean exMethod(String name) {
		return "getClass".equals(name);
	}
	

}
