/*
 *SelectableTable.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.model;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;

import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/**
 * I\ȃe[uB
 */
public class SelectableTable<R> extends SelectableArrayList<R> {
	
	private static final long serialVersionUID = 1L;

	/**
	 * ݑIĂ̖OB
	 */
	private String selectedColumnName;
	
	/**
	 * OɍsIi܂̓ZIjsȂꂽǂB
	 */
	private boolean rowSelection;
	
	/**
	 * OɗIi܂̓ZIjsȂꂽǂB
	 */
	private boolean columnSelection;
	
	

	/**
	 * SelectableTable 쐬B
	 */
	public SelectableTable() {
	}

	/**
	 * SelectableTable 쐬B
	 * @param rows sf[^B
	 */
	public SelectableTable(List<R> rows) {
		super(rows);
	}

	/**
	 * ݑIĂ̖OZbgB
	 * @param selectedColumn ݑIĂ̖OB
	 */
	public void setSelectedColumnName(String selectedColumn) {
		this.selectedColumnName = selectedColumn;
	}

	/**
	 * ݑIĂ̖O擾B
	 * @return ݑIĂ̖OB
	 */
	public String getSelectedColumnName() {
		return selectedColumnName;
	}

	/**
	 * O {@link #update update} \bhōsIꂽǂ𒲂ׂB<br>
	 * ̃\bh true ԂCɁC{@link #isColumnSelection() isColumnSelection()}
	 *  true Ԃꍇ́CZIĂ邱ƎB
	 * @return rowSelectionB
	 */
	public boolean isRowSelection() {
		return rowSelection;
	}

	/**
	 * O {@link #update update} \bhŗIꂽǂ𒲂ׂB
	 * ̃\bh true ԂCɁC{@link #isRowSelection() isRowSelection()}
	 *  true Ԃꍇ́CZIĂ邱ƎB
	 * @return columnSelectionB
	 */
	public boolean isColumnSelection() {
		return columnSelection;
	}
	
	/**
	 * ݑIĂZ̒l擾B
	 * @return ݑIĂZ̒lB
	 */
	public Object getSelectedCell() {
		R row = getSelected();
		if(row==null) {
			return null;
		}
		
		String columnName = getSelectedColumnName();
		if(columnName==null) {
			return null;
		}
		
		try {
			return MethodOperator.get(columnName, row);
		}
		catch (IllegalAccessException e) {
			throw new ConfigurationException(e);
		}
		catch (InvocationTargetException e) {
			throw new ConfigurationException(e);
		}
	}

	/**
	 * ^ꂽeLXgɂČ݂̃CX^XXVB
	 * @param value ݂̃CX^XXV邽߂̃eLXgB
	 */
	public void update(String value) throws ParseException {
		if(value==null || value.length()==0) {
			rowSelection = false;
			columnSelection = false;
			setSelectedIndex(-1);
			setSelectedColumnName(null);
			return;
		}

		int separator = value.indexOf(',');
		if(separator==-1) {
			rowSelection = true;
			columnSelection = false;
			setSelectedIndex(Integer.parseInt(value));
		}
		else if(separator==0) {
			rowSelection = false;
			columnSelection = true;
			setSelectedColumnName(value.substring(1));
		}
		else if(separator==value.length()-1) {
			rowSelection = true;
			columnSelection = false;
			setSelectedIndex(Integer.parseInt(value.substring(0, separator)));
		}
		else {
			rowSelection = true;
			columnSelection = true;
			setSelectedIndex(Integer.parseInt(value.substring(0, separator)));
			setSelectedColumnName(value.substring(separator+1));			
		}
	}


}
