/*
 * UpdaterImpl.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql.impl;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import nga.sql.DuplicatedException;
import nga.sql.Updater;
import nga.util.ConfigurationException;

/**
 * Updater ̎NXB
 */
public class UpdaterImpl extends SQLImplBase implements Updater {

	/**
	 * UpdaterImpl 쐬B
	 * @param con f[^x[XRlNVB
	 * @param sql SQLB
	 */
	public UpdaterImpl(Connection con, String sql) {
		super(con, sql);
	}

	/**
	 * ݂ SQL ̖ɕǉB
	 * @param s SQL ̖ɒǉ镶B
	 */
	public Updater add(String s) {
		return (Updater)super.handleAdd(s);
	}

	/**
	 * ݂ SQL ̖Ɂu"AND " + w肵vǉB<br>
	 * @param s SQL ̖ɒǉ镶B
	 */
	public Updater and(String s) {
		return (Updater)super.handleAnd(s);
	}

	/**
	 * ݂ SQL ̖Ɂu"OR " + w肵vǉB<br>
	 * @param s SQL ̖ɒǉ镶B
	 */
	public Updater or(String s) {
		return (Updater)super.handleOr(s);
	}

	/**
	 * w肵 SQL ꊇsB
	 * w肳ꂽp^IuWFNǧ PreparedStatement.executeUpdate() sB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 * @return SQLsʌB
	 */
	public int[] execute(List params) throws DuplicatedException, SQLException  {
		return execute(params, 0);
	}

	/**
	 * w肵 SQL ꊇsB<br>
	 * PreparedStatement.addBatch() sCbatchSize Ŏw肵ɒB 
	 * PreparedStatement.executeBatch() ̎ssB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 * @param batchSize ꊇsB
	 * @return SQLsʌB
	 */
	public int[] execute(List params, int batchSize) throws DuplicatedException, SQLException  {
		try {
			// ob`XV\H
			if(connection.getMetaData().supportsBatchUpdates() && batchSize > 1) {
				// addBatch() ... executeBatch() s
				return executeBatch1(params, batchSize);
			}
			else {
				// executeUpdate() [vs
				return executeBatch2(params);
			}
		}
		finally {
			close();
		}
	}

	/**
	 * addBatch() ... executeBatch() ŕSQLssB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 * @param batchSize ꊇsB
	 */
	@SuppressWarnings("unchecked")
	private int[] executeBatch1(List params, int batchSize) throws DuplicatedException, SQLException {
		long startTime = start();

		Class c = null;
		if(params.size()>0) {
			c = params.get(0).getClass();
		}
		
		int[] rc = new int[params.size()];

		String sql = getParsedSQL(c);
		try {
			PreparedStatement ps = prepareStatement(sql);

			for(int i=0; i<params.size(); i++) {
				setParameter(ps, params.get(i));

				printSQL(sql, params.get(i));
				ps.addBatch();
				
				if(i!=0 && (i % batchSize) == 0) {
					int[] r = ps.executeBatch();
					System.arraycopy(r, 0, rc, i-batchSize, batchSize);
				}
			}

			int rest = (params.size()-1) % batchSize;
			if(rest > 0) {
				int[] r = ps.executeBatch();
				System.arraycopy(r, 0, rc, rc.length - r.length, r.length);
			}
			
			return rc;
		}
		catch(InvocationTargetException e) {
			throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
		}
		catch(SQLException e) {
			if(e.getErrorCode()==1) {
				throw new DuplicatedException(e);
			}
			else {
				throw e;
			}
		}
		catch(Exception e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
		finally {
			end(startTime);
		}
	}

	/**
	 * executeUpdate() ̃[vsŕSQLssB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 */
	@SuppressWarnings("unchecked")
	private int[] executeBatch2(List params) throws DuplicatedException, SQLException {
		long startTime = start();

		Class c = null;
		if(params.size()>0) {
			c = params.get(0).getClass();
		}

		String sql = getParsedSQL(c);
		try {
			int[] rc = new int[params.size()];
			for(int i=0; i<rc.length; i++) {
				rc[i] = execute(params.get(i), sql);
			}
			return rc;
		}
		finally {
			end(startTime);
		}
	}

	/**
	 * w肵 SQL sB
	 * @return SQLsʌB
	 */
	public int execute() throws DuplicatedException, SQLException  {
		return execute((Object)null);
	}

	/**
	 * w肵 SQL sB
	 * @param params SQLɖߍރp^IuWFNgB
	 * @return SQLsʌB
	 */
	public int execute(Object params) throws DuplicatedException, SQLException  {
		long startTime = start();

		Class c = null;
		if(params!=null) {
			c = params.getClass();
		}

		String sql = getParsedSQL(c);
		try {
			return execute(params, sql);
		}
		finally {
			end(startTime);
			close();
		}
	}

	/**
	 * w肵 SQL sB
	 * @param params SQLɖߍރp^IuWFNgB
	 * @param sql s SQL B
	 * @return sʌB
	 */
	private int execute(Object params, String sql) throws DuplicatedException, SQLException {
		try {
			PreparedStatement ps = prepareStatement(sql);
			
			if(params!=null) {
				setParameter(ps, params);
			}

			printSQL(sql, params);

			return executeUpdate(ps, params);
		}
		catch(InvocationTargetException e) {
			throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
		}
		catch(SQLException e) {
			if("23000".equals(e.getSQLState())) {
				throw new DuplicatedException(e);
			}
			else {
				throw e;
			}
		}
		catch(Exception e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
	}
	
	/**
	 * SQL sB
	 * @param ps
	 * @return sʌB
	 * @throws SQLException
	 */
	@SuppressWarnings("all")
	protected int executeUpdate(PreparedStatement ps, Object params) throws SQLException, IllegalAccessException, InvocationTargetException {
		return ps.executeUpdate();
	}

}
