/*
 *Directory.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package test.nga.demo.filer;

import java.io.File;
import java.util.Date;

import nga.model.SelectableList;
import nga.model.Tree;
import nga.model.TreeNode;
import nga.servlet.ServiceInfo;

/**
 * fBNgB
 */
public class Directory {

	/**
	 * tH_c[B
	 */
	private Tree<FolderInfo> folderTree = new Tree<FolderInfo>();
	
	/**
	 * ݕ\Ăt@CXgB
	 */
	private SelectableList<FileInfo> fileList;
	
	/**
	 * ݑIĂt@C̃pXB
	 */
	private String path;

	/**
	 * Directory 쐬B
	 */
	public Directory() {
	}
	
	/**
	 * tH_c[擾B
	 * @return tH_c[B
	 */
	public Tree<FolderInfo> getFolderTree() {
		return folderTree;
	}
	
	/**
	 * ݑIĂtH_̃t@CXg擾B
	 */
	public SelectableList<FileInfo> getFileList() {
		return fileList;
	}
	
	/**
	 * ݑIĂt@C̃pX擾B
	 * @return
	 */
	public String getPath() {
		return path;
	}
	
	//// ȉCRg[\bh

	/**
	 * ʏ\ɌĂяoB
	 */
	public void init(ServiceInfo info) {
		FolderInfo folderInfo = new FolderInfo("/");
		folderInfo.setFolderPath("/");
		TreeNode<FolderInfo> rootNode = folderTree.createRootNode(folderInfo);
		
		// Ƃ肠PKw܂ł̓I[vĂB
		folderTree.setSelectedNode(rootNode);
		load(info);
	}

	/**
	 * f[^[hKvȎɌĂяoB
	 */
	public void load(ServiceInfo info) {
		TreeNode<FolderInfo> node = folderTree.getSelectedNode();

		if(node.isLoaded()) { // łɃ[hς݂̏ꍇ͉ȂB
			return;
		}
		
		FolderInfo parent = node.getNodeValue();
		String folderName = parent.getFolderPath();
		File dir = new File(info.getServlet().getServletContext().getRealPath(folderName));
		File[] files = dir.listFiles();
		if(files!=null) {
			for(File file : files) {
				if(file.isDirectory()) {
					FolderInfo folderInfo = new FolderInfo(file.getName());
					folderInfo.setFolderPath(parent.getFolderPath() + file.getName() + "/");
					node.add(folderInfo);
				}
				else {
					FileInfo fileInfo = new FileInfo(file.getName());
					fileInfo.setLastModified(new Date(file.lastModified()));
					fileInfo.setSize(file.length());
					fileInfo.setFolderPath(parent.getFolderPath());
					parent.add(fileInfo);
				}
			}
		}

		node.setLoaded(); // u[hς݁vɐݒ肷B
		
		folderSelected();
	}
	
	/**
	 * tH_̑IɌĂяoB
	 */
	public void folderSelected() {
		TreeNode<FolderInfo> node = folderTree.getSelectedNode();
		fileList = node.getNodeValue().getFileList();
	}
	
	/**
	 * t@C̑IɌĂяoB
	 */
	public void open(ServiceInfo info) {
		FileInfo file = fileList.getSelected();
		path = info.getRequest().getContextPath() + file.getPath();
	}
}
