/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2.helpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;

public final class URIHelper {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static BitSet SAFE_CHARS = new BitSet(256);
    private static final boolean WINDOWS;
    public static final URI CURRENT_URI;

    static {
        int i = 97;
        while (i <= 122) {
            SAFE_CHARS.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            SAFE_CHARS.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            SAFE_CHARS.set(i);
            ++i;
        }
        SAFE_CHARS.set(36);
        SAFE_CHARS.set(45);
        SAFE_CHARS.set(95);
        SAFE_CHARS.set(46);
        SAFE_CHARS.set(43);
        SAFE_CHARS.set(37);
        SAFE_CHARS.set(33);
        SAFE_CHARS.set(42);
        SAFE_CHARS.set(39);
        SAFE_CHARS.set(40);
        SAFE_CHARS.set(41);
        SAFE_CHARS.set(44);
        SAFE_CHARS.set(47);
        SAFE_CHARS.set(58);
        SAFE_CHARS.set(59);
        SAFE_CHARS.set(64);
        SAFE_CHARS.set(38);
        SAFE_CHARS.set(61);
        SAFE_CHARS.set(63);
        SAFE_CHARS.set(35);
        WINDOWS = System.getProperty("os.name").startsWith("Windows");
        CURRENT_URI = URI.create(".");
    }

    private URIHelper() {
    }

    private static String filter(String encoding, String uri) {
        uri = uri.trim();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);){
                int i = 0;
                while (i < uri.length()) {
                    char c = uri.charAt(i);
                    if (!Character.isISOControl(c)) {
                        ((Writer)writer).write(c);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = out.toByteArray();
        StringBuffer buff = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i] & 0xFF;
            if (SAFE_CHARS.get(b)) {
                buff.append((char)b);
            } else {
                buff.append('%');
                buff.append(HEX[b >> 4]);
                buff.append(HEX[b & 0xF]);
            }
            ++i;
        }
        uri = buff.toString();
        return uri;
    }

    /*
     * Unable to fully structure code
     */
    private static URI filter(URI uri) throws URISyntaxException {
        path = uri.getPath();
        if (path != null) ** GOTO lbl6
        return uri;
lbl-1000:
        // 1 sources

        {
            path = path.substring(3);
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
lbl6:
            // 2 sources

            ** while (path.startsWith((String)"/../"))
        }
lbl7:
        // 1 sources

        schema = uri.getScheme();
        if (schema != null && schema.equals("file") && (ssp = uri.getSchemeSpecificPart()) != null && ssp.length() >= 2 && ssp.charAt(0) == '/' && ssp.charAt(1) != '/') {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "//" + path, uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    public static URI create(String encoding, String href) throws URISyntaxException {
        href = URIHelper.filter(encoding, href);
        URI uri = new URI(href);
        return URIHelper.filter(uri);
    }

    public static URI resolve(String encoding, URI baseURI, String href) throws URISyntaxException {
        URI hrefURI;
        URI uri;
        if (URIHelper.isWindowsDrive(href = URIHelper.filter(encoding, href))) {
            href = "file:///" + href;
        }
        if ((uri = baseURI.resolve(hrefURI = new URI(href))).getScheme() == null && baseURI.getScheme() != null) {
            uri = new URI(baseURI.getScheme(), uri.getSchemeSpecificPart(), uri.getFragment());
        }
        if (URIHelper.hasWindowsDrive(baseURI) && !hrefURI.isAbsolute() || URIHelper.hasWindowsDrive(hrefURI)) {
            String path = uri.getSchemeSpecificPart();
            int start = 0;
            while (start < path.length() && path.charAt(start) == '/') {
                ++start;
            }
            if (++start <= path.length() && path.charAt(start) != ':') {
                uri = new URI(uri.getScheme(), String.valueOf(path.substring(0, start)) + ':' + path.substring(start), uri.getFragment());
            }
        }
        uri = URIHelper.filter(uri);
        return uri;
    }

    public static URI resolve(String encoding, String baseURI, String href) throws URISyntaxException {
        return URIHelper.resolve(encoding, URIHelper.create(encoding, baseURI), href);
    }

    private static boolean hasWindowsDrive(URI uri) {
        if (!WINDOWS) {
            return false;
        }
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            return false;
        }
        String path = uri.getSchemeSpecificPart();
        int start = 0;
        while (start < path.length() && path.charAt(start) == '/') {
            ++start;
        }
        return start > 0 && path.length() >= start + 2 && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    private static boolean isWindowsDrive(String href) {
        if (!WINDOWS) {
            return false;
        }
        return href.length() >= 2 && (href.charAt(0) >= 'A' && href.charAt(0) <= 'Z' || href.charAt(0) >= 'a' && href.charAt(0) <= 'z') && href.charAt(1) == ':';
    }
}

