/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2010 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.workflow;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;

/**
 * ワークフロー検索データを管理するクラスです。 <BR>
 * 
 */
public class WorkflowAllSelectData extends
    ALAbstractSelectData<EipTWorkflowRequest, EipTWorkflowRequest> implements
    ALData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WorkflowAllSelectData.class.getName());

  //
  /** サブメニュー（作成分）のタブ（未完了） */
  public static final String TAB_UNFINISHED = "unfinished";

  /** サブメニュー（作成分）のタブ（完了） */
  public static final String TAB_FINISHED = "finished";

  /** 現在選択されているタブ */
  private String currentTab;

  /** カテゴリ一覧 */
  private List<WorkflowCategoryResultData> categoryList;

  /** 申請経路一覧 */
  private List<WorkflowRouteResultData> routeList;

  /** 依頼総数 */
  private int requestSum;

  private ALEipUser login_user;

  /** ACL用の変数 */
  private String aclPortletFeature;

  /**  */
  private ALNumberField previous_id;

  // add by motegi start ③ 申請案件の検索機能追加
  /** 期間条件FROM表示用 */
  private ALDateField from_date;

  /** 期間条件TO表示用 */
  private ALDateField to_date;

  /** 『日付を指定しない』フラグ */
  private ALStringField no_date_check;

  /** カテゴリID */
  private ALStringField category_id;

  /** 検索ワード */
  private ALStringField titleWord;

  /** 検索ワード */
  private ALStringField nameWord;

  /** 閲覧ユーザー一覧 */
  private List<ALEipUser> memberList;

  /** 携帯端末からのアクセスか？ */
  private boolean isCellular = false;

  /** 全依頼を見る、か？ */
  private final boolean isAllSelect = true;

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    String sorttype = ALEipUtils.getTemp(rundata, context, LIST_SORT_TYPE_STR);
    if (sort == null || sort.equals("")) {
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, ALEipUtils
        .getPortlet(rundata, context)
        .getPortletConfig()
        .getInitParameter("p2a-sort"));
    }

    if ("create_date".equals(ALEipUtils
      .getTemp(rundata, context, LIST_SORT_STR))
      && (sorttype == null || "".equals(sorttype))) {
      ALEipUtils.setTemp(
        rundata,
        context,
        LIST_SORT_TYPE_STR,
        ALEipConstants.LIST_SORT_TYPE_DESC);
    }

    String tabParam = rundata.getParameters().getString("alltab");
    currentTab = ALEipUtils.getTemp(rundata, context, "alltab");
    if (tabParam == null && currentTab == null) {
      ALEipUtils.setTemp(rundata, context, "alltab", TAB_UNFINISHED);
      currentTab = TAB_UNFINISHED;
    } else if (tabParam != null) {
      ALEipUtils.setTemp(rundata, context, "alltab", tabParam);
      currentTab = tabParam;
    }

    login_user = ALEipUtils.getALEipUser(rundata);

    super.init(action, rundata, context);

    String entityId_Str =
      rundata.getParameters().getString(ALEipConstants.ENTITY_ID);
    if (entityId_Str == null || "".equals(entityId_Str)) {
      aclPortletFeature =
        ALAccessControlConstants.POERTLET_FEATURE_WORKFLOW_REQUEST_OTHER;
    } else {
      Integer entityId = Integer.parseInt(entityId_Str);
      int aimUserId = getUserId(rundata, context, entityId);
      int uid = ALEipUtils.getUserId(rundata);
      if (aimUserId != uid) {
        // mod by motegi AIPOカスタマイズ検証 No003 「過去の申請」を見えるようにする
        // aclPortletFeature =
        // ALAccessControlConstants.POERTLET_FEATURE_WORKFLOW_REQUEST_OTHER;
        aclPortletFeature = "";
        // mod end
      } else {
        aclPortletFeature =
          ALAccessControlConstants.POERTLET_FEATURE_WORKFLOW_REQUEST_SELF;
      }
    }

    try {
      previous_id = new ALNumberField();
      String previd = rundata.getParameters().getString("prvid");
      previous_id.setValue(previd);
    } catch (Exception e) {
      previous_id = null;
    }

    no_date_check = new ALStringField();
    no_date_check.setTrim(true);
    category_id = new ALStringField();
    category_id.setTrim(true);
    titleWord = new ALStringField();
    titleWord.setTrim(true);
    nameWord = new ALStringField();
    nameWord.setTrim(true);

    if (!isCellular
      && !rundata.getParameters().containsKey(ALEipConstants.ENTITY_ID)) {
      // PCからのアクセスの場合

      // add by motegi ③ 申請案件の検索機能追加
      // リクエストパラメータの値をセッションに設定します。
      WorkflowUtils.setCondition2Session(rundata, context);

      try {
        from_date = new ALDateField();
        Date fd =
          DateFormat.getDateInstance().parse(
            ALEipUtils.getTemp(
              rundata,
              context,
              WorkflowUtils.SESSION_KEY_START_DATE));
        from_date.setValue(fd);

        to_date = new ALDateField();
        Date ed =
          DateFormat.getDateInstance().parse(
            ALEipUtils.getTemp(
              rundata,
              context,
              WorkflowUtils.SESSION_KEY_END_DATE));
        to_date.setValue(ed);
      } catch (ParseException e) {
        e.printStackTrace();
      }

      no_date_check.setValue(ALEipUtils.getTemp(
        rundata,
        context,
        WorkflowUtils.SESSION_KEY_DATE_FLG));

      // カテゴリIDの設定
      category_id.setValue(ALEipUtils.getTemp(
        rundata,
        context,
        WorkflowUtils.SESSION_KEY_CATEGORY_ID));

      // 表題検索ワードの設定
      titleWord.setValue(ALEipUtils.getTemp(
        rundata,
        context,
        WorkflowUtils.SESSION_KEY_TITLE));

      // 申請者検索ワードの設定
      nameWord.setValue(ALEipUtils.getTemp(
        rundata,
        context,
        WorkflowUtils.SESSION_KEY_NAME));
    } else {
      // 携帯端末からのアクセスの場合
      // この場合は絞り込み検索条件の付加は行なわない。
      no_date_check.setValue(WorkflowUtils.NO_DATE_CHECK_ON);

      // 表題検索ワードの設定
      titleWord.setValue("");

      // 申請者検索ワードの設定
      nameWord.setValue("");
    }
  }

  /**
   * 
   * @param rundata
   * @param context
   */
  public void loadCategoryList(RunData rundata, Context context) {
    categoryList = WorkflowUtils.loadCategoryList(rundata, context);
  }

  /**
   * 
   * @param rundata
   * @param context
   */
  public void loadRouteList(RunData rundata, Context context) {
    routeList = WorkflowUtils.loadRouteList(rundata, context);
  }

  /**
   * 一覧データを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public ResultList<EipTWorkflowRequest> selectList(RunData rundata,
      Context context) {
    try {

      // SelectQuery<EipTWorkflowRequest> query = getSelectQuery(rundata,
      // context);
      // buildSelectQueryForListView(query);
      // buildSelectQueryForListViewSort(query, rundata, context);

      WorkflowSelectQuery query = getWorkflowSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);
      query.buildWhereCondition(rundata, context);

      ResultList<EipTWorkflowRequest> list = query.getResultList();
      // リクエストの総数をセットする．
      requestSum = list.getTotalCount();
      return list;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  // /**
  // * 検索条件を設定した SelectQuery を返します。 <BR>
  // *
  // * @param rundata
  // * @param context
  // * @return
  // */
  // private SelectQuery<EipTWorkflowRequest> getSelectQuery(RunData rundata,
  // Context context) {
  // SelectQuery<EipTWorkflowRequest> query =
  // Database.query(EipTWorkflowRequest.class);
  //
  // if (TAB_UNFINISHED.equals(currentTab)) {
  // Expression exp1 =
  // ExpressionFactory.noMatchExp(
  // EipTWorkflowRequest.PROGRESS_PROPERTY,
  // WorkflowUtils.DB_PROGRESS_ACCEPT);
  // query.setQualifier(exp1);
  // } else if (TAB_FINISHED.equals(currentTab)) {
  // Expression exp1 =
  // ExpressionFactory.matchExp(
  // EipTWorkflowRequest.PROGRESS_PROPERTY,
  // WorkflowUtils.DB_PROGRESS_ACCEPT);
  // query.setQualifier(exp1);
  // }
  //
  // return buildSelectQueryForFilter(query, rundata, context);
  // }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   * 
   * @param obj
   * @return
   */
  @Override
  protected Object getResultData(EipTWorkflowRequest record) {
    try {
      // add by motegi start Entityを差し替える getEipTWorkflowCategoryがNULLになるため
      record =
        WorkflowUtils.getEipTWorkflowRequest(record.getRequestId().intValue());
      // add by motegi end

      WorkflowResultData rd = new WorkflowResultData();
      rd.initField();
      rd.setRequestId(record.getRequestId().intValue());
      rd.setCategoryId(record
        .getEipTWorkflowCategory()
        .getCategoryId()
        .longValue());
      rd.setCategoryName(ALCommonUtils.compressString(record
        .getEipTWorkflowCategory()
        .getCategoryName(), getStrLength()));
      rd.setRequestName(ALCommonUtils.compressString(
        record.getRequestName(),
        getStrLength()));
      rd.setPriority(record.getPriority().intValue());
      rd.setPriorityImage(WorkflowUtils.getPriorityImage(record
        .getPriority()
        .intValue()));
      rd.setPriorityString(WorkflowUtils.getPriorityString(record
        .getPriority()
        .intValue()));
      rd.setProgress(record.getProgress());
      rd.setPrice(record.getPrice().longValue());

      String lastUpdateUser = null;
      EipTWorkflowRequestMap map = null;
      int order = 0;
      List<EipTWorkflowRequestMap> maps =
        WorkflowUtils.getEipTWorkflowRequestMap(record);
      int size = maps.size();

      if (WorkflowUtils.DB_PROGRESS_ACCEPT.equals(record.getProgress())) {
        // すべて承認済みの場合、最終承認者をセットする
        map = maps.get(size - 1);
        ALEipUser user = ALEipUtils.getALEipUser(map.getUserId().intValue());
        lastUpdateUser = user.getAliasName().getValue();
        order = map.getOrderIndex().intValue();
      } else {
        for (int i = 0; i < size; i++) {
          map = maps.get(i);
          if (WorkflowUtils.DB_STATUS_CONFIRM.equals(map.getStatus())) {
            // 最終閲覧者を取得する
            ALEipUser user =
              ALEipUtils.getALEipUser(map.getUserId().intValue());
            lastUpdateUser = user.getAliasName().getValue();
            order = map.getOrderIndex().intValue() - 1;
            break;
          }
        }
      }

      rd.setStateString(order + "/" + (size - 1));

      rd.setLastUpdateUser(lastUpdateUser);

      // add by motegi start ② 各一覧の表示項目に『申請者』を追加
      rd.setCreateUser(ALEipUtils.getUserFullName(record.getUserId()));
      // add by motegi end

      rd.setCreateDate(WorkflowUtils.translateDate(
        record.getCreateDate(),
        "yyyy年M月d日H時m分"));
      return rd;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  private int getUserId(RunData rundata, Context context, Integer entityId) {
    Expression exp =
      ExpressionFactory.matchDbExp(
        EipTWorkflowRequest.REQUEST_ID_PK_COLUMN,
        entityId);
    SelectQuery<EipTWorkflowRequest> query =
      Database.query(EipTWorkflowRequest.class, exp);
    List<EipTWorkflowRequest> record = query.fetchList();
    if (record.size() > 0) {
      return (record.get(0)).getUserId().intValue();
    } else {
      return -1;
    }
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public EipTWorkflowRequest selectDetail(RunData rundata, Context context) {

    EipTWorkflowRequest request =
      WorkflowUtils.getEipTWorkflowRequestAll(rundata, context);

    // add by motegi start
    try {
      memberList = new ArrayList<ALEipUser>();
      ResultList<EipTWorkflowRequestMap> maps =
        WorkflowUtils.getEipTWorkflowRequestMapForVisitor(request);
      if (maps != null) {
        int size = maps.size();
        for (int i = 0; i < size; i++) {
          EipTWorkflowRequestMap map = maps.get(i);
          int user_id = map.getUserId().intValue();
          memberList.add(ALEipUtils.getALEipUser(user_id));
        }
      }
    } catch (ALDBErrorException e) {
      logger.error("Exception", e);
      e.printStackTrace();
    }
    // add by motegi end

    return request;
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   * 
   * @param obj
   * @return
   */
  @Override
  protected Object getResultDataDetail(EipTWorkflowRequest obj) {
    return WorkflowUtils.getResultDataDetail(obj, login_user, true);
  }

  /**
   * 
   * @return
   */
  public List<WorkflowCategoryResultData> getCategoryList() {
    return categoryList;
  }

  public List<WorkflowRouteResultData> getRouteList() {
    return routeList;
  }

  /**
   * 現在選択されているタブを取得します。 <BR>
   * 
   * @return
   */
  public String getCurrentTab() {
    return currentTab;
  }

  /**
   * リクエストの総数を返す． <BR>
   * 
   * @return
   */
  public int getRequestSum() {
    return requestSum;
  }

  // /**
  // * @return
  // *
  // */
  // @Override
  // protected Attributes getColumnMap() {
  // Attributes map = new Attributes();
  // map.putValue("request_name", EipTWorkflowRequest.REQUEST_NAME_PROPERTY);
  // map.putValue("priority", EipTWorkflowRequest.PRIORITY_PROPERTY);
  // map.putValue("price", EipTWorkflowRequest.PRICE_PROPERTY);
  // map.putValue("create_date", EipTWorkflowRequest.CREATE_DATE_PROPERTY);
  // // map.putValue("category_name", EipTTodo.EIP_TTODO_CATEGORY_PROPERTY + "."
  // // + EipTTodoCategory.CATEGORY_NAME_PROPERTY);
  // map.putValue("category", EipTWorkflowCategory.CATEGORY_ID_PK_COLUMN);
  // return map;
  // }
  /**
   * @return
   * 
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    map.putValue("request_name", "request_name");
    map.putValue("priority", "priority");
    map.putValue("price", "price");
    map.putValue("create_date", "create_date");
    map.putValue("category", "category_id");
    return map;
  }

  public ALEipUser getLoginUser() {
    return login_user;
  }

  /**
   * 
   * @param id
   * @return
   */
  public boolean isMatch(int id1, long id2) {
    return id1 == (int) id2;
  }

  public ALNumberField getPreviousID() {
    return previous_id;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return aclPortletFeature;
  }

  /**
   * アクセス権限用メソッド。<br />
   * アクセス権限の有無を返します。
   * 
   * @return
   */
  public boolean hasAuthorityOther() {
    return hasAuthority;
  }

  // add by motegi start ③ 申請案件の検索機能追加
  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  private WorkflowSelectQuery getWorkflowSelectQuery(RunData rundata,
      Context context) {

    WorkflowSelectQuery query = new WorkflowSelectQuery();

    String sub_query_where = "";
    String sub_query = "";
    String search_query = "";
    String count_query = "";

    if (TAB_UNFINISHED.equals(currentTab)) {
      // 未完了
      sub_query_where =
        String.format(
          WorkflowSelectQuery.WHERE_STRING5,
          WorkflowUtils.DB_PROGRESS_ACCEPT/* "A" */);
    } else if (TAB_FINISHED.equals(currentTab)) {
      // 完了
      sub_query_where =
        String.format(
          WorkflowSelectQuery.WHERE_STRING6,
          WorkflowUtils.DB_PROGRESS_ACCEPT/* "A" */);
    }
    sub_query = String.format(WorkflowSelectQuery.SUB_QUERY2, sub_query_where);

    search_query = String.format(WorkflowSelectQuery.SEARCH_QUERY, sub_query);
    count_query = String.format(WorkflowSelectQuery.COUNT_QUERY, sub_query);
    query.setQuery(count_query, search_query);
    return query;
  }

  /**
   * ページング結果のリストを取得します。
   * 
   * @param records
   *            検索結果
   */
  protected void buildSelectQueryForListView(WorkflowSelectQuery query) {
    query.limit(getRowsNum());
    query.page(current_page);
  }

  /**
   * ソート用の <code>SelectQuery</code> を構築します。
   * 
   * @param crt
   * @return
   */
  protected void buildSelectQueryForListViewSort(WorkflowSelectQuery query,
      RunData rundata, Context context) {
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    String sort_type = ALEipUtils.getTemp(rundata, context, LIST_SORT_TYPE_STR);
    String crt_key = null;

    Attributes map = getColumnMap();
    if (sort == null) {
      return;
    }
    crt_key = map.getValue(sort);
    if (crt_key == null) {
      return;
    }
    if (sort_type != null
      && ALEipConstants.LIST_SORT_TYPE_DESC.equals(sort_type)) {
      query.orderDesending(crt_key);
    } else {
      query.orderAscending(crt_key);
      sort_type = ALEipConstants.LIST_SORT_TYPE_ASC;
    }
    current_sort = sort;
    current_sort_type = sort_type;
    return;
  }

  /**
   * 期間条件FROM取得 <BR>
   * 
   * @return
   */
  public ALDateField getToDate() {
    return to_date;
  }

  /**
   * 期間条件TO取得 <BR>
   * 
   * @return
   */
  public ALDateField getFromDate() {
    return from_date;
  }

  /**
   * 『日付を指定しない』フラグを取得します。
   * 
   * @return
   */
  public ALStringField getNoDateCheck() {
    return no_date_check;
  }

  /**
   * 検索ワードを取得します。
   * 
   * @return
   */
  public ALStringField getTitleWord() {
    return titleWord;
  }

  /**
   * 検索ワードを取得します。
   * 
   * @return
   */
  public ALStringField getNameWord() {
    return nameWord;
  }

  /**
   * カテゴリーIDを取得します。
   * 
   * @return
   */
  public ALStringField getCategoryId() {
    return category_id;
  }

  /**
   * グループメンバーを取得します。 <BR>
   * 
   * @return
   */
  public List<ALEipUser> getMemberList() {
    return memberList;
  }

  /**
   * 詳細画面に渡すフラグ 全依頼画面からか、その他の画面からか？
   * 
   * @return
   */
  public String getWorkflowMode() {
    return "all";
  }

  public void setCellular(boolean b) {
    isCellular = b;
  }

  public boolean isAllSelect() {
    return isAllSelect;
  }

  // add by motegi end ③ 申請案件の検索機能追加
}
