/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.workflow;

import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.DataRow;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.AbstractQuery;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;

/**
 * 
 */
public class WorkflowSelectQuery extends AbstractQuery<EipTWorkflowRequest> {

  protected int offset = 0;

  protected int limit = 0;

  private static final long serialVersionUID = 5404111688862773398L;

  protected String searchQuery;

  protected String countQuery;

  protected int page = 1;

  protected int totalCount = 0;

  protected String orderByKey = "";

  protected String where = "";

  // public static final String COUNT_COLUMN_STRING = " COUNT(*) AS C ";

  public static final String SEARCH_QUERY =
    "SELECT DISTINCT u0.create_date, u0.note, u0.parent_id, "
      + "u0.price, u0.priority, u0.progress, u0.request_name, "
      + "u0.update_date, u0.user_id, u0.category_id, u0.request_id, "
      + "u0.route_id, u0.applicant_full_name "
      + "FROM (%s) u0 ";

  public static final String COUNT_QUERY =
    "SELECT COUNT(DISTINCT u0.request_id) AS C FROM (%s) u0 ";

  public static final String SUB_QUERY1 =
    "SELECT t0.create_date, t0.note, t0.parent_id, t0.price, t0.priority, "
      + "t0.progress, t0.request_name, t0.update_date, t0.user_id, "
      + "t0.category_id, t0.request_id, t0.route_id, t2, "
      + "t2.last_name || t2.first_name AS applicant_full_name "
      + "FROM public.eip_t_workflow_request t0 "
      + "INNER JOIN public.eip_t_workflow_request_map t1 USING (request_id) "
      + "INNER JOIN public.turbine_user t2 on t0.user_id = t2.user_id "
      + "WHERE %s ";

  public static final String SUB_QUERY2 =
    "SELECT t0.create_date, t0.note, t0.parent_id, t0.price, t0.priority, "
      + "t0.progress, t0.request_name, t0.update_date, t0.user_id, "
      + "t0.category_id, t0.request_id, t0.route_id, t2, "
      + "t2.last_name || t2.first_name AS applicant_full_name "
      + "FROM public.eip_t_workflow_request t0 "
      + "INNER JOIN public.turbine_user t2 on t0.user_id = t2.user_id "
      + "WHERE %s ";

  // 【確認依頼を見る】の【未確認】
  public static final String WHERE_STRING1 =
    "((t1.USER_ID = %s) AND (((t0.PROGRESS = '%s') AND (t1.STATUS = '%s')) OR ((t0.PROGRESS = '%s') AND (t1.STATUS = '%s'))))";

  // 【確認依頼を見る】の【確認済】【完了】【閲覧】
  public static final String WHERE_STRING2 =
    "((t1.USER_ID = %s) AND (t0.PROGRESS = '%s') AND (t1.STATUS = '%s'))";

  // 【作成分依頼を見る】の【未完了】
  public static final String WHERE_STRING3 =
    "((t0.USER_ID = %s) AND (t0.PROGRESS IN ('%s', '%s', '%s')) AND (t1.STATUS IN ('%s', '%s', '%s')))";

  // 【作成分依頼を見る】の【完了】
  public static final String WHERE_STRING4 =
    "(t0.USER_ID = %s) AND (t0.PROGRESS = '%s')";

  // 【全依頼を見る】の【未完了】
  public static final String WHERE_STRING5 = "(t0.PROGRESS <> '%s')";

  // 【全依頼を見る】の【完了】
  public static final String WHERE_STRING6 = "(t0.PROGRESS = '%s')";

  public WorkflowSelectQuery() {
    super(EipTWorkflowRequest.class);
    dataContext = DatabaseOrmService.getInstance().getDataContext();
  }

  public void setQuery(String countQueryString, String searchQueryString) {
    countQuery = countQueryString;
    searchQuery = searchQueryString;
  }

  @SuppressWarnings("unchecked")
  public List<EipTWorkflowRequest> fetchList() {

    searchQuery = searchQuery + where;
    if (!"".equals(orderByKey)) {
      searchQuery = searchQuery + orderByKey;
    }
    searchQuery = searchQuery + "LIMIT " + limit + " OFFSET " + offset;

    SQLTemplate<EipTWorkflowRequest> query =
      new SQLTemplate<EipTWorkflowRequest>(
        EipTWorkflowRequest.class,
        searchQuery);

    List<DataRow> dataRows = query.fetchListAsDataRow();
    List<EipTWorkflowRequest> results = new ArrayList<EipTWorkflowRequest>();

    for (DataRow dataRow : dataRows) {
      EipTWorkflowRequest model =
        newInstanceFromRowData(dataRow, EipTWorkflowRequest.class);
      if (model != null) {
        results.add(model);
      }
    }
    return results;
  }

  public ResultList<EipTWorkflowRequest> getResultList() {
    int totalCount = getCount();
    int pageSize = limit;
    if (pageSize > 0) {
      int num = ((int) (Math.ceil(totalCount / (double) pageSize)));
      if ((num > 0) && (num < page)) {
        page = num;
      }
      offset = pageSize * (page - 1);
    } else {
      page = 1;
    }
    List<EipTWorkflowRequest> fetchList = fetchList();
    return new ResultList<EipTWorkflowRequest>(
      fetchList,
      page,
      pageSize,
      totalCount);
  }

  public int getCount() {
    SQLTemplate<EipTWorkflowRequest> query =
      new SQLTemplate<EipTWorkflowRequest>(
        EipTWorkflowRequest.class,
        countQuery + where);
    List<DataRow> rows = query.fetchListAsDataRow();
    DataRow dataRow = rows.get(0);
    return ((Long) ALEipUtils.getObjFromDataRow(dataRow, "C")).intValue();
  }

  public void page(int page) {
    this.page = page;
  }

  public void limit(int limit) {
    this.limit = limit;
  }

  public void offset(int offset) {
    this.offset = offset;
  }

  public void orderDesending(String key) {
    orderByKey = " ORDER BY " + key + " DESC ";
  }

  public void orderAscending(String key) {
    orderByKey = " ORDER BY " + key + " ASC ";
  }

  public void buildWhereCondition(RunData rundata, Context context) {

    List<String> conditionList = new ArrayList<String>();

    String no_date_check =
      ALEipUtils.getTemp(rundata, context, WorkflowUtils.SESSION_KEY_DATE_FLG);

    if (WorkflowUtils.NO_DATE_CHECK_OFF.equals(no_date_check)) {
      String from_date =
        ALEipUtils.getTemp(
          rundata,
          context,
          WorkflowUtils.SESSION_KEY_START_DATE);

      String to_date =
        ALEipUtils
          .getTemp(rundata, context, WorkflowUtils.SESSION_KEY_END_DATE);

      conditionList.add("create_date BETWEEN '"
        + from_date
        + " 00:00:00' AND '"
        + to_date
        + " 23:59:59'");

    }

    String category_id =
      ALEipUtils.getTemp(
        rundata,
        context,
        WorkflowUtils.SESSION_KEY_CATEGORY_ID);

    if (category_id != null && !"".equals(category_id)) {
      conditionList.add("category_id=" + category_id);
    }

    String titleWord =
      ALEipUtils.getTemp(rundata, context, WorkflowUtils.SESSION_KEY_TITLE);

    if (titleWord != null && !"".equals(titleWord)) {
      conditionList.add("request_name like '%" + titleWord + "%'");
    }

    String nameWord =
      ALEipUtils.getTemp(rundata, context, WorkflowUtils.SESSION_KEY_NAME);

    if (nameWord != null && !"".equals(nameWord)) {
      conditionList.add("applicant_full_name like '%" + nameWord + "%'");
    }

    if (conditionList.size() > 0) {
      where = " WHERE " + implode(" AND ", conditionList);
    }
    // System.out.println("検索条件：" + where);

    /*
     * try { // カテゴリIDの設定 category_id = new ALStringField();
     * category_id.setTrim(true); category_id.setValue(ALEipUtils.getTemp(
     * rundata, context, WorkflowUtils.SESSION_KEY_CATEGORY_ID)); // 表題検索ワードの設定
     * titleWord = new ALStringField(); titleWord.setTrim(true);
     * titleWord.setValue(ALEipUtils.getTemp( rundata, context,
     * WorkflowUtils.SESSION_KEY_TITLE)); // 申請者検索ワードの設定 nameWord = new
     * ALStringField(); nameWord.setTrim(true);
     * nameWord.setValue(ALEipUtils.getTemp( rundata, context,
     * WorkflowUtils.SESSION_KEY_NAME));
     * 
     * from_date = new ALDateField(); Date fd =
     * DateFormat.getDateInstance().parse( ALEipUtils.getTemp( rundata, context,
     * WorkflowUtils.SESSION_KEY_START_DATE)); from_date.setValue(fd);
     * 
     * to_date = new ALDateField(); Date ed =
     * DateFormat.getDateInstance().parse( ALEipUtils.getTemp( rundata, context,
     * WorkflowUtils.SESSION_KEY_END_DATE)); to_date.setValue(ed);
     * 
     * no_date_check = new ALStringField(); no_date_check.setTrim(true);
     * no_date_check.setValue(ALEipUtils.getTemp( rundata, context,
     * WorkflowUtils.SESSION_KEY_DATE_FLG)); } } catch (ParseException e) {
     * e.printStackTrace(); }
     * 
     */
  }

  public static String implode(String glue, List<String> pieces) {
    StringBuffer buf = new StringBuffer();
    for (int i = 0;; i++) {
      buf.append(pieces.get(i));
      if (i == pieces.size() - 1) {
        break;
      }
      buf.append(glue);
    }
    return buf.toString();
  }
}
