/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2010 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.workflow");

dojo.require("aipo.widget.DropdownDatepicker");
dojo.require("aipo.widget.MemberNormalSelectList");
dojo.require("dijit.form.ComboBox");

var before = 0;

aipo.workflow.onLoadWorkflowDetail = function(portlet_id){
    aipo.portletReload('whatsnew');
}

aipo.workflow.onLoadWorkflowDialog = function(portlet_id){
    var picker = dijit.byId("membernormalselect");
    if(picker){
        var memberlist = picker;
        var select = dojo.byId('init_memberlist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            memberlist.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }

    var obj = dojo.byId("route_name");
    if(obj){
       obj.focus();
    }
}

aipo.workflow.onChangeSelecter = function(portletId , url , values, named , flgName){

    dojo.byId(flgName).checked = false;
    var callbackArgs = new Array();
    callbackArgs["named"] = "workflow_" + named;

    aimluck.io.sendRawData(url + "&value=" + values,values,aipo.workflow.setTemplate,callbackArgs);

    return false;

}

aipo.workflow.setTemplate = function(array,rtnData){

        var jsonData = eval( '('+rtnData["type"].toString().slice(4,-4)+')' );
        var routeH = jsonData.route_h;
        var route = jsonData.route;

        var routeArray = route.split(",");
        var routeLength = (routeArray.length-1)/2;

        if ( route == null || route == "" ) {
            dojo.byId(array["named"]).style.display = "none";
        } else {
            dojo.byId(array["named"]).style.display = "";
        }

        if ( route == null || route == "") {
            dojo.byId(array["named"]).innerHTML = "";
        } else {
            dojo.byId(array["named"]).innerHTML = routeH;
        }

        memberFrom = dojo.byId('tmp_member_from');
        memberFromOpts = memberFrom.options;
        for ( i = 0; i < memberFromOpts.length ; i++ ){
            memberFromOpts[i].selected = false;
        }
        memberTo = dojo.byId('positions');
        while(memberTo.lastChild) {
             memberTo.removeChild(memberTo.lastChild);
       }
        var opt;
        for ( i = 0; i < routeLength ; i++ ){
            memberTo.options[i] = new Option(routeArray[2*i+1], routeArray[2*i]);
        }
}



aipo.workflow.categoryOnChangeSelecter = function(portletId , url , values, named , flgName, namedRoute, selectRoute){
    if(aipo.workflow.NoteChangeConfirm(flgName)){

    	before = dojo.byId('category_id').selectedIndex;

        dojo.byId(flgName).checked = false;
        var callbackArgs = new Array();
        callbackArgs["named"] = "workflow_" + named;
        callbackArgs["namedRoute"] = "workflow_" + namedRoute;
        callbackArgs["selectRoute"] = selectRoute;

        aimluck.io.sendRawData(url + "&value=" + values,values,aipo.workflow.categorySetTemplate,callbackArgs);
    }else{
    	dojo.byId('category_id').selectedIndex = before;
    }
    return false;

}

aipo.workflow.categorySetTemplate = function(array,rtnData){

        var jsonData = eval( '('+rtnData["type"].toString().slice(4,-4)+')' );
        var template = jsonData.template;
        var routeId = jsonData.route_id.toString();
        var routeH = jsonData.route_h;
        var route = jsonData.route;

        var routeArray = route.split(",");
        var routeLength = (routeArray.length-1)/2;

        if ( routeH == null || routeH == "" ) {
            dojo.byId(array["namedRoute"]).style.display = "none";
        } else {
            dojo.byId(array["namedRoute"]).style.display = "";
        }

        if (null != template) {
          dojo.byId(array["named"]).value = template;
        } else {
          dojo.byId(array["named"]).value = "";
        }
        dojo.byId(array["namedRoute"]).value = "";
        var selectRoute = dojo.byId(array["selectRoute"]);
        var selectRouteOpts = selectRoute.options;
        selectRouteOpts[0].selected = true;

        if(!(routeId.match(/[^0-9]/g) || parseInt(routeId, 10) + "" != routeId)){
            for ( i = 0; i < selectRoute.length; i++ ) {
                if ( selectRouteOpts[i].value == routeId ) {
                    selectRouteOpts[i].selected = true;
                }
            }
            dojo.byId(array["namedRoute"]).value = routeH;

            dojo.byId('is_saved_route_button').value = 'ユーザー一覧から選択する';
            dojo.byId('workflowRouteSelectField').style.display = "";
            dojo.byId('workflowRouteInputField').style.display = "none";
            dojo.byId('is_saved_route').value = 'TRUE';

            memberTo = dojo.byId('positions');
            while(memberTo.lastChild) {
                memberTo.removeChild(memberTo.lastChild);
            }
            memberFrom = dojo.byId('tmp_member_from');
            memberFromOpts = memberFrom.options;
            for ( i = 0; i < memberFromOpts.length ; i++ ){
                memberFromOpts[i].selected = false;
            }
            memberTo = dojo.byId('positions');
            var opt;
            for ( i = 0; i < routeLength ; i++ ){
                memberTo.options[i] = new Option(routeArray[2*i+1], routeArray[2*i]);
            }
        }
}

aipo.workflow.onFocusComment = function(portlet_id){
    // add by motegi start
    var picker = dijit.byId("membernormalselect");
    if(picker){
        var memberlist = picker;
        var select = dojo.byId('init_memberlist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            memberlist.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }
    // add by motegi end
}

aipo.workflow.onChangeNote = function(){
	dojo.byId("isChangedNote").checked = true;
}

aipo.workflow.NoteChangeConfirm = function(flgName){

    if(dojo.byId(flgName).checked){
      if(!confirm( '申請内容は変更されています\n分類を変更すると内容が消えてしまいますがよろしいですか？')){
        return false;
      }
    }
    return true;
}

aipo.workflow.onReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }

        aipo.portletReload('workflow');
        aipo.portletReload('whatsnew');
  
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}


aipo.workflow.onAccept = function(portletId){
    var form = dojo.byId("workflowForm"+portletId);
    aipo.workflow._portletId = portletId;
    form.mode.value = "accept";
}

aipo.workflow.onDenial = function(portletId){
    var form = dojo.byId("workflowForm"+portletId);
    aipo.workflow._portletId = portletId;
    form.mode.value = "denial";
}

aipo.workflow.onDelete = function(portletId){
    var form = dojo.byId("workflowForm"+portletId);
    aipo.workflow._portletId = portletId;
    form.mode.value = "delete";
}

aipo.workflow.submit_list = function(form) {
  var s_o = form.member_to.options;
  var tmp = '';

  for(i = 0 ; i < s_o.length; i++ ) {
    s_o[i].selected = false;
  }

  if(s_o.length > 0) {
    for(i = 0 ; i < s_o.length-1; i++ ) {
      tmp = tmp + s_o[i].value + ',';
    }
    tmp = tmp + s_o[s_o.length-1].value;
  }
  form.positions.value = tmp;
}

aipo.workflow.formSwitchRouteSelect = function(button) {
    if(button.form.is_saved_route.value == 'TRUE' || button.form.is_saved_route.value == 'true') {
        button.value = '申請経路一覧から選択する';
        aipo.workflow.formRouteSelectOff(button.form);
    } else {
        button.value = 'ユーザー一覧から選択する';
        aipo.workflow.formRouteSelectOn(button.form);
    }
}

aipo.workflow.formRouteSelectOn = function(form) {
    dojo.byId('workflowRouteSelectField').style.display = "";
    dojo.byId('workflowRouteInputField').style.display = "none";

    form.is_saved_route.value = 'TRUE';
}

aipo.workflow.formRouteSelectOff = function(form) {
    dojo.byId('workflowRouteSelectField').style.display = "none";
    dojo.byId('workflowRouteInputField').style.display = "";

    form.is_saved_route.value = 'FALSE';
}

//add by motegi　③申請案件の検索機能追加
//aipo.workflow.initSearch = function() {
//  aipo.workflow.createCalendar();
//  var portlet_id = dojo.byId('portlet_id').value;
//  var url_userlist = dojo.byId('urlUserlist'+portlet_id).value;
//  var dst_user_id = dojo.byId('urlDstUser'+portlet_id).value;
//  if(url_userlist){
//    aipo.workflow.changeGroup(url_userlist, 'LoginUser', dst_user_id);   
//  } 
//}

aipo.workflow.changeGroup = function(link, group, sel) {
    aimluck.utils.form.createSelect("dest_user_id", "destuserDiv", link + "?mode=group&groupname=" + group + "&inc_luser=false", "userId", "aliasName", sel, '<option value="0">（未選択）<\/option>');
}

aipo.workflow.createCalendar = function() {

  var default_from_date = dojo.byId('default_from_date').value;
  var default_to_date = dojo.byId('default_to_date').value;
  
  //alert("default_from_date:" + default_from_date)

  dojo.require("aipo.widget.DropdownDatepicker");
  var from = new aipo.widget.DropdownDatepicker({ 
    name: "fromday",
    iconURL: "images/icon/icon_date.gif",
    widgetId: "acceptdatepicker",
    dateId: "from_date",
    displayCheck: "none",
    iconAlt: "FROM",
    hiddenId: "from_date",
    initValue: default_from_date,
    inputId: "input_from_date"
    }, 
    dojo.byId("from"));
  

  var to = new aipo.widget.DropdownDatepicker({ 
    name: "fromday",
    iconURL: "images/icon/icon_date.gif",
    widgetId: "acceptdatepicker",
    dateId: "to_date",
    displayCheck: "none",
    iconAlt: "TO",
    hiddenId: "to_date",
    initValue: default_to_date,
    inputId: "input_to_date"
    }, 
    dojo.byId("to"));
}

aipo.workflow.onSearchSubmit = function(form,exec_url,p_id){

  var search_params ="";
  var title_word =dojo.byId('title_word').value;
  var name_word =dojo.byId('name_word').value;
  var no_date_check = "0";
  if( form.no_date_check.checked ) {
    no_date_check = "1";
  }

  search_params = [
                   ["name_word",name_word],
                   ["title_word",title_word],
                   ["no_date_check",no_date_check],
                   ["category_id",form.category_id.value],
                   ["from_date",form.from_date.value],
                   ["to_date",form.to_date.value]
                  ];

  //var param_str = "";
  //for(i = 0 ; i < search_params.length; i++ ) {
  //  param_str = param_str + "&" + search_params[i][0] + "=" + search_params[i][1];
  //}
  //exec_url = exec_url + param_str;
  //alert(exec_url + param_str)
  //document.location = exec_url + param_str;
  
  aipo.workflow.viewPage(exec_url, p_id, search_params);
}

aipo.workflow.reloadPage = function(portletId) {
     aipo.workflow.viewPage(ptConfig[portletId].initUrl, portletId);
};

aipo.workflow.viewPage = function(url, portletId, params) {
     var portlet = dijit.byId('portlet_' + portletId);
     if(! portlet){
       portlet = new aimluck.widget.Contentpane({},'portlet_' + portletId);
     }
     
     if(portlet){
       ptConfig[portletId].reloadUrl= url;
       
       //カレンダーコントロール、ユーザープルダウン初期処理を呼び出す
       portlet.onLoad = aipo.workflow.createCalendar;
       
       if(params){
         for(i = 0 ; i < params.length; i++ ) {
          portlet.setParam(params[i][0], params[i][1]);
         }
       }
       
       portlet.viewPage(url);
     }
};

// add by motegi start ①閲覧ユーザー追加機能対応
aipo.workflow.onAddVisitor = function(portletId){
    var form = dojo.byId("workflowForm"+portletId);
    aipo.workflow._portletId = portletId;
    form.mode.value = "add_visitor";
}

// add by motegi start ④申請案件の取り戻し機能追加
aipo.workflow.onLoadWorkflowDetailForTakeBack = function(portlet_id){
    aipo.portletReload('workflow');
}

var takeback_entity_id = 0;

aipo.workflow.onReceiveMessageForTakeBack = function(msg){

    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        for(var index in ptConfigForTakeBack) {//
          if(ptConfigForTakeBack[index].group == 'workflow') {
          
            //aipo.portletReload('workflow');
           
            var url = ptConfigForTakeBack[index].initUrl + 
                            '&mode=detail' + 
                            '&entityid=' + takeback_entity_id;
            //var url = ptConfigForTakeBack[index].initUrl + 
            //                '&mode=detail';
            aipo.common.showDialog(url, index, aipo.workflow.onLoadWorkflowDetailForTakeBack);
            break;
          }
        }
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.workflow.onTakeBack = function(button, entity_id, indicator_id, portletId){
    
    //aipo.workflow.onReceiveMessageForTakeBack用にグローバル変数に退避
    takeback_entity_id = entity_id;
    
    var form = dojo.byId("workflowForm"+portletId);
    //var url = form.action + '&mode=takeback';
    aimluck.io.disableForm(form, true);
    //aimluck.io.setHiddenValue(button);
    //button.form.action = url;
    form.mode.value = "takeback"
    aimluck.io.submit(form, indicator_id, portletId, aipo.workflow.onReceiveMessageForTakeBack);
}
// add by motegi end

