unit ecma_activex;

//ActiveX Object
//2001/05/03
//by Wolfy

{$IFDEF VER130}
{$ELSE}
  {$WARN SYMBOL_PLATFORM OFF}
  {$WARN UNIT_PLATFORM OFF}
{$ENDIF}


interface

uses
  windows,classes,sysutils,dialogs,syncobjs,gsocketmisc,
  ecma_type,ecma_expr,hashtable,ecma_misc,ecma_object,myclasses,
  activex,comobj,AxCtrls;

type
  TJActiveXObject = class(TJObject)
  private
    FHash: TIntegerHashTable;
    FDispatch: IDispatch;
    FOwner: IDispatch;
    FSelfDispId: TDispId;
  protected
    function GetPropertyList: String; override;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
    function GetValue(S: String; ArrayStyle: Boolean): TJValue; override;
    procedure SetValue(S: String; Value: TJValue; ArrayStyle: Boolean); override;
    function DispIdToString(Id: TDispId): String;
    procedure Clear;
  published
    property disp: IDispatch read FDispatch write FDispatch;
  end;

  TJEnumeratorObject = class(TJObject)
  private
    FEnum: IEnumVariant;
    FItem: OleVariant;
    FAtEnd: Boolean;

    function DoAtEnd(Param: TJValueList): TJValue;
    function DoItem(Param: TJValueList): TJValue;
    function DoMoveFirst(Param: TJValueList): TJValue;
    function DoMoveNext(Param: TJValueList): TJValue;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    function GetValue(S: String; ArrayStyle: Boolean): TJValue; override;

    function Item: TJValue;
    procedure MoveNext;
    property AtEnd: Boolean read FAtEnd;
  end;

//RNVǂ
function IsCollection(P: PJValue): Boolean;


implementation   

function IsCollection(P: PJValue): Boolean;
//RNVǂ
var
  para: TDispParams;
  ret: OleVariant;
  collection: IDispatch;
begin
  Result := False;
  if IsDispatch(P) then
    collection := AsDispatch(P)
  else if IsObject(P) and (P^.vObject is TJActiveXObject) then
    collection := (P^.vObject as TJActiveXObject).disp
  else
    Exit;

  try
    para.rgvarg := nil;
    para.rgdispidNamedArgs := nil;
    para.cArgs := 0;
    para.cNamedArgs := 0;
    VariantInit(ret);

    OLECheck(
      collection.Invoke(
        DISPID_NEWENUM,
        GUID_NULL,
        GetUserDefaultLCID,
        DISPATCH_PROPERTYGET,
        para,@ret,nil,nil));

    Result := True;
  except
  end;
end;


{ TJActiveXObject }

procedure TJActiveXObject.Clear;
begin
  FHash.Clear;
  FDispatch := nil;
  FOwner := nil;
  FSelfDispId := DISPID_UNKNOWN;
  ClearMembers;
end;

constructor TJActiveXObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
var
  v: TJValue;
  s: String;
begin
  inherited;
  RegistName('ActiveXObject');

  FHash := TIntegerHashTable.Create(10);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsDispatch(@v) then
      FDispatch := AsDispatch(@v)
    else begin
      s := AsString(@v);
      try
        FDispatch := CreateOleObject(s);
      except
        raise EJThrow.Create(E_ACTIVEX,'create error ' + s);
      end;
    end;
  end;
end;

destructor TJActiveXObject.Destroy;
begin
  Clear;
  FreeAndNil(FHash);
  inherited;
end;

function TJActiveXObject.DispIdToString(Id: TDispId): String;
var
  sl: TStringList;
  i: Integer;
begin
  Result := '';
  sl := FHash.KeyList;
  for i := 0 to sl.Count - 1 do
  begin
    if FHash[sl[i]] = Id then
    begin
      Result := sl[i];
      Break;
    end;
  end;
end;

function TJActiveXObject.GetPropertyList: String;
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  try
    EnumDispatchProperties(FDispatch,GUID_NULL,VT_EMPTY,sl);
    Result := sl.Text;
  finally
    sl.Free;
  end;
end;

function TJActiveXObject.GetValue(S: String; ArrayStyle: Boolean): TJValue;

  function GetDispId(Name: WideString): TDispId;
  begin
    if FHash.HasKey(Name) then
      Result := FHash[Name]
    else begin
      if not Assigned(FDispatch) then
        raise EJThrow.Create(E_ACTIVEX,Name);

      try
        OLECheck(
          FDispatch.GetIDsOfNames(
            GUID_NULL,
            @Name,
            1,
            GetUserDefaultLCID,
            @Result));
      except
        raise EJThrow.Create(E_ACTIVEX,Name);
      end;
      //LbV
      FHash[Name] := Result;
    end;     
  end;

var
  di: TDispID;
  param: TDispParams;
  ret,v: OleVariant;
  func: TJFunction;
  arglist: PVariantArgList;
begin
  EmptyValue(Result);
  //membersɂȂΏI
  if HasKey(S) or HasDefaultProperty(S)  then
  begin
    Result := inherited GetValue(S,ArrayStyle);
    Exit;
  end;
  //zANZXł͂Ȃꍇ
  if not ArrayStyle then
  begin
    di := GetDispId(S);
    param.rgvarg := nil;
    param.rgdispidNamedArgs := nil;
    param.cArgs := 0;
    param.cNamedArgs := 0;
    VariantInit(ret);
    //propertyĂяoȂ
    try
      OLECheck(FDispatch.Invoke(
        di,
        GUID_NULL,
        GetUserDefaultLCID,
        DISPATCH_PROPERTYGET,
        param,@ret,nil,nil));
      
      Result := VariantToValue(ret,FFactory);
      //vpeB̏ꍇ̂FDispatchn
      if IsObject(@Result) and (Result.vObject is TJActiveXObject) then
      begin
        (Result.vObject as TJActiveXObject).FOwner := FDispatch;
        (Result.vObject as TJActiveXObject).FSelfDispId := di;
      end;
    except
      func.FuncType := ftActiveX;
      func.This := Self;
      func.AXMethod.Dispid := di;
      func.AXMethod.Parent := FDispatch;
      //o^
      Result := FFuncFactory.BuildFunction(func);
      Members[S] := Result;
    end;
  end
  else begin  //zANZX̏ꍇ̓\bhĂяo
    //ftHg炵H
    //di := GetDispId('');//Item');
    //di := DISPID_VALUE;

    VariantInit(ret);
    GetMem(arglist,SizeOf(TVariantArg));
    try
      v := S;
      arglist^[0] := TVariantArg(v);
      param.rgvarg := arglist;
      param.cArgs := 1;
      param.rgdispidNamedArgs := nil;
      param.cNamedArgs := 0;
      try
       if Assigned(FOwner) then
       begin
         OLECheck(
            FOwner.Invoke(
              FSelfDispId,
              GUID_NULL,
              GetUserDefaultLCID,
              DISPATCH_PROPERTYGET or DISPATCH_METHOD,
              param,@ret,nil,nil));

         Result := VariantToValue(ret,FFactory);
       end
       else begin
         OLECheck(
            FDispatch.Invoke(
              DISPID_VALUE,
              GUID_NULL,
              GetUserDefaultLCID,
              DISPATCH_PROPERTYGET or DISPATCH_METHOD,
              param,@ret,nil,nil));

         Result := VariantToValue(ret,FFactory);
       end;

      except
        raise EJThrow.Create(E_ACTIVEX,S);
      end;
    finally
      FreeMem(arglist);
    end;
  end;
end;

procedure TJActiveXObject.SetValue(S: String; Value: TJValue;
  ArrayStyle: Boolean);
var
  ws: WideString;
  di,diput: TDispID;
  param: TDispParams;
  v: OleVariant;
  //func: TJFunction;
  arglist: PVariantArgList;
  ary: TJBaseArrayObject;
  i,index: Integer;
begin
  if HasDefaultProperty(S) then
  begin
    inherited ;
    Exit;
  end;

  if FHash.HasKey(S) then
    di := FHash[S]
  else begin
    ws := S;
    try
      OLECheck(FDispatch.GetIDsOfNames(
        GUID_NULL,@ws,1,GetUserDefaultLCID,@di));
    except
      raise EJThrow.Create(E_ACTIVEX,S);
    end;
    //LbV
    FHash[S] := di;
  end;

  //
  arglist := nil;
  diput := DISPID_PROPERTYPUT;    
  param.rgvarg := nil;
  param.cArgs := 0;
  param.rgdispidNamedArgs := @diput;
  param.cNamedArgs := 1;

  if IsArrayObject(@Value) then
  begin
    //z^̏ꍇ
    ary := Value.vObject as TJBaseArrayObject;
    if ary.Count > 0 then
    begin
      GetMem(arglist,SizeOf(TVariantArg) * ary.Count);
      //tɕϊ
      index := 0;
      for i := ary.Count - 1 downto 0 do
      begin
        //tagVariantOleVariant͓
        arglist^[index] := TVariantArg(ValueToVariant(ary.GetItem(i)));
        Inc(Index);
      end;

      param.rgvarg := arglist;
      param.cArgs := ary.Count;
    end;
  end
  else begin
    v := ValueToVariant(Value);
    param.rgvarg := @v;
    param.cArgs := 1;
  end;

  //propertyĂяo
  try try
    OLECheck(FDispatch.Invoke(
      di,GUID_NULL,GetUserDefaultLCID,
      DISPATCH_PROPERTYPUT,param,nil,nil,nil));
  except
    raise EJThrow.Create(E_ACTIVEX,S);
  end;

  finally
    if Assigned(arglist) then
      FreeMem(arglist);
  end;
end;


{ TJEnumeratorObject }

constructor TJEnumeratorObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
var
  v: TJValue;
  para: TDispParams;
  ret: OleVariant;
  collection: IDispatch;
begin
  inherited;
  RegistName('Enumerator');
  RegistMethod('atEnd',DoAtEnd);
  RegistMethod('item',DoItem);
  RegistMethod('moveFirst',DoMoveFirst);
  RegistMethod('moveNext',DoMoveNext);

  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsDispatch(@v) then
      collection := AsDispatch(@v)
    else if IsObject(@v) and (v.vObject is TJActiveXObject) then
      collection := (v.vObject as TJActiveXObject).disp
    else
      raise EJThrow.Create(E_ENUMERATOR,'Enumerator.Create Error');

    try
      para.rgvarg := nil;
      para.rgdispidNamedArgs := nil;
      para.cArgs := 0;
      para.cNamedArgs := 0;
      VariantInit(ret);

      OLECheck(
        collection.Invoke(
          DISPID_NEWENUM,
          GUID_NULL,
          GetUserDefaultLCID,
          DISPATCH_PROPERTYGET,
          para,@ret,nil,nil));

      FEnum := IUnknown(ret) as IEnumVariant;
      DoMoveNext(nil);
    except
      raise EJThrow.Create(E_ENUMERATOR,'Enumerator.Create Error');
    end;
  end
  else
    raise EJThrow.Create(E_ENUMERATOR,'Enumerator.Create Error');
end;

function TJEnumeratorObject.DoAtEnd(Param: TJValueList): TJValue;
begin
  Result := BuildBool(FAtEnd);
end;

function TJEnumeratorObject.DoItem(Param: TJValueList): TJValue;
begin
  Result := VariantToValue(FItem,FFactory);
end;

function TJEnumeratorObject.DoMoveFirst(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
  FEnum.Reset;
  DoMoveNext(nil);
end;

function TJEnumeratorObject.DoMoveNext(Param: TJValueList): TJValue;
var
  i: Cardinal;
begin
  EmptyValue(Result);
  FAtEnd := FEnum.Next(1,FItem,i) <> S_OK;
end;

function TJEnumeratorObject.GetValue(S: String;
  ArrayStyle: Boolean): TJValue;
begin
  if S <> '' then
    Result := inherited GetValue(S,ArrayStyle)
  else
    Result := DoItem(nil);
end;

function TJEnumeratorObject.Item: TJValue;
begin
  Result := DoItem(nil);
end;

procedure TJEnumeratorObject.MoveNext;
begin
  DoMoveNext(nil);
end;

end.
