unit ecma_stmt;

//`
//2001/04/13 ~
//by Wolfy

interface

uses
  windows,sysutils,classes,ecma_type,ecma_expr;

//procedure InitProgram(var P: PJStatement);
//procedure FreeStatement(P: PJStatement);

type
  TJStatementFactory = class(TObject)
  private
    FList: TList;
    FExprFactory: TJExprFactory;
    procedure FreeStatement(P: PJStatement);
  public
    constructor Create(AExprFactory: TJExprFactory);
    destructor Destroy; override;
    procedure Clear;

    function NewStatement: PJStatement;
    function MakeExprStatement(LineNo: Integer; Expr: PJExpr): PJStatement;
    function MakeBlockStatement(LineNo: Integer; Statements: PJStatement): PJStatement;
    function MakeReturnStatement(LineNo: Integer; Expr: PJExpr): PJStatement;
    function MoveStart(P: PJStatement): PJStatement;
    function MoveLast(P: PJStatement): PJStatement;
    procedure MergeStatement(Prev,Next: PJStatement);
    function MakeIfStatement(LineNo: Integer; Expr: PJExpr; TrueBlock: PJStatement; FalseBlock: PJStatement = nil): PJStatement;
    function MakeWhileStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
    function MakeDoStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
    function MakeForStatement(LineNo: Integer; Expr1,Expr2,Expr3: PJExpr; Block: PJStatement): PJStatement;
    function MakeForInStatement(LineNo: Integer; Expr1,Expr2: PJExpr; Block: PJStatement; ArrayElement: Boolean = False): PJStatement;
    function MakeContinueStatement(LineNo: Integer): PJStatement;
    function MakeBreakStatement(LineNo: Integer): PJStatement;
    function MakeWithStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
    function MakeTryStatement(LineNo: Integer; Block: PJStatement): PJStatement;
    function MakeCatchStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
    function MakeFinallyStatement(LineNo: Integer; Block: PJStatement): PJStatement;
    function MakeThrowStatement(LineNo: Integer; Expr: PJExpr): PJStatement;
    function MakeEmptyStatement(LineNo: Integer): PJStatement;
    function MakeVarDecl(LineNo: Integer; Stmt: PJStatement): PJStatement;
    function MakeFunctionDecl(LineNo: Integer; ID: PJExpr; ParamDecl,Block: PJStatement): PJStatement;
    function MakeParamDecl(LineNo: Integer; Prev: PJStatement; ID: PJExpr): PJStatement;
    function MakeClassDecl(LineNo: Integer; Name,Super: PJExpr; Block: PJStatement): PJStatement;
    function MakeVariableDecl(LineNo: Integer; Name,Value: PJExpr): PJStatement;
    function MakeImportDecl(LineNo: Integer; Name: PJExpr; SourceElements: PJStatement): PJStatement;
    function MakeLabeledStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
    function MakeSwitchStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
  end;

implementation


{ TJStatementFactory }

procedure TJStatementFactory.Clear;
//NA
var
  i: Integer;
begin
  for i := FList.Count - 1 downto 0 do
    FreeStatement(FList[i]);

  FList.Clear;
end;

constructor TJStatementFactory.Create(AExprFactory: TJExprFactory);
begin
  inherited Create;
  FList := TList.Create;
  FExprFactory := AExprFactory;
end;

destructor TJStatementFactory.Destroy;
begin
  Clear;
  FList.Free;
  inherited;
end;

procedure TJStatementFactory.FreeStatement(P: PJStatement);
begin
  Dispose(P);
end;  

function TJStatementFactory.NewStatement: PJStatement;
//VK쐬
begin
  New(Result);
  FillChar(Result^,SizeOf(TJStatement),0);
  Result^.SType := stNone;
  FList.Add(Result);
end;

function TJStatementFactory.MakeExprStatement(LineNo: Integer; Expr: PJExpr): PJStatement;
//̍쐬
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.Expr := Expr;
  Result^.SType := stExpr;
end;

function TJStatementFactory.MakeBlockStatement(LineNo: Integer; Statements: PJStatement): PJStatement;
//ubN쐬
// block - next(...)
// |-sub1(statements) - next(...)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stBlock;
  Result^.Sub1 := MoveStart(Statements);
end;

function TJStatementFactory.MakeParamDecl(LineNo: Integer; Prev: PJStatement; ID: PJExpr): PJStatement;
//֐p[^錾
// param_decl(ID) - next(param_decl) - next(...)
//var
//  e: TJExpr;
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stParamDecl;
  Result^.Expr := ID;
  //e := ID^;
  MergeStatement(Prev,Result);
end;

function TJStatementFactory.MakeFunctionDecl(LineNo: Integer; ID: PJExpr; ParamDecl,Block: PJStatement): PJStatement;
//֐錾
// function_decl - next(...)
// |-sub1(paramdecl) - next(param_decl) - next(...)
// |-sub2(block)
//   |-sub1(statements) - next(...)
var
  ret: PJStatement;
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stFunctionDecl;
  Result^.Sub1 := MoveStart(ParamDecl);
  Result^.Sub2 := MoveStart(Block);
  Result^.Expr := ID;
  //block̍Ōreturnt
  ret := MakeReturnStatement(E_UNKNOWN_LINE_NO,FExprFactory.NewExpr);
  MergeStatement(MoveLast(Block),ret);
end;

function TJStatementFactory.MakeReturnStatement(LineNo: Integer; Expr: PJExpr): PJStatement;
//return쐬
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stReturn;
  Result^.Expr := Expr;
end;

function TJStatementFactory.MoveStart(P: PJStatement): PJStatement;
//ŏɈړ
begin
  Result := P;
  while Assigned(Result) do
  begin
    //eȂΏI
    if not Assigned(Result^.Parent) then
      Break
    else
      Result := Result^.Parent;
  end;
end;

function TJStatementFactory.MoveLast(P: PJStatement): PJStatement;
//ŌɈړ
begin
  Result := P;
  while Assigned(Result) do
  begin
    //ȂȂI
    if not Assigned(Result^.Next) then
      Break
    else
      Result := Result^.Next;
  end;
end;

procedure TJStatementFactory.MergeStatement(Prev,Next: PJStatement);
//݂ɂ  next <-> parent̂
begin
  if Assigned(Prev) then
    Prev^.Next := Next;

  if Assigned(Next) then
    Next^.Parent := Prev;
end;

function TJStatementFactory.MakeIfStatement(LineNo: Integer; Expr: PJExpr; TrueBlock,FalseBlock: PJStatement): PJStatement;
//if쐬
// if   - next(...)
// |-sub1(trueblock)
// |-sub2(falseblock)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stIf;
  Result^.Expr := Expr;
  Result^.Sub1 := TrueBlock;
  Result^.Sub2 := FalseBlock;
end;

function TJStatementFactory.MakeWhileStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
//while쐬
// while(expr)  - next(...)
// |-sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stWhile;
  Result^.Expr := Expr;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeForStatement(LineNo: Integer; Expr1,Expr2,Expr3: PJExpr; Block: PJStatement): PJStatement;
//for쐬
// for(expr1) --- next(...)
// |-sub1(block)
// |-sub2(expr2) --- next(expr3)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stFor;
  Result^.Expr := Expr1;
  Result^.Sub1 := Block;

  Result^.Sub2 := NewStatement;
  Result^.Sub2^.Expr := Expr2;

  Result^.Sub2^.Next := NewStatement;
  Result^.Sub2^.Next^.Expr := Expr3;
end;

function TJStatementFactory.MakeForInStatement(LineNo: Integer; Expr1,Expr2: PJExpr;
  Block: PJStatement; ArrayElement: Boolean): PJStatement;
//for (in)쐬
// forin(expr1 - variable) --- next(...)
// |-sub1(block)
// |-sub2(expr2 - object)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  if ArrayElement then
    Result^.SType := stForInArrayElement
  else
    Result^.SType := stForIn;

  Result^.Expr := Expr1;
  Result^.Sub1 := Block;
  //IuWFNg
  Result^.Sub2 := NewStatement;
  Result^.Sub2^.Expr := Expr2;
end;

function TJStatementFactory.MakeContinueStatement(LineNo: Integer): PJStatement;
//contnue쐬
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stContinue;
end;

function TJStatementFactory.MakeBreakStatement(LineNo: Integer): PJStatement;
//break쐬
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stBreak;
end;

function TJStatementFactory.MakeWithStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
//with쐬
// with(expr)  - next(...)
//  |
// sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stWith;
  Result^.Expr := Expr;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeTryStatement(LineNo: Integer; Block: PJStatement): PJStatement;
//try쐬
// try - next(...)
//  |
// sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stTry;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeCatchStatement(LineNo: Integer; Expr: PJExpr; Block: PJStatement): PJStatement;
//catch쐬
// catch(variable) - next(...)
//  |
// sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stCatch;
  Result^.Expr := Expr;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeFinallyStatement(LineNo: Integer; Block: PJStatement): PJStatement;
//finally쐬
// finally - next(...)
//  |
// sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stFinally;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeThrowStatement(LineNo: Integer; Expr: PJExpr): PJStatement;
//trow쐬
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stThrow;
  Result^.Expr := Expr;
end;

function TJStatementFactory.MakeEmptyStatement(LineNo: Integer): PJStatement;
//󕶂쐬
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
end;

function TJStatementFactory.MakeVarDecl(LineNo: Integer; Stmt: PJStatement): PJStatement;
//var쐬
//var( ) - next(...)
// |- sub1(variable_declaration_list)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stVar;
  Result^.Sub1 := Stmt;
end;

function TJStatementFactory.MakeDoStatement(LineNo: Integer; Expr: PJExpr;
  Block: PJStatement): PJStatement;
//do - while쐬
// do(expr)  - next(...)
// |-sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stDo;
  Result^.Expr := Expr;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeClassDecl(LineNo: Integer; Name, Super: PJExpr;
  Block: PJStatement): PJStatement;
//classdecl(expr: name,expr.left: super)  ... next(...)
// |- sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stClassDecl;
  Result^.Expr := Name;
  Result^.Expr^.Left := Super;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeVariableDecl(LineNo: Integer;
  Name,Value: PJExpr): PJStatement;
// memberdecl(expr: name,expr.left: value) - next(...)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stVarDecl;
  Result^.Expr := Name;
  Result^.Expr^.Left := Value;
end;

function TJStatementFactory.MakeImportDecl(LineNo: Integer; Name: PJExpr; SourceElements: PJStatement): PJStatement;
// importdecl(expr: name)
//  | sub1(source_elements)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stImport;
  Result^.Expr := Name;
  Result^.Sub1 := SourceElements;
end;

function TJStatementFactory.MakeLabeledStatement(LineNo: Integer; Expr: PJExpr;
  Block: PJStatement): PJStatement;
//labeled쐬
// case(const) - next(...)
// default
//  |
// sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stLabeled;
  //exprnil̏ꍇdefault
  Result^.Expr := Expr;
  Result^.Sub1 := Block;
end;

function TJStatementFactory.MakeSwitchStatement(LineNo: Integer; Expr: PJExpr;
  Block: PJStatement): PJStatement;
//switch쐬
// switch(expr) - next(...)
//  |
// sub1(block)
begin
  Result := NewStatement;
  Result^.LineNo := LineNo;
  Result^.SType := stSwitch;
  Result^.Expr := Expr;
  Result^.Sub1 := Block;
end;



end.
