﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace CaLib.User
{
	/// <summary>
	/// APL全般で使う例外クラス。
	/// CA2201の対応のため導入
	/// </summary>
	public class FundamentalException : Exception
	{
		// 概要:
		//     Initializes a new instance of the FundamentalException class.
		public FundamentalException() 
			: base() 
		{ 
		}
		//
		// 概要:
		//     Initializes a new instance of the FundamentalException class with
		//     a specified error message.
		//
		// パラメータ:
		//   message:
		//     A message that describes the error.
		public FundamentalException(string message)
			: base(message)
		{ 
		}
		//
		// 概要:
		//     Initializes a new instance of the FundamentalException class with
		//     serialized data.
		//
		// パラメータ:
		//   info:
		//     The object that holds the serialized object data.
		//
		//   context:
		//     The contextual information about the source or destination.
		protected FundamentalException(SerializationInfo info, StreamingContext context)
			: base(info, context)
		{ 
		}

		//
		// 概要:
		//     Initializes a new instance of the FundamentalException class with
		//     a specified error message and a reference to the inner exception that is
		//     the cause of this exception.
		//
		// パラメータ:
		//   message:
		//     The error message that explains the reason for the exception.
		//
		//   innerException:
		//     The exception that is the cause of the current exception. If the innerException
		//     parameter is not a null reference, the current exception is raised in a catch
		//     block that handles the inner exception.
		public FundamentalException(string message, Exception innerException)
			: base(message, innerException)
		{ 
		}	
	}
}
