﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.IO;

namespace CaLib.User
{
	public class ReservableListBox : ListBox
	{
		int maxItemCount_ = 100;

		public ReservableListBox()
		{ 
		}

		public void SetMax(int max)
		{
			maxItemCount_ = max;

			if (this.Items.Count > maxItemCount_)
			{
				RemoveOld(this.Items.Count - maxItemCount_);
			}
		}

		public void Save(FileStream fs)
		{
			XmlSerializer serializer = new XmlSerializer(typeof(string[]));

			string[] array = new string[this.Items.Count];

			this.Items.CopyTo(array, 0);

			serializer.Serialize(fs, array);
		}

		private void Read(FileStream fs)
		{
			XmlSerializer serializer = new XmlSerializer(typeof(string[]));

			string[] array = null;

			object o = serializer.Deserialize(fs);

			array = (string[])o;

			this.Items.Clear();

			for (int idx = array.Length; idx > 0; idx--)
			{
				this.InsertHead(array[idx - 1]);
			}
		}

		public void Read(string filepath)
		{
			if (!File.Exists(filepath))
			{
				return;
			}

			using (FileStream fs = new FileStream(filepath, FileMode.Open))
			{
				this.Read(fs);
			}
		}

		public virtual void InsertHead(string s)
		{
			this.Items.Insert(0, s);

			if (this.Items.Count > maxItemCount_)
			{
				RemoveOld(this.Items.Count - maxItemCount_);
			}
		}

		public void RemoveOld(int count)
		{
			for (int i = 0; i < count; i++)
			{
				Items.RemoveAt(Items.Count - 1);
			}
		}
	}
}
