﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.Model;

namespace ClipClop.View
{

	public partial class LogForm : Form
	{
		ActionLogManager mngr_;

		public LogForm()
		{
			InitializeComponent();

			this.listView.Dock = DockStyle.Fill;
			this.listView.View = System.Windows.Forms.View.Details;
		}

		public LogForm(ActionLogManager mngr, FormClosingEventHandler hdr)
		{
			InitializeComponent();

			FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryLogForm, this);

			this.listView.Dock = DockStyle.Fill;
			this.listView.View = System.Windows.Forms.View.Details;

			mngr_ = mngr;
			mngr_.OnLog += this.ActionLogEventHandler;

			this.FormClosing += hdr;
		}

		void ActionLogEventHandler(string message)
		{
			UpdateList();
			listView.Refresh();
		}


		private void LogForm_Load(object sender, EventArgs e)
		{
			this.listView.VirtualMode = true;

			Graphics g = Graphics.FromHwnd(this.listView.Handle);

			// 
			// columnHeaderTime
			// 
			this.columnHeaderTime.Width = (int)g.MeasureString(DateTime.Now.ToString(), this.listView.Font).Width + 3;

			// 
			// columnHeaderMsg
			// 
			this.columnHeaderMsg.Width = this.listView.Width - this.columnHeaderTime.Width;
			
			UpdateList();
		}

		public void UpdateList()
		{
			this.listView.VirtualListSize = this.mngr_.Count;
		}

		private void listView_RetrieveVirtualItem(object sender, RetrieveVirtualItemEventArgs e)
		{
			if (this.mngr_.Count > e.ItemIndex)
			{
				int idx = this.mngr_.Count - e.ItemIndex - 1;
				ActionLogManager.Data d = this.mngr_[idx];

				e.Item = new ListViewItem(d.Item);
			}
		}
		private void listView_CacheVirtualItems(object sender, CacheVirtualItemsEventArgs e)
		{

		}		

		private void LogForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			mngr_.OnLog -= this.ActionLogEventHandler;

			Properties.Settings.Default.WindowGeometryLogForm = FormUtil.GeometryToString(this);
		}
	}

}
