﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ClipClop.View
{
    public class TemplateSettingTreeNodeAction
    {
        readonly TemplateSettingTreeNode source_;
        readonly TemplateSettingTreeNode target_;
        readonly DragDropEffects effect_;

        public TemplateSettingTreeNodeAction(TemplateSettingTreeNode source, TemplateSettingTreeNode target, DragDropEffects effect)
        {
            this.source_ = source;
            this.target_ = target;
            this.effect_ = effect;

            if (target == null)
            {
                throw new Exception();
            }
            if (target == source)
            {
                throw new Exception();
            }
        }

        public bool IsMoveRoot
        {
            get
            {
                if (this.effect_ != DragDropEffects.Move)
                    return false;
                return this.source_.IsRoot();
            }
        }
        public bool IsCopyRoot
        {
            get
            {
                if (this.effect_ != DragDropEffects.Copy)
                    return false;
                return this.source_.IsRoot();
            }
        }

        /// <summary>
        /// 親を子供にコピー/移動するのかどうか
        /// </summary>
        public bool IsDescendingOrder
        {
            get
            {
                return IsChildNode(this.source_, this.target_);
            }
        }


        /// <summary>
        /// あるTreeNodeが別のTreeNodeの子ノードか調べる
        /// </summary>
        /// <param name="parent">親ノードか調べるTreeNode</param>
        /// <param name="child">子ノードか調べるTreeNode</param>
        /// <returns>子ノードの時はTrue</returns>
        public static bool IsChildNode(TreeNode source, TreeNode target)
        {
            if (target.Parent == source)
                return true;
            else if (target.Parent != null)
                return IsChildNode(source, target.Parent);
            else
                return false;
        }
    }
}
