﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace WinApi
{
	public abstract class User32
	{
		[DllImport("user32")]
		public static extern IntPtr SetClipboardViewer(IntPtr hWndNewViewer);

		[DllImport("user32")]
		public static extern bool ChangeClipboardChain(IntPtr hWndRemove, IntPtr hWndNewNext);

		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = false)]
		public static extern IntPtr SendMessage(IntPtr hWnd, Int32 Msg, IntPtr wParam, IntPtr lParam);


		public const int MOD_ALT = 0x0001;
		public const int MOD_CONTROL = 0x0002;
		public const int MOD_SHIFT = 0x0004;

		/// <summary>
		/// ホットキーを登録する 
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="id"></param>
		/// <param name="fsModifier">特殊キーのコードです。特殊キーはＡＬＴキー（９８ならＧＲＰＨキー）、ＣＴＲＬキー、SHIFTキー。</param>
		/// <param name="vk">キーコードが入ります。例えば「ＣＴＲＬ＋Ａ」であれば、「Ａ」</param>
		/// <returns></returns>
		[DllImport("user32")]
		public static extern int RegisterHotKey(IntPtr hWnd, int id, int fsModifier, int vk);

		/// <summary>
		/// ホットキーを解除する
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="id"></param>
		/// <returns></returns>
		[DllImport("user32")]
		public static extern int UnregisterHotKey(IntPtr hWnd, int id);


        public const uint GW_CHILD = 5;
        //public const uint GW_ENABLEDPOPUP = x; 
        //public const uint GW_HWNDFIRST = x;
        //public const uint GW_HWNDLAST = x;
        public const uint GW_HWNDNEXT = 2;
        //public const uint GW_HWNDPREV = x;
        public const uint GW_OWNER = 4;

        [DllImport("user32.dll")]
        public static extern IntPtr GetWindow(IntPtr hWnd, uint uCmd);

        [DllImport("user32.dll")]
        public static extern IntPtr GetForegroundWindow();

        [DllImport("user32.dll")]
        public static extern int GetWindowText(IntPtr hWnd, StringBuilder lpStr, int nMaxCount);

        [DllImport("user32.dll")]
        public static extern bool IsWindowVisible(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern bool SetForegroundWindow(IntPtr hWnd);


        [StructLayout(LayoutKind.Sequential)]
        public struct POINT
        {
            public int x;
            public int y;
        }

        [DllImport("user32.dll")]
        public static extern IntPtr WindowFromPoint(POINT Point);
	}
}
