/*
 * Decompiled with CFR 0.152.
 */
package com.stc.codegen.OTDImpl.model;

import com.stc.bpms.common.integration.model.wsdlproducer.PortTypeImm;
import com.stc.bpms.common.integration.model.wsdlproducer.WSDLDefinitionsImm;
import com.stc.bpms.common.integration.model.wsdlproducer.WSDLProducer;
import com.stc.codegen.framework.model.CodeGenFramework;
import com.stc.codegen.framework.model.ErrorBundle;
import com.stc.codegen.framework.model.ErrorEntry;
import com.stc.codegen.framework.model.util.CodeGenHelper;
import com.stc.guirepositorymanager.GUIRepositoryManager;
import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.ObjectTypeDefinition51;
import com.stc.model.common.Project;
import com.stc.model.common.ProjectElement;
import com.stc.otd.codegen.BaseFogGenerator;
import com.stc.otd.codegen.BaseGenerator;
import com.stc.otd.codegen.CodeGeneratorFactory;
import com.stc.otd.codegen.FogGenerator;
import com.stc.otd.codegen.Generator;
import com.stc.otd.fog.FogContext;
import com.stc.otd.fog.FogOrder;
import com.stc.otd.fog.FogOtdRef;
import com.stc.otd.fog.FogVerifyReport;
import com.stc.otd.fog.provider.FogCommonModule;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.provider.OtdCommonModule;
import com.stc.otd.forest.provider.OtdXMLUtil;
import com.stc.otd.jinfo.JavaInfo;
import com.stc.otd.jinfo.provider.JavaInfoFactory;
import com.stc.otd.model.CollaborationMessage;
import com.stc.otd.model.OTDHead;
import com.stc.otd.tools.util.OTDPathUtil;
import com.stc.otd.tools.xml.OtdHeadParser;
import com.stc.repository.Repository;
import com.stc.repository.RepositoryException;
import com.stc.repository.persistence.VersionManager;
import com.stc.repository.persistence.client.ACLHelper;
import com.stc.repository.persistence.client.Persistable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class CollabOTDGenerator {
    private ClassLoader mSystemClassLoader;
    ResourceBundle rb = ResourceBundle.getBundle("com.stc.codegen.OTDImpl.model.Bundle");
    private Logger mLog = Logger.getLogger((String)this.getClass().getName());
    private Repository mRepository;
    private CodeGenHelper mHelper;
    private String mDestinationPath;
    private List mJarList;
    private String mLastGeneratedJarFileName;
    private File[] mDependentJarFiles;

    public CollabOTDGenerator(String destPath, Repository repository, ClassLoader systemClassLoader) {
        this.mLog.debug((Object)"const CollabOTDGenerator");
        this.setDestinationPath(destPath);
        this.mRepository = repository;
        this.mSystemClassLoader = systemClassLoader;
    }

    public CollabOTDGenerator(String destPath, Repository repository, ClassLoader systemClassLoader, CodeGenHelper helper) {
        this.mLog.debug((Object)"const CollabOTDGenerator");
        this.setDestinationPath(destPath);
        this.mRepository = repository;
        this.mSystemClassLoader = systemClassLoader;
        this.mHelper = helper;
    }

    public void setDestinationPath(String destPath) {
        this.mDestinationPath = destPath;
    }

    public void setDependentJarFiles(File[] dependentJarFiles) {
        this.mDependentJarFiles = dependentJarFiles;
    }

    public List getJarList() {
        return this.mJarList;
    }

    public String getLastGeneratedJarFileName() {
        return this.mLastGeneratedJarFileName;
    }

    private String getPathFromProject(Project project, String otdName) throws RepositoryException {
        StringBuffer path = new StringBuffer(project.getName());
        for (Project parent = project.getParentProject(); parent != null; parent = parent.getParentProject()) {
            path.insert(0, parent.getName() + "/");
        }
        path.append("/" + otdName);
        return path.toString();
    }

    public String generateCollabOTDJavaFiles(ObjectTypeDefinition otd) throws Exception {
        String otdPath;
        OTDHead head;
        if (otd == null) {
            throw new RuntimeException("otd is null");
        }
        String rootType = null;
        List classList = null;
        if (otd instanceof ObjectTypeDefinition51 && (head = OtdHeadParser.getOTDHead((Repository)this.mRepository, (String)(otdPath = OTDPathUtil.getOTDPath((ObjectTypeDefinition)otd)))) != null) {
            Generator gen = CodeGeneratorFactory.createCodeGenerator((String)head.getGenerator(), (ClassLoader)this.mSystemClassLoader);
            switch (head.getGenAPI()) {
                case 1: {
                    FogGenerator fogGen = (FogGenerator)gen;
                    FogContext fogCtx = FogCommonModule.getOtdContext((Repository)this.mRepository, (ClassLoader)this.mSystemClassLoader);
                    FogOtdRef ref = fogCtx.makeOtdRef(otdPath);
                    FogOrder fogOrder = ref.load(true, true);
                    fogGen.setDependentJarFiles(this.mDependentJarFiles);
                    Set jars = fogGen.generate(fogOrder, new File(this.mDestinationPath), null);
                    classList = fogGen.getDependentJarClassNames();
                    this.mJarList = this.classesToJars(classList);
                    this.mJarList.addAll(jars);
                    rootType = this.getFogOrderJavaName(fogOrder);
                    if (fogGen instanceof BaseFogGenerator) {
                        File file = ((BaseFogGenerator)fogGen).getJarFileName(fogOrder);
                        this.mLastGeneratedJarFileName = file.getName();
                    }
                    fogOrder = null;
                    return rootType;
                }
                case 0: {
                    OtdContext context = OtdCommonModule.getOtdContext((Repository)this.mRepository, (ClassLoader)this.mSystemClassLoader);
                    OtdMetaContainer otdMeta = context.lookUpOtd(otdPath);
                    gen.generate(otdMeta, new File(this.mDestinationPath));
                    classList = gen.getDependentJarClassNames();
                    this.mJarList = this.classesToJars(classList);
                    rootType = this.getOtdForestJavaName(otdMeta, Integer.toString(otd.getTopNodeId()));
                    if (gen instanceof BaseGenerator) {
                        this.mLastGeneratedJarFileName = ((BaseGenerator)gen).getJarFileName(otdMeta);
                    }
                    otdMeta = null;
                    return rootType;
                }
            }
        }
        return this.oldGenOtdJavaFiles(otd);
    }

    public String oldGenOtdJavaFiles(ObjectTypeDefinition otd) throws Exception {
        String otdPath = this.getPathFromProject(otd.getParentProject(), otd.getName());
        OtdContext context = OtdCommonModule.getOtdContext((Repository)this.mRepository, (ClassLoader)this.mSystemClassLoader);
        OtdMetaContainer otdMeta = context.lookUpOtd(otdPath);
        Generator gen = CodeGeneratorFactory.createCodeGenerator((String)otdMeta.getOtdType(), (ClassLoader)this.mSystemClassLoader);
        gen.generate(otdMeta, new File(this.mDestinationPath));
        List classList = gen.getDependentJarClassNames();
        this.mJarList = this.classesToJars(classList);
        String forestJavaName = this.getOtdForestJavaName(otdMeta, Integer.toString(otd.getTopNodeId()));
        if (gen instanceof BaseGenerator) {
            this.mLastGeneratedJarFileName = ((BaseGenerator)gen).getJarFileName(otdMeta);
        }
        otdMeta = null;
        return forestJavaName;
    }

    public String generatePortType(ObjectTypeDefinition otd) throws Exception {
        if (otd instanceof WSDLProducer) {
            WSDLDefinitionsImm wdef = ((WSDLProducer)otd).getWSDLDocumentImm().getDocumentDefinitions();
            List portlist = wdef.getPortTypes();
            String portType = ((PortTypeImm)portlist.get(0)).getName();
            String suffix = "PortType";
            return portType.substring(0, portType.length() - suffix.length());
        }
        throw new Exception("OTD should be WSDLProducer");
    }

    public void validate(ObjectTypeDefinition otd, ErrorBundle bundle, CodeGenFramework codegen) {
        try {
            String otdPath = this.getPathFromProject(otd.getParentProject(), otd.getName());
            FogContext fogCtx = FogCommonModule.getOtdContext((Repository)this.mRepository, (ClassLoader)this.mSystemClassLoader);
            FogOrder fogOrder = fogCtx.load(otdPath, false, true);
            FogVerifyReport report = fogOrder.verify();
            if (report != null && report.isFatal()) {
                for (int i = 0; i < report.size(); ++i) {
                    FogVerifyReport.Concern concern = report.get(i);
                    if (!concern.isFatal()) continue;
                    ErrorEntry entry = codegen.createErrorEntry((ProjectElement)otd, (Object)concern.nodes(), concern.text());
                    bundle.addError(entry);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String getOtdForestJavaName(OtdMetaContainer otdMeta, String topNodeId) throws Exception {
        JavaInfo ji = JavaInfoFactory.getRepositoryJavaInfo();
        return ji.getJavaType(otdMeta, topNodeId);
    }

    private String getFogOrderJavaName(FogOrder fogOrder) throws Exception {
        JavaInfo ji = JavaInfoFactory.getRepositoryJavaInfo();
        return ji.getJavaType(fogOrder, this.mSystemClassLoader);
    }

    private void updateJavaName(ObjectTypeDefinition otd, String javaClass) throws RepositoryException {
        boolean editable = true;
        String lLockedBy = "";
        if (!this.isEnableBasedOnACL(otd) && ((CollaborationMessage)otd).getJavaName() == null) {
            throw new RepositoryException("\n\tOTD " + otd.getName() + " has not been validated and you do not have permission for the OTD." + "\n\tThe OTD must be validated prior to activation.");
        }
        if (!this.isEnableBasedOnTheACLOfTheParent(otd) && ((CollaborationMessage)otd).getJavaName() == null) {
            throw new RepositoryException("\n\tOTD " + otd.getName() + " has not been validated and you do not have permission for the OTD." + "\n\tThe OTD must be validated prior to activation.");
        }
        VersionManager vm = this.mRepository.getVersionManager();
        if (!otd.isLocked()) {
            lLockedBy = otd.getVersionInfo().getLock();
            if (lLockedBy != null && !lLockedBy.equals("")) {
                editable = false;
            }
        } else {
            ((CollaborationMessage)otd).setJavaName(javaClass);
            vm.saveToWorkspace((Persistable)otd);
            return;
        }
        if (editable) {
            vm.checkOutForWrite((Persistable)otd);
            ((CollaborationMessage)otd).setJavaName(javaClass);
            vm.checkIn((Persistable)otd, this.rb.getString("STR_MOD_JNAME"));
        } else if (((CollaborationMessage)otd).getJavaName() == null) {
            throw new RepositoryException("\n\tOTD " + otd.getName() + " has not been validated and is currently checked out by user " + lLockedBy + ".\n\tThe OTD must be validated prior to activation.");
        }
    }

    private boolean isEnableBasedOnACL(ObjectTypeDefinition otd) {
        ACLHelper lACLHelper = null;
        try {
            lACLHelper = otd.getPersistableSupport().getACLHelper();
        }
        catch (Exception e) {
            this.mLog.error((Object)e.getMessage());
            return false;
        }
        String lUserID = GUIRepositoryManager.getUserName();
        String lSuperUser = "Administrator";
        String lACLInfo = lACLHelper.getEncodedString();
        if (lUserID.equals(lSuperUser) || lACLInfo == null || lACLInfo != null && lACLInfo.equals("")) {
            return true;
        }
        return lACLHelper.isWritable(lUserID);
    }

    private boolean isEnableBasedOnTheACLOfTheParent(ObjectTypeDefinition otd) {
        Project lParentProject = null;
        try {
            lParentProject = otd.getParentProject();
        }
        catch (RepositoryException e) {
            this.mLog.error((Object)e.getMessage());
            return false;
        }
        if (lParentProject == null) {
            return false;
        }
        ACLHelper lParentACLHelper = null;
        try {
            lParentACLHelper = lParentProject.getPersistableSupport().getACLHelper();
        }
        catch (RepositoryException e) {
            this.mLog.error((Object)e.getMessage());
            return false;
        }
        String lParentACLInfo = lParentACLHelper.getEncodedString();
        if (lParentACLInfo == null || lParentACLInfo != null && lParentACLInfo.equals("")) {
            return true;
        }
        String lUserID = GUIRepositoryManager.getUserName();
        return lParentACLHelper.isWritable(lUserID);
    }

    public String getJavaName(ObjectTypeDefinition otd) throws Exception {
        String data = otd.getOtdMetaContainer();
        OtdMetaContainer container = OtdXMLUtil.parseOtd((String)data);
        return this.getOtdForestJavaName(container, String.valueOf(otd.getTopNodeId()));
    }

    private List classesToJars(List classes) {
        ArrayList<String> jars = new ArrayList<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            String clazz = (String)it.next();
            this.mLog.debug((Object)("Packaging class " + clazz));
            File jarF = this.mHelper.getJar(this.mSystemClassLoader, clazz);
            if (!jarF.exists()) continue;
            jars.add(jarF.getAbsolutePath());
        }
        return jars;
    }
}

