/*
 * Decompiled with CFR 0.152.
 */
package com.stc.codegen.OTDImpl.runtime.ejb;

import com.stc.codegen.framework.runtime.CMRequest;
import com.stc.codegen.framework.runtime.CMRequestHandler;
import com.stc.codegen.framework.runtime.ObjectFactory;
import com.stc.log4j.Logger;
import com.stc.otd.runtime.OtdInputStream;
import com.stc.otd.runtime.OtdOutputStream;
import com.stc.otd.runtime.OtdRoot;
import com.stc.otd.runtime.provider.SimpleOtdInputStreamImpl;
import com.stc.otd.runtime.provider.SimpleOtdOutputStreamImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class OTDRequestHandler
implements CMRequestHandler {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object createOutput() {
        return null;
    }

    public void handleRequest(CMRequest request) {
        String className;
        String op = request.getCMOperation();
        Object obj = request.getInputMessage();
        Object output = null;
        try {
            className = this.getClassName(request.getDestination());
        }
        catch (IOException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("class name = " + className));
        }
        if (op.equals("marshal")) {
            OtdRoot root = (OtdRoot)obj;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SimpleOtdOutputStreamImpl otdOut = new SimpleOtdOutputStreamImpl((OutputStream)baos);
            try {
                root.marshal((OtdOutputStream)otdOut);
            }
            catch (IOException e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            StreamMessage msg = new StreamMessage();
            msg.setContents(baos.toString());
            output = msg;
        } else if (op.equals("unmarshal")) {
            OtdRoot otd;
            try {
                otd = (OtdRoot)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            String msg = ((StreamMessage)obj).getContents();
            if (msg != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes());
                try {
                    SimpleOtdInputStreamImpl otdInputStream = new SimpleOtdInputStreamImpl((InputStream)is);
                    otd.unmarshal((OtdInputStream)otdInputStream);
                }
                catch (IOException e) {
                    this.logger.error((Object)e, (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            }
            output = otd;
        }
        request.createCMReply().setOutputMessage(output);
    }

    private String getClassName(String destination) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(destination + ".otdmap");
        Properties otdMap = new Properties();
        otdMap.load(is);
        String className = (String)otdMap.get(destination);
        return className;
    }

    public void initialize() {
    }

    public void registerPartner(String name, CMRequestHandler handler) {
    }

    public void start() {
    }

    public void stop() {
    }

    public void terminate() {
    }

    public static class StreamMessage {
        private String contents;

        public String getContents() {
            return this.contents;
        }

        public void setContents(String ctx) {
            this.contents = ctx;
        }
    }

    public static class MyMessageFactory
    implements ObjectFactory {
        private Logger logger = Logger.getLogger((String)this.getClass().getName());

        public Object createObject(String messageType) {
            StreamMessage msg = null;
            if (messageType.startsWith("com.stc.otd,")) {
                messageType = messageType.substring("com.stc.otd,".length());
                try {
                    msg = Class.forName(messageType).newInstance();
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            } else if (messageType.equals("Stream")) {
                msg = new StreamMessage();
            }
            return msg;
        }

        public Object recreateObject(String objectType, InputStream is) {
            return null;
        }
    }
}

