/*
 * Decompiled with CFR 0.152.
 */
package earupdater;

import earupdater.Zipper;
import earupdater.transformer.Application;
import earupdater.transformer.Ejb_Jar;
import earupdater.transformer.Ra;
import earupdater.transformer.Sun_Ejb_Jar;
import earupdater.transformer.Sun_RAR;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Ear_1 {
    private File backup_classesDir;
    private File unearDir;
    private File xml_henkoumaeDir;
    private File ra_xml_henkoumaeDir;
    private File oldjarDir;
    private File oldrarDir;
    private File unjarDir;
    private File unrarDir;
    private File henkokakunoDir;
    private File tempFolder;
    private ArrayList errorCollection = new ArrayList();
    private boolean showtransformationdetaillog;
    private boolean isEJB_JAR_ModificationTarget = true;
    private boolean isSUN_EJB_JAR_ModificationTarget = true;
    private boolean isAPPLICATIONXML_ModificationTarget = true;
    private boolean isMANIFEST_MF_ModificationTarget = false;
    private boolean isRA_ModificationTarget = false;
    private boolean isSUN_RA_ModificationTarget = false;
    private boolean skipAddingWorkflowSerivceClientJAR = false;
    private String workflowservicejarname = "WorkflowServiceClient.jar";
    private String ConnectorResourceQueue;
    private String ConnectorResourceTopic;
    private Set dirtyJogai = new HashSet();

    public void setisRA_ModificationTarget(boolean value) {
        this.isRA_ModificationTarget = value;
    }

    public void setisSUN_RA_ModificationTarget(boolean value) {
        this.isSUN_RA_ModificationTarget = value;
    }

    public void setskipAddingWorkflowSerivceClientJAR(boolean value) {
        this.skipAddingWorkflowSerivceClientJAR = value;
    }

    public void setWorkflowServiceJarName(String value) {
        this.workflowservicejarname = value;
    }

    public void setHenkokakunoFolder(File value) {
        this.henkokakunoDir = value;
    }

    public void setisMANIFEST_MF_ModificationTarget(boolean value) {
        this.isMANIFEST_MF_ModificationTarget = value;
    }

    public void setisAPPLICATIONXML_ModificationTarget(boolean value) {
        this.isAPPLICATIONXML_ModificationTarget = value;
    }

    public void setisEJB_JAR_ModificationTarget(boolean value) {
        this.isEJB_JAR_ModificationTarget = value;
    }

    public void setisSUN_EJB_JAR_ModificationTarget(boolean value) {
        this.isSUN_EJB_JAR_ModificationTarget = value;
    }

    public void setShowTransformationDetailLog(boolean value) {
        this.showtransformationdetaillog = value;
    }

    public void setWorkFlowServiceAsLocalCallPattern() {
        this.setisAPPLICATIONXML_ModificationTarget(true);
        this.setisEJB_JAR_ModificationTarget(true);
        this.setskipAddingWorkflowSerivceClientJAR(false);
    }

    public boolean success() {
        return this.errorCollection.size() == 0;
    }

    private HashSet getAllDirtyJarFileNames() {
        File[] fb3;
        int i;
        File[] fb2;
        File backup_classes = new File(this.unearDir.getParent() + File.separator + "backup_classes");
        File xml_henkoumae = new File(this.unearDir.getParent() + File.separator + "xml_henkoumae");
        HashSet<String> alldirty = new HashSet<String>();
        if (backup_classes != null && (fb2 = backup_classes.listFiles()) != null) {
            for (i = 0; i < fb2.length; ++i) {
                if (fb2[i].getName().equalsIgnoreCase("META-INF")) continue;
                alldirty.add(fb2[i].getName());
            }
        }
        if (xml_henkoumae != null && (fb3 = xml_henkoumae.listFiles()) != null) {
            for (i = 0; i < fb3.length; ++i) {
                if (fb3[i].getName().equalsIgnoreCase("META-INF") || this.dirtyJogai.contains(fb3[i].getAbsolutePath())) continue;
                alldirty.add(fb3[i].getName());
            }
        }
        return alldirty;
    }

    private HashSet getAllDirtyRarFileNames() {
        File[] fb3;
        HashSet<String> alldirty = new HashSet<String>();
        if (this.ra_xml_henkoumaeDir != null && (fb3 = this.ra_xml_henkoumaeDir.listFiles()) != null) {
            for (int i = 0; i < fb3.length; ++i) {
                if (fb3[i].getName().equalsIgnoreCase("META-INF")) continue;
                alldirty.add(fb3[i].getName());
            }
        }
        return alldirty;
    }

    public void zipAllJarsOfUnjarFolder() {
        Zipper mm = new Zipper();
        HashSet alldirtyfiles = this.getAllDirtyJarFileNames();
        try {
            File[] jarnameDirs = this.unjarDir.listFiles();
            for (int i = 0; i < jarnameDirs.length; ++i) {
                if (alldirtyfiles.contains(jarnameDirs[i].getName())) {
                    File tempzip = new File(this.tempFolder.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    String renameto = mm.zipForDir(jarnameDirs[i], tempzip, false, ".jar");
                    System.out.println("JAR\u30d5\u30a1\u30a4\u30eb : " + renameto + "\u306e\u5fa9\u5143\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                    tempzip.renameTo(new File(this.unearDir.getPath() + File.separator + renameto));
                    continue;
                }
                File unmodifiedJar = new File(this.oldjarDir.getAbsolutePath() + File.separator + jarnameDirs[i].getName() + ".jar");
                unmodifiedJar.renameTo(new File(this.unearDir.getPath() + File.separator + unmodifiedJar.getName()));
                System.out.println("\u5909\u66f4\u306e\u306a\u3044JAR\u30d5\u30a1\u30a4\u30eb:" + unmodifiedJar.getName() + "\u306f\u305d\u306e\u307e\u307e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304b\u3089\u623b\u3057\u307e\u3059\u3002");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorCollection.add(e.getMessage());
        }
    }

    public void zipAllRarsOfUnrarFolder() {
        Zipper mm = new Zipper();
        HashSet alldirtyfiles = this.getAllDirtyRarFileNames();
        try {
            File[] rarnameDirs = this.unrarDir.listFiles();
            for (int i = 0; i < rarnameDirs.length; ++i) {
                if (alldirtyfiles.contains(rarnameDirs[i].getName())) {
                    File tempzip = new File(this.tempFolder.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    String renameto = mm.zipForDir(rarnameDirs[i], tempzip, false, ".rar");
                    System.out.println("RAR\u30d5\u30a1\u30a4\u30eb : " + renameto + "\u306e\u5fa9\u5143\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                    tempzip.renameTo(new File(this.unearDir.getPath() + File.separator + renameto));
                    continue;
                }
                File unmodifiedRar = new File(this.oldrarDir.getAbsolutePath() + File.separator + rarnameDirs[i].getName() + ".rar");
                unmodifiedRar.renameTo(new File(this.unearDir.getPath() + File.separator + unmodifiedRar.getName()));
                System.out.println("\u5909\u66f4\u306e\u306a\u3044RAR\u30d5\u30a1\u30a4\u30eb:" + unmodifiedRar.getName() + "\u306f\u305d\u306e\u307e\u307e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304b\u3089\u623b\u3057\u307e\u3059\u3002");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorCollection.add(e.getMessage());
        }
    }

    public void zipEar() {
        Zipper mm = new Zipper();
        try {
            File tempzip = new File(this.tempFolder.getAbsolutePath() + File.separator + System.currentTimeMillis());
            mm.zipForDir(this.unearDir, tempzip, true, ".ear");
            String renameto = this.unearDir.getParentFile().getName() + ".ear";
            System.out.println("EAR\u30d5\u30a1\u30a4\u30eb : " + renameto + "\u306e\u5fa9\u5143\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            tempzip.renameTo(new File(this.tempFolder + File.separator + renameto));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorCollection.add(e.getMessage());
        }
    }

    public void processEar(File targetEar, File tempfolder, File henkokakunouFolder) throws Exception {
        File unrardir;
        File unjardir;
        File oldrarxmldir;
        File oldxmldir;
        if (!targetEar.exists()) {
            throw new Exception("\u30bf\u30fc\u30b2\u30c3\u30c8\u306eEAR\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        if (!tempfolder.exists()) {
            throw new Exception("\u5c55\u958b\u5148\u306e\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a9\u30eb\u30c0\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
        if (!tempfolder.isDirectory()) {
            throw new Exception("\u5c55\u958b\u5148\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4ee5\u5916\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.tempFolder = tempfolder;
        File tenkaisakiDir = new File(tempfolder.getAbsolutePath() + File.separator + this.getPureName(targetEar.getName(), ".EAR") + File.separator + "unear" + File.separator);
        tenkaisakiDir.mkdirs();
        this.unearDir = tenkaisakiDir;
        this.xml_henkoumaeDir = oldxmldir = new File(tenkaisakiDir.getParent() + File.separator + "xml_henkoumae" + File.separator);
        this.ra_xml_henkoumaeDir = oldrarxmldir = new File(tenkaisakiDir.getParent() + File.separator + "ra_xml_henkoumae" + File.separator);
        System.out.println("\u5c55\u958b\u5b8c\u4e86\u3057\u305fJAR\u306e\u79fb\u52d5\u5148\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        File oldjardir = new File(tenkaisakiDir.getParent() + File.separator + "oldjar" + File.separator);
        oldjardir.mkdirs();
        this.oldjarDir = oldjardir;
        System.out.println("\u5c55\u958b\u5b8c\u4e86\u3057\u305fRAR\u306e\u79fb\u52d5\u5148\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        File oldrardir = new File(tenkaisakiDir.getParent() + File.separator + "oldrar" + File.separator);
        oldrardir.mkdirs();
        this.oldrarDir = oldrardir;
        System.out.println(tenkaisakiDir.getAbsolutePath() + "\u3078EAR\u30d5\u30a1\u30a4\u30eb(" + targetEar.getName() + ")\u3092\u5c55\u958b\u3057\u307e\u3059\u30fb\u30fb\u30fb");
        this.processZipFile(targetEar, tenkaisakiDir);
        System.out.println("EAR\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        if (this.isAPPLICATIONXML_ModificationTarget) {
            System.out.println("application.xml\u306e\u66f4\u65b0\u3092\u3057\u3066\u3044\u307e\u3059\u30fb\u30fb\u30fb");
            File applicationxml = new File(tenkaisakiDir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "application.xml");
            String applicationxml_fullpath = applicationxml.getAbsolutePath();
            File old_applicationxml = new File(oldxmldir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "application.xml");
            old_applicationxml.getParentFile().mkdirs();
            applicationxml.renameTo(old_applicationxml);
            File newapplicationxml = new File(applicationxml_fullpath);
            this.processApplication_xml(old_applicationxml, newapplicationxml);
            System.out.println("application.xml\u306e\u66f4\u65b0\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        System.out.println("EAR\u30d5\u30a1\u30a4\u30eb\u5185\u306eJAR\u30d5\u30a1\u30a4\u30eb\u3092\u5c55\u958b\u3057\u307e\u3059\u3002");
        this.processJarDir(tenkaisakiDir);
        System.out.println("JAR\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        this.unjarDir = unjardir = new File(tenkaisakiDir.getParent() + File.separator + "unjar" + File.separator);
        this.unrarDir = unrardir = new File(tenkaisakiDir.getParent() + File.separator + "unrar" + File.separator);
        System.out.println("JAR\u30d5\u30a1\u30a4\u30eb\u4e2d\u306e\u914d\u5099\u8a18\u8ff0\u5b50\u3092\u66f8\u304d\u63db\u3048\u51e6\u7406\u3057\u3066\u3044\u307e\u3059\u30fb\u30fb\u30fb");
        this.processUnJarDir(unjardir, oldxmldir);
        System.out.println("JAR\u30d5\u30a1\u30a4\u30eb\u4e2d\u306e\u914d\u5099\u8a18\u8ff0\u5b50\u306e\u66f8\u304d\u63db\u3048\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        System.out.println("RAR\u30d5\u30a1\u30a4\u30eb\u4e2d\u306e\u914d\u5099\u8a18\u8ff0\u5b50\u3092\u66f8\u304d\u63db\u3048\u51e6\u7406\u3057\u3066\u3044\u307e\u3059\u30fb\u30fb\u30fb");
        this.processUnRarDir(unrardir, oldrarxmldir);
        System.out.println("RAR\u30d5\u30a1\u30a4\u30eb\u4e2d\u306e\u914d\u5099\u8a18\u8ff0\u5b50\u306e\u66f8\u304d\u63db\u3048\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        File fromClassesDir = new File(henkokakunouFolder.getAbsolutePath() + File.separator + "classes");
        this.updateClassFiles(fromClassesDir, unjardir, fromClassesDir);
    }

    public void copyLibraryJar(File henkokakunouFolder) {
        File[] childf = henkokakunouFolder.listFiles();
        for (int i = 0; i < childf.length; ++i) {
            String libname = childf[i].getName();
            if (!libname.toUpperCase().endsWith(".JAR") || !this.canThisLibraryImport(libname)) continue;
            File Toworkflowservice = new File(this.unearDir.getAbsolutePath() + File.separator + childf[i].getName());
            try {
                if (!Toworkflowservice.exists()) {
                    this.copy(childf[i], Toworkflowservice);
                } else {
                    System.out.println(childf[i].getName() + "\u306f\u65e2\u306bEAR\u306b\u5b58\u5728\u3057\u3066\u3044\u308b\u306e\u3067\u4e0a\u66f8\u304d\u3057\u307e\u3059\u3002");
                    File backupold = new File(henkokakunouFolder.getAbsolutePath() + File.separator + childf[i].getName() + "_old_" + System.currentTimeMillis());
                    Toworkflowservice.renameTo(backupold);
                    File newtarget = new File(this.unearDir.getAbsolutePath() + File.separator + childf[i].getName());
                    this.copy(childf[i], newtarget);
                    System.out.println("\u53e4\u3044JAR\u306f" + backupold.getAbsolutePath() + "\u306b\u79fb\u52d5\u3057\u307e\u3057\u305f\u3002");
                }
            }
            catch (Exception copye) {
                this.errorCollection.add(copye.getMessage());
            }
            System.out.println("EAR\u30d5\u30a1\u30a4\u30eb\u3078\u306e" + Toworkflowservice.getName() + "\u306e\u8ffd\u52a0\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
    }

    private boolean canThisLibraryImport(String libraryname) {
        if (!libraryname.equals(this.workflowservicejarname)) {
            return true;
        }
        return !this.skipAddingWorkflowSerivceClientJAR;
    }

    private void processJarDir(File file) {
        File[] dirfiles = file.listFiles();
        for (int i = 0; i < dirfiles.length; ++i) {
            File alternativepath;
            File Roldjar;
            File jarfolder;
            if (dirfiles[i].isFile() && dirfiles[i].getName().toUpperCase().indexOf(".JAR") != -1) {
                jarfolder = new File(dirfiles[i].getParentFile().getParent() + File.separator + "unjar" + File.separator + this.getPureName(dirfiles[i].getName(), ".JAR") + File.separator);
                jarfolder.mkdirs();
                this.processZipFile(dirfiles[i], jarfolder);
                Roldjar = new File(dirfiles[i].getParentFile().getParent() + File.separator + "oldjar" + File.separator + dirfiles[i].getName());
                System.out.println("\u5c55\u958b\u3092\u7d42\u4e86\u3057\u305fJAR\u3092old\u30d5\u30a9\u30eb\u30c0\u306b\u79fb\u52d5\u3057\u307e\u3059:" + Roldjar.getAbsolutePath());
                if (!Roldjar.exists()) {
                    dirfiles[i].renameTo(Roldjar);
                    continue;
                }
                alternativepath = new File(dirfiles[i].getParentFile().getParent() + File.separator + "oldjar" + File.separator + System.currentTimeMillis());
                dirfiles[i].renameTo(alternativepath);
                continue;
            }
            if (dirfiles[i].isFile() && dirfiles[i].getName().toUpperCase().indexOf(".RAR") != -1) {
                jarfolder = new File(dirfiles[i].getParentFile().getParent() + File.separator + "unrar" + File.separator + this.getPureName(dirfiles[i].getName(), ".RAR") + File.separator);
                jarfolder.mkdirs();
                this.processZipFile(dirfiles[i], jarfolder);
                Roldjar = new File(dirfiles[i].getParentFile().getParent() + File.separator + "oldrar" + File.separator + dirfiles[i].getName());
                System.out.println("\u5c55\u958b\u3092\u7d42\u4e86\u3057\u305fRAR\u3092old\u30d5\u30a9\u30eb\u30c0\u306b\u79fb\u52d5\u3057\u307e\u3059:" + Roldjar.getAbsolutePath());
                if (!Roldjar.exists()) {
                    dirfiles[i].renameTo(Roldjar);
                    continue;
                }
                alternativepath = new File(dirfiles[i].getParentFile().getParent() + File.separator + "oldjar" + File.separator + System.currentTimeMillis());
                dirfiles[i].renameTo(alternativepath);
                continue;
            }
            if (!dirfiles[i].isDirectory()) continue;
            this.processJarDir(dirfiles[i]);
        }
    }

    private String getPureName(String original, String uppercaseExtension) {
        int index = original.toUpperCase().indexOf(uppercaseExtension);
        if (index != -1) {
            return original.substring(0, index);
        }
        return original;
    }

    private void processZipFile(File file, File tenkaisakiDir) {
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> ezip = zip.entries();
            while (ezip.hasMoreElements()) {
                int j;
                ZipEntry ent;
                ZipEntry ze = ent = ezip.nextElement();
                String originalzipentry = ze.getName();
                String targetfilename = tenkaisakiDir.getAbsolutePath() + File.separator + this.fileSeparatorOkikae(originalzipentry);
                File targetfile = new File(targetfilename);
                if (ze.isDirectory()) {
                    targetfile.mkdirs();
                    continue;
                }
                targetfile.getParentFile().mkdirs();
                BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(ze));
                BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(targetfile));
                while ((j = bis.read()) != -1) {
                    bo.write(j);
                }
                bis.close();
                bo.close();
            }
            zip.close();
        }
        catch (Exception zipe) {
            zipe.printStackTrace();
            this.errorCollection.add(zipe.getMessage());
        }
    }

    private String fileSeparatorOkikae(String original) {
        char[] input = original.toCharArray();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == '/') {
                result.append(File.separatorChar);
                continue;
            }
            result.append(input[i]);
        }
        return result.toString();
    }

    private String extractJARName(String fullpath) {
        if (fullpath == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(fullpath, File.separator);
        int count = -1;
        int found = -1;
        ArrayList<String> array = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            ++count;
            array.add(token);
            if (!token.equals("classes")) continue;
            found = count + 1;
        }
        if (found == -1) {
            return "notfound";
        }
        return (String)array.get(found);
    }

    private void updateClassFiles(File fromDir, File unjarDir, File rootDir) {
        HashSet<String> fromClassFullPaths = new HashSet<String>();
        File[] dirfiles = fromDir.listFiles();
        for (int i = 0; i < dirfiles.length; ++i) {
            if (dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(".CLASS")) {
                fromClassFullPaths.add(dirfiles[i].getAbsolutePath());
                continue;
            }
            if (!dirfiles[i].isDirectory()) continue;
            this.updateClassFiles(dirfiles[i], unjarDir, rootDir);
        }
        if (!fromClassFullPaths.isEmpty()) {
            this.matchClassesAndCopy(unjarDir, fromClassFullPaths, rootDir);
        }
    }

    private String convertDotedName(String input) {
        if (input == null) {
            return null;
        }
        char[] chars = input.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                sb.append('.');
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    private boolean matchJarFolderName(File input, HashSet moto) {
        boolean result = false;
        for (String moto_fullpath : moto) {
            if (!this.extractJARName(moto_fullpath).equals(input.getName())) continue;
            result = true;
        }
        return result;
    }

    private void matchClassesAndCopy(File unjarDir, HashSet fromClassFullPaths, File rootDir) {
        this.backup_classesDir = new File(unjarDir.getParent() + File.separator + "backup_classes" + File.separator);
        this.backup_classesDir.mkdirs();
        File[] dirfiles = unjarDir.listFiles();
        for (int i = 0; i < dirfiles.length; ++i) {
            if (!dirfiles[i].isDirectory() || !this.matchJarFolderName(dirfiles[i], fromClassFullPaths)) continue;
            System.out.println("\u66f4\u65b0\u5bfe\u8c61\u306eJAR\u3092\u898b\u3064\u3051\u307e\u3057\u305f\uff1aJar\u540d\u306f" + dirfiles[i].getName());
            this.processSubUnjarDir(dirfiles[i], fromClassFullPaths, rootDir, dirfiles[i]);
            for (String copyfromFilePath : fromClassFullPaths) {
                if (!this.extractJARName(copyfromFilePath).equals(dirfiles[i].getName())) continue;
                String copyTargetPath = dirfiles[i].getAbsolutePath() + File.separator + this.getPureFullClassName(copyfromFilePath, rootDir);
                File cfrom = new File(copyfromFilePath);
                File cTo = new File(copyTargetPath);
                cTo.getParentFile().mkdirs();
                try {
                    if (!cTo.exists()) {
                        this.copy(cfrom, cTo);
                    }
                }
                catch (Exception copyE) {
                    System.out.println(copyfromFilePath + "\u3000\u304b\u3089\u3000" + copyTargetPath + "\u3078\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    copyE.printStackTrace();
                    this.errorCollection.add(copyE.getMessage());
                }
                System.out.println("\u30b3\u30d4\u30fc\u5b8c\u4e86\u3057\u307e\u3057\u305f\uff1a" + copyfromFilePath + "\u3000\u304b\u3089\u3000" + copyTargetPath);
            }
        }
    }

    private void processSubUnjarDir(File unjarDir, HashSet fromClassFullPaths, File motoneta_rootDir, File henkosaki_jar_root) {
        File[] dirfiles = unjarDir.listFiles();
        for (int i = 0; i < dirfiles.length; ++i) {
            if (dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(".CLASS")) {
                String henkoumotofullclassname = this.getPureFullClassName(dirfiles[i].getAbsolutePath(), henkosaki_jar_root);
                String hikakukey = motoneta_rootDir + File.separator + henkosaki_jar_root.getName() + File.separator + henkoumotofullclassname;
                if (!fromClassFullPaths.contains(hikakukey)) continue;
                File backupto = new File(this.backup_classesDir.getAbsoluteFile() + File.separator + henkosaki_jar_root.getName() + File.separator + henkoumotofullclassname);
                backupto.getParentFile().mkdirs();
                System.out.println("class\u30d5\u30a1\u30a4\u30eb\u3092\u66f4\u65b0\u3059\u308b\u524d\u306b" + dirfiles[i].getAbsolutePath() + "\u3092" + backupto.getAbsolutePath() + "\u3078\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u307e\u3059\u3002");
                if (!backupto.exists()) {
                    dirfiles[i].renameTo(backupto);
                    continue;
                }
                File alternativepath = new File(this.backup_classesDir.getAbsoluteFile() + File.separator + henkosaki_jar_root.getName() + File.separator + System.currentTimeMillis());
                dirfiles[i].renameTo(alternativepath);
                continue;
            }
            if (!dirfiles[i].isDirectory()) continue;
            this.processSubUnjarDir(dirfiles[i], fromClassFullPaths, motoneta_rootDir, henkosaki_jar_root);
        }
    }

    private String getPureFullClassName(String original, File fromDir) {
        String fromDirPath = fromDir.getAbsolutePath();
        int index = original.indexOf(fromDirPath);
        if (index != -1) {
            return original.substring(index + fromDirPath.length() + 1);
        }
        return original;
    }

    private void processUnJarDir(File file, File backupdir) {
        File[] dirfiles = file.listFiles();
        for (int i = 0; i < dirfiles.length; ++i) {
            File outputfile;
            File alternativepath;
            File backuppath;
            String key;
            StringBuffer relativepath;
            File ufile;
            Stack<String> stack;
            String fullpath;
            if (dirfiles[i].getParentFile().getParentFile().getName().equalsIgnoreCase(this.getPureName(this.workflowservicejarname, ".JAR"))) continue;
            if (this.isEJB_JAR_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "EJB-JAR.XML")) {
                fullpath = dirfiles[i].getAbsolutePath();
                stack = new Stack<String>();
                ufile = dirfiles[i];
                while (!ufile.getName().equals("unjar")) {
                    stack.push(ufile.getName());
                    ufile = ufile.getParentFile();
                }
                relativepath = new StringBuffer();
                while (!stack.isEmpty()) {
                    key = (String)stack.pop();
                    relativepath.append(File.separator);
                    relativepath.append(key);
                }
                backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                backuppath.getParentFile().mkdirs();
                if (!backuppath.exists()) {
                    dirfiles[i].renameTo(backuppath);
                } else {
                    alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }
                outputfile = new File(fullpath);
                System.out.println("ejb-jar.xml\u306e\u66f8\u304d\u63db\u3048\u3092\u3057\u3066\u3044\u307e\u3059:" + outputfile.getAbsolutePath());
                try {
                    this.processEJB_JAR(backuppath, outputfile);
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                    System.err.println("EJB-JAR\u306e\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + backuppath.getAbsolutePath());
                    this.errorCollection.add(ie.getMessage());
                }
                continue;
            }
            if (this.isSUN_EJB_JAR_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "SUN-EJB-JAR.XML")) {
                fullpath = dirfiles[i].getAbsolutePath();
                stack = new Stack();
                ufile = dirfiles[i];
                while (!ufile.getName().equals("unjar")) {
                    stack.push(ufile.getName());
                    ufile = ufile.getParentFile();
                }
                relativepath = new StringBuffer();
                while (!stack.isEmpty()) {
                    key = (String)stack.pop();
                    relativepath.append(File.separator);
                    relativepath.append(key);
                }
                backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                backuppath.getParentFile().mkdirs();
                if (!backuppath.exists()) {
                    dirfiles[i].renameTo(backuppath);
                } else {
                    alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }
                outputfile = new File(fullpath);
                System.out.println("sun-ejb-jar.xml\u306e\u66f8\u304d\u63db\u3048\u3092\u3057\u3066\u3044\u307e\u3059:" + outputfile.getAbsolutePath());
                boolean modified = false;
                try {
                    modified = this.processSUN_EJB_JAR(backuppath, outputfile);
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                    System.err.println("EJB-JAR\u306e\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + backuppath.getAbsolutePath());
                    this.errorCollection.add(ie.getMessage());
                }
                if (modified) {
                    System.out.println("sun-ejb-jar.xml\u306e\u51e6\u7406\u5b8c\u4e86\u3002\u30aa\u30ea\u30b8\u30ca\u30eb\u306f" + backupdir.getAbsolutePath() + relativepath + "\u306b\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f\u3002");
                    continue;
                }
                System.out.println("sun-ejb-jar.xml\u306b\u306f\u5909\u66f4\u3059\u3079\u304d\u5185\u5bb9\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u66f4\u65b0\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3057\u305f\u3002");
                continue;
            }
            if (this.isMANIFEST_MF_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "MANIFEST.MF")) {
                fullpath = dirfiles[i].getAbsolutePath();
                stack = new Stack();
                ufile = dirfiles[i];
                while (!ufile.getName().equals("unjar")) {
                    stack.push(ufile.getName());
                    ufile = ufile.getParentFile();
                }
                relativepath = new StringBuffer();
                while (!stack.isEmpty()) {
                    key = (String)stack.pop();
                    relativepath.append(File.separator);
                    relativepath.append(key);
                }
                backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                backuppath.getParentFile().mkdirs();
                if (!backuppath.exists()) {
                    dirfiles[i].renameTo(backuppath);
                } else {
                    alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }
                outputfile = new File(fullpath);
                System.out.println("MANIFEST.MF\u306e\u66f8\u304d\u63db\u3048\u3092\u3057\u3066\u3044\u307e\u3059:" + outputfile.getAbsolutePath());
                File manifest_motoneta = new File(this.henkokakunoDir.getAbsolutePath() + File.separator + "MANIFEST.MF");
                if (manifest_motoneta.exists()) {
                    try {
                        this.copy(manifest_motoneta, outputfile);
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                        System.err.println("MANIFEST.MF\u306e\u30b3\u30d4\u30fc\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + backuppath.getAbsolutePath());
                        this.errorCollection.add(ie.getMessage());
                    }
                }
                System.out.println("MANIFEST.MF\u306e\u30b3\u30d4\u30fc\u5b8c\u4e86\u3002\u30aa\u30ea\u30b8\u30ca\u30eb\u306f" + backupdir.getAbsolutePath() + relativepath + "\u306b\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f\u3002");
                continue;
            }
            if (!dirfiles[i].isDirectory()) continue;
            this.processUnJarDir(dirfiles[i], backupdir);
        }
    }

    void processEJB_JAR(File inputfile, File outputfile) throws Exception {
        Ejb_Jar ejb_jar = new Ejb_Jar(inputfile);
        ejb_jar.setShowTransformationDetailLog(this.showtransformationdetaillog);
        System.out.println(ejb_jar.showChangingPoint());
        ejb_jar.transformAndSave(outputfile);
    }

    void processRA(File inputfile) throws Exception {
        Ra ra = new Ra(inputfile);
        ra.setShowTransformationDetailLog(this.showtransformationdetaillog);
        ra.transform();
    }

    boolean processSUN_EJB_JAR(File inputfile, File outputfile) throws Exception {
        Sun_Ejb_Jar sun_ejb_jar = new Sun_Ejb_Jar(inputfile);
        sun_ejb_jar.setShowTransformationDetailLog(this.showtransformationdetaillog);
        System.out.println(sun_ejb_jar.showChangingPoint());
        sun_ejb_jar.setConnectorResourceQueue(this.ConnectorResourceQueue);
        sun_ejb_jar.setConnectorResourceTopic(this.ConnectorResourceTopic);
        sun_ejb_jar.transformAndSave(outputfile);
        if (!sun_ejb_jar.isModified()) {
            System.out.println("** " + inputfile.getParentFile().getParent());
            this.dirtyJogai.add(inputfile.getParentFile().getParent());
        }
        return sun_ejb_jar.isModified();
    }

    void processApplication_xml(File inputfile, File outputfile) throws Exception {
        Application applicationxml = new Application(inputfile);
        applicationxml.setShowTransformationDetailLog(this.showtransformationdetaillog);
        applicationxml.setWorkflowservicename(this.workflowservicejarname);
        System.out.println(applicationxml.showChangingPoint());
        applicationxml.transformAndSave(outputfile);
    }

    void processSUN_RAR(File inputfile, File outputfile) throws Exception {
        Sun_RAR sun_rar = new Sun_RAR(inputfile);
        sun_rar.setShowTransformationDetailLog(this.showtransformationdetaillog);
        System.out.println(sun_rar.showChangingPoint());
        sun_rar.transformAndSave(outputfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File from, File to) throws IOException {
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buff = new byte[4096];
            int len = 0;
            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                ((BufferedOutputStream)out).write(buff, 0, len);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.errorCollection.add(e.getMessage());
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.errorCollection.add(e.getMessage());
                }
            }
        }
    }

    private void processUnRarDir(File file, File backupdir) {
        File[] dirfiles = file.listFiles();
        for (int i = 0; i < dirfiles.length; ++i) {
            File outputfile;
            File alternativepath;
            File backuppath;
            String key;
            StringBuffer relativepath;
            File ufile;
            Stack<String> stack;
            String fullpath;
            if (this.isRA_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "RA.XML")) {
                fullpath = dirfiles[i].getAbsolutePath();
                stack = new Stack<String>();
                ufile = dirfiles[i];
                while (!ufile.getName().equals("unrar")) {
                    stack.push(ufile.getName());
                    ufile = ufile.getParentFile();
                }
                relativepath = new StringBuffer();
                while (!stack.isEmpty()) {
                    key = (String)stack.pop();
                    relativepath.append(File.separator);
                    relativepath.append(key);
                }
                backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                backuppath.getParentFile().mkdirs();
                if (!backuppath.exists()) {
                    dirfiles[i].renameTo(backuppath);
                } else {
                    alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }
                outputfile = new File(fullpath);
                System.out.println("ra.xml\u306e\u66f8\u304d\u63db\u3048\u3092\u3057\u3066\u3044\u307e\u3059:" + outputfile.getAbsolutePath());
                try {
                    this.processRA(backuppath);
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                    System.err.println("RA.XML\u306e\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + backuppath.getAbsolutePath());
                    this.errorCollection.add(ie.getMessage());
                }
                continue;
            }
            if (this.isSUN_RA_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "SUN-RA.XML")) {
                fullpath = dirfiles[i].getAbsolutePath();
                stack = new Stack();
                ufile = dirfiles[i];
                while (!ufile.getName().equals("unrar")) {
                    stack.push(ufile.getName());
                    ufile = ufile.getParentFile();
                }
                relativepath = new StringBuffer();
                while (!stack.isEmpty()) {
                    key = (String)stack.pop();
                    relativepath.append(File.separator);
                    relativepath.append(key);
                }
                backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                backuppath.getParentFile().mkdirs();
                if (!backuppath.exists()) {
                    dirfiles[i].renameTo(backuppath);
                } else {
                    alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }
                outputfile = new File(fullpath);
                System.out.println("sun-ra.xml\u306e\u66f8\u304d\u63db\u3048\u3092\u3057\u3066\u3044\u307e\u3059:" + outputfile.getAbsolutePath());
                try {
                    this.processSUN_RAR(backuppath, outputfile);
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                    System.err.println("SUN-RA.XML\u306e\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + backuppath.getAbsolutePath());
                    this.errorCollection.add(ie.getMessage());
                }
                System.out.println("sun-ra.xml\u306e\u51e6\u7406\u5b8c\u4e86\u3002\u30aa\u30ea\u30b8\u30ca\u30eb\u306f" + backupdir.getAbsolutePath() + relativepath + "\u306b\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f\u3002");
                continue;
            }
            if (!dirfiles[i].isDirectory()) continue;
            this.processUnRarDir(dirfiles[i], backupdir);
        }
    }

    public void setConnectorResourceQueue(String ConnectorResourceQueue) {
        this.ConnectorResourceQueue = ConnectorResourceQueue;
    }

    public void setConnectorResourceTopic(String ConnectorResourceTopic) {
        this.ConnectorResourceTopic = ConnectorResourceTopic;
    }
}

