/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime;

import com.stc.otd.runtime.OtdLocation;
import java.io.PrintStream;
import java.io.PrintWriter;

public class MarshalException
extends RuntimeException {
    private final Throwable mCause;
    private final OtdLocation mLocation;

    public MarshalException(OtdLocation loc, String msg, Throwable cause) {
        super(msg);
        this.mLocation = loc;
        this.mCause = cause;
    }

    public MarshalException(OtdLocation loc, String msg) {
        this(loc, msg, null);
    }

    public MarshalException(String msg) {
        this(null, msg, null);
    }

    public MarshalException(String msg, Throwable cause) {
        this(null, msg, cause);
    }

    public MarshalException(Throwable cause) {
        this(null, null, cause);
    }

    public void printStackTrace(PrintStream stream) {
        if (this.mLocation != null) {
            stream.print("at " + this.mLocation.text() + ": ");
        }
        super.printStackTrace(stream);
        if (this.mCause != null) {
            stream.println("-- caused by --");
            this.mCause.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.mLocation != null) {
            writer.print("at " + this.mLocation.text() + ": ");
        }
        super.printStackTrace(writer);
        if (this.mCause != null) {
            writer.println("-- caused by --");
            this.mCause.printStackTrace(writer);
        }
    }

    public OtdLocation getLocation() {
        return this.mLocation;
    }
}

