/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime;

import com.stc.otd.runtime.OtdInputStream;
import com.stc.otd.runtime.OtdMeta;
import com.stc.otd.runtime.OtdNode;
import com.stc.otd.runtime.OtdOutputStream;
import com.stc.otd.runtime.OtdRoot;
import com.stc.otd.runtime.OtdRoot2;
import com.stc.util.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;

public class MetaCheck {
    public boolean mDebug = false;
    private static final Class[] PARAM_None = new Class[0];
    private static final Class[] PARAM_Int = new Class[]{Integer.TYPE};
    private static final Class[] PARAM_Obj = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = MetaCheck.class$("java.lang.Object")) : class$java$lang$Object};
    private static final Class[] PARAM_IntObj = new Class[]{Integer.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = MetaCheck.class$("java.lang.Object")) : class$java$lang$Object};
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$stc$otd$runtime$MetaCheck;

    public static String accessName(int access) {
        StringBuffer sb = new StringBuffer();
        if ((access & 1) != 0) {
            sb.append("+ADD");
        }
        if ((access & 2) != 0) {
            sb.append("+COUNT");
        }
        if ((access & 4) != 0) {
            sb.append("+GET");
        }
        if ((access & 0x10) != 0) {
            sb.append("+GETALL");
        }
        if ((access & 0x20) != 0) {
            sb.append("+HAS");
        }
        if ((access & 8) != 0) {
            sb.append("+LET");
        }
        if ((access & 0x40) != 0) {
            sb.append("+SET");
        }
        if ((access & 0x80) != 0) {
            sb.append("+SETALL");
        }
        if (access == 0) {
            sb.append("+NONE");
        }
        return sb.toString().substring(1);
    }

    public static String typeName(byte type) {
        switch (type) {
            case 1: {
                return "BOOL";
            }
            case 2: {
                return "BYTE";
            }
            case 3: {
                return "CHAR";
            }
            case 4: {
                return "DOUBLE";
            }
            case 15: {
                return "EPREF";
            }
            case 14: {
                return "EXREF";
            }
            case 5: {
                return "FLOAT";
            }
            case 10: {
                return "INREF";
            }
            case 6: {
                return "INT";
            }
            case 7: {
                return "LONG";
            }
            case 11: {
                return "NODE";
            }
            case 12: {
                return "OBJECT";
            }
            case 8: {
                return "SHORT";
            }
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private void barf(OtdNode node, String name, String text) {
        throw new RuntimeException("metaCheck: class " + node.getClass().getName() + " at " + name + ": " + text);
    }

    private void needsMethod(OtdNode node, String path, int child, String name, Class[] params) {
        try {
            node.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException nsm) {
            this.barf(node, path, "no " + params.length + "-parameter '" + name + "' accessor for child #" + child);
        }
    }

    public void test(OtdNode node, String name, String java, String numb, OtdMeta meta, Set seen) {
        int access;
        OtdMeta here;
        if (this.mDebug) {
            System.out.println("[ checking " + name + " ]");
        }
        if (node == null) {
            throw new NullPointerException("no node");
        }
        if (this.mDebug) {
            System.out.println("[ examine node <" + name + "> ]");
        }
        if ((here = node.meta()) == null) {
            this.barf(node, name, "meta() return null");
        }
        int size1 = meta.getChildCount();
        int size2 = here.getChildCount();
        if (size2 < 0) {
            this.barf(node, name, "meta.getChildCount() returns negative value: " + size2);
        }
        if (size1 != size2) {
            this.barf(node, name, "root and local meta.getChildCount() disagree: " + size1 + ", " + size2);
        }
        if ((access = meta.getAccess()) != here.getAccess()) {
            this.barf(node, name, "root and local meta.getAccess() disagree: " + MetaCheck.accessName(access) + ", " + MetaCheck.accessName(here.getAccess()));
        }
        if (size1 > 0) {
            for (int i = 0; i < size1; ++i) {
                boolean get;
                boolean has;
                OtdMeta msub = meta.getChild(i);
                if (msub == null) {
                    this.barf(node, name, "no meta for child #" + i);
                }
                String dname = msub.getName();
                String cname = msub.getJavaName();
                if (cname == null && (cname = msub.getName()) == null) {
                    this.barf(node, name, "no name for child #" + i);
                }
                if (this.mDebug) {
                    System.out.println("[ - check #" + i + ": <" + cname + "> ]");
                }
                access = msub.getAccess();
                boolean bl = has = meta.isChoice() || (access & 0x20) != 0;
                if (has) {
                    this.needsMethod(node, name, i, "has" + cname, msub.indexed() ? PARAM_Int : PARAM_None);
                }
                boolean bl2 = get = (access & 4) != 0;
                if (get) {
                    this.needsMethod(node, name, i, "get" + cname, msub.indexed() ? PARAM_Int : PARAM_None);
                }
                if ((access & 8) != 0) {
                    this.needsMethod(node, name, i, "get" + cname, msub.indexed() ? PARAM_Int : PARAM_None);
                }
                if ((access & 0x40) != 0) {
                    Class[] classArray;
                    String string = "set" + cname;
                    if (msub.indexed()) {
                        Class[] classArray2 = new Class[2];
                        classArray2[0] = Integer.TYPE;
                        classArray = classArray2;
                        classArray2[1] = msub.getNodeClass();
                    } else {
                        Class[] classArray3 = new Class[1];
                        classArray = classArray3;
                        classArray3[0] = msub.getNodeClass();
                    }
                    this.needsMethod(node, name, i, string, classArray);
                }
                if (msub.isLeaf() || has && !node.has(i)) continue;
                if (msub.indexed()) {
                    int count = node.count(i);
                    for (int j = 0; j < count; ++j) {
                        Object obj = node.get(i, j);
                        String is = "[" + j + "]";
                        if (obj == null) {
                            this.barf(node, name, "null child #" + i + is);
                        }
                        if (!(obj instanceof OtdNode)) {
                            this.barf(node, name, "non-leaf child #" + i + is + " not an OtdNode");
                        }
                        this.test((OtdNode)obj, name + "." + dname + is, java + "." + cname + is, numb + "." + i + is, msub, seen);
                    }
                    continue;
                }
                Object obj = node.get(i);
                if (obj == null) {
                    this.barf(node, name, "null child #" + i);
                }
                if (!(obj instanceof OtdNode)) {
                    this.barf(node, name, "non-leaf child #" + i + " not an OtdNode");
                }
                this.test((OtdNode)obj, name + "." + dname, java + "." + cname, numb + "." + i, msub, seen);
            }
        }
    }

    public void test(OtdRoot root) {
        OtdMeta meta;
        if (root == null) {
            throw new NullPointerException("no root");
        }
        if (this.mDebug) {
            System.out.println("[ examine root ]");
        }
        if ((meta = root.meta()) == null) {
            throw new RuntimeException("metaCheck: root class " + root.getClass().getName() + " returns null from root meta()");
        }
        HashSet seen = new HashSet();
        this.test(root, "@", "@", "@", meta, seen);
    }

    public void test(Class clazz) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object obj;
        Constructor cons;
        if (clazz == null) {
            throw new NullPointerException("no class");
        }
        if (this.mDebug) {
            System.out.println("[ get constructor ]");
        }
        if ((cons = clazz.getDeclaredConstructor(new Class[0])) == null) {
            throw new RuntimeException("metaCheck: no plain constructor for root class " + clazz.getName());
        }
        if (this.mDebug) {
            System.out.println("[ instantiate ]");
        }
        if ((obj = cons.newInstance(new Object[0])) instanceof OtdRoot2) {
            if (this.mDebug) {
                System.out.println("[ - implements OtdRoot2 ]");
            }
        } else if (obj instanceof OtdRoot) {
            if (this.mDebug) {
                System.out.println("[ - implements OtdRoot ]");
            }
        } else {
            throw new RuntimeException("metaCheck: root class " + clazz.getName() + " does not implement OtdRoot interface");
        }
        this.test((OtdRoot)obj);
    }

    public void test(String fqc) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (fqc == null) {
            throw new NullPointerException("no name");
        }
        if (this.mDebug) {
            System.out.println("[ load class <" + fqc + "> ]");
        }
        Class<?> clazz = (class$com$stc$otd$runtime$MetaCheck == null ? (class$com$stc$otd$runtime$MetaCheck = MetaCheck.class$("com.stc.otd.runtime.MetaCheck")) : class$com$stc$otd$runtime$MetaCheck).getClassLoader().loadClass(fqc);
        this.test(clazz);
    }

    public static void main(String[] args) {
        try {
            int c;
            boolean debug = false;
            Option opt = new Option(args, "d");
            block5: while ((c = opt.getOpt()) != -1) {
                switch (c) {
                    case 100: {
                        debug = true;
                        continue block5;
                    }
                }
                throw new RuntimeException("unknown option '-" + (char)c + "'");
            }
            MetaCheck test = new MetaCheck();
            test.mDebug = debug;
            int oind = opt.getOptInd();
            if (oind >= args.length) {
                throw new IllegalArgumentException("usage: java MetaCheck [-d] root-class");
            }
            String fqc = args[oind++];
            test.test(fqc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BrokenRoot
    extends BrokenNode
    implements OtdRoot {
        public void reset() {
            this.kaboom();
        }

        public void unmarshal(OtdInputStream in) {
            this.kaboom();
        }

        public void marshal(OtdOutputStream out) {
            this.kaboom();
        }

        public String[] check() {
            this.kaboom();
            return null;
        }
    }

    public static class BrokenNode
    implements OtdNode {
        protected void kaboom() {
            throw new UnsupportedOperationException("dummy implementation");
        }

        public OtdMeta meta() {
            return null;
        }

        public boolean has(int child) throws IndexOutOfBoundsException {
            this.kaboom();
            return false;
        }

        public boolean has(int child, int index) throws IndexOutOfBoundsException {
            this.kaboom();
            return false;
        }

        public int size(int child) {
            this.kaboom();
            return -1;
        }

        public int count(int child) {
            this.kaboom();
            return -1;
        }

        public int choice() {
            this.kaboom();
            return -1;
        }

        public Object get(int child) {
            this.kaboom();
            return null;
        }

        public Object get(int child, int index) {
            this.kaboom();
            return null;
        }

        public void set(int child, Object value) {
            this.kaboom();
        }

        public void set(int child, int index, Object value) {
            this.kaboom();
        }

        public void remove(int child) {
            this.kaboom();
        }

        public void remove(int child, int index) {
            this.kaboom();
        }
    }
}

