/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime;

import com.stc.otd.runtime.DocumentImpl;
import com.stc.otd.runtime.ElementImpl;
import com.stc.otd.runtime.OtdMeta;
import com.stc.otd.runtime.OtdNode;
import com.stc.otd.runtime.OtdNode2;
import com.stc.otd.runtime.OtdRoot;
import com.stc.otd.runtime.TextNodeImpl;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeImpl
implements Node {
    OtdNode mOtdParent = null;
    OtdMeta mMeta = null;
    OtdNode mRoot = null;
    OtdNode mOtdNode = null;
    private Node mParent = null;
    private DocumentImpl mOwnerDoc = null;
    private int mIndex = -1;
    private int mRepIndex = 0;
    private List mChildren = null;
    private NodeList mNodes = null;
    private boolean mTaint = false;
    private String mName = null;
    private String mVal = null;

    public NodeImpl(DocumentImpl doc, OtdRoot root) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        this.mOwnerDoc = doc;
        this.mRoot = this.mOtdNode = root;
        this.mMeta = root.meta();
        this.mName = this.mMeta.getName();
        this.mNodes = new NodeListImpl();
    }

    public NodeImpl(DocumentImpl doc, String tag) {
        this.mOwnerDoc = doc;
        this.mName = tag;
        this.mNodes = new NodeListImpl();
    }

    protected NodeImpl(DocumentImpl doc, Node parent, OtdNode otdParent, OtdMeta meta, OtdNode otdNode) {
        this.mOwnerDoc = doc;
        this.mParent = parent;
        this.mOtdParent = otdParent;
        this.mMeta = meta;
        this.mName = this.mMeta.getName();
        this.mOtdNode = otdNode;
        this.mNodes = new NodeListImpl();
    }

    public boolean isCollection() {
        return this.mMeta.indexed();
    }

    public short getNodeType() {
        if (this.mMeta.isLeaf()) {
            return 3;
        }
        return 1;
    }

    public void setNodeValue(String val) throws DOMException {
        this.mVal = val;
        byte type = this.mMeta.getType();
        switch (type) {
            case 1: {
                this.mOtdParent.set(this.mIndex, Boolean.valueOf(val));
                break;
            }
            case 2: {
                this.mOtdParent.set(this.mIndex, Byte.valueOf(val));
                break;
            }
            case 4: {
                this.mOtdParent.set(this.mIndex, Double.valueOf(val));
                break;
            }
            case 5: {
                this.mOtdParent.set(this.mIndex, Float.valueOf(val));
                break;
            }
            case 6: {
                this.mOtdParent.set(this.mIndex, Integer.valueOf(val));
                break;
            }
            case 7: {
                this.mOtdParent.set(this.mIndex, Long.valueOf(val));
                break;
            }
            case 8: {
                this.mOtdParent.set(this.mIndex, Short.valueOf(val));
                break;
            }
        }
    }

    public boolean hasChildNodes() {
        this.retrieveChildren();
        return this.mChildren.size() > 0;
    }

    public String getLocalName() {
        return this.mMeta.getName();
    }

    public String getNodeName() {
        return this.mName;
    }

    public String getNodeValue() throws DOMException {
        if (this.mMeta.isLeaf()) {
            return this.mVal;
        }
        return null;
    }

    public Node getFirstChild() {
        this.retrieveChildren();
        return this.hasChildNodes() ? (Node)this.mChildren.get(0) : null;
    }

    public Node getLastChild() {
        this.retrieveChildren();
        return this.hasChildNodes() ? (Node)this.mChildren.get(this.mChildren.size() - 1) : null;
    }

    public Node getNextSibling() {
        NodeList sibs = this.mParent.getChildNodes();
        return sibs.getLength() > this.mIndex + 1 ? sibs.item(this.mIndex + 1) : null;
    }

    public Node getParentNode() {
        return this.mParent;
    }

    public Node getPreviousSibling() {
        NodeList sibs = this.mParent.getChildNodes();
        return this.mIndex == 0 ? null : sibs.item(this.mIndex - 1);
    }

    public Node cloneNode(boolean aDeep) {
        return null;
    }

    public NodeList getChildNodes() {
        this.retrieveChildren();
        return this.mNodes;
    }

    private void setIndex(int index) {
        this.mIndex = index;
    }

    private void retrieveChildren() {
        if (this.mChildren == null || this.taint()) {
            this.mChildren = new ArrayList();
            int metaChild = this.mMeta.getChildCount();
            System.out.println(this.mMeta.getName() + " has meta children " + metaChild);
            for (int i = 0; i < metaChild; ++i) {
                int children = this.mOtdNode.count(i);
                System.out.println(this.mMeta.getName() + ":" + this.mMeta.getChild(i).getName() + " has repeat children " + children);
                NodeImpl node = null;
                Object otdNode = null;
                boolean isLeaf = this.mMeta.getChild(i).isLeaf();
                if (children > 1) {
                    for (int j = 0; j < children; ++j) {
                        System.out.println(j);
                        System.out.println("3" + this.mMeta.getChild(i).getName());
                        if (isLeaf) {
                            System.out.println("leaf:" + this.mMeta.getChild(i).getName());
                            if (this.mOtdNode.has(i, j)) {
                                node = new ElementImpl(this.mOwnerDoc, this, this.mOtdNode, this.mMeta.getChild(i), (OtdNode)this.mOtdNode.get(i, j), i, j);
                                TextNodeImpl text = new TextNodeImpl(this.mOwnerDoc, node, this.mOtdNode.get(i, j).toString());
                                node.appendChild(text);
                            }
                        } else {
                            System.out.println("node:" + this.mMeta.getChild(i).getName());
                            if (this.mOtdNode.has(i, j)) {
                                node = new ElementImpl(this.mOwnerDoc, this, this.mOtdNode, this.mMeta.getChild(i), (OtdNode)this.mOtdNode.get(i, j), i, j);
                                this.mChildren.add(node);
                            }
                        }
                        node.setIndex(this.mChildren.indexOf(node));
                    }
                    continue;
                }
                if (isLeaf) {
                    if (this.mOtdNode.get(i) != null) {
                        System.out.println("leaf:" + this.mMeta.getChild(i).getName() + this.mOtdNode.get(i).toString());
                        node = new ElementImpl(this.mOwnerDoc, this, this.mOtdNode, this.mMeta.getChild(i), null, i, 0);
                        TextNodeImpl text = new TextNodeImpl(this.mOwnerDoc, node, this.mOtdNode.get(i).toString());
                        node.appendChild(text);
                    }
                } else if (this.mOtdNode.has(i)) {
                    System.out.println("node:" + this.mMeta.getChild(i).getName());
                    node = new ElementImpl(this.mOwnerDoc, this, this.mOtdNode, this.mMeta.getChild(i), (OtdNode)this.mOtdNode.get(i), i, 0);
                }
                if (node == null) continue;
                this.mChildren.add(node);
                super.setIndex(this.mChildren.indexOf(node));
            }
        }
    }

    public Node appendChild(Node child) throws DOMException {
        return this.insertBefore(child, null);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        this.retrieveChildren();
        boolean exist = this.mChildren.remove(oldChild);
        if (!exist) {
            throw new DOMException(8, "not a child");
        }
        return oldChild;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        this.retrieveChildren();
        if (newChild instanceof NodeImpl) {
            NodeImpl newCast = (NodeImpl)newChild;
            int child = -1;
            OtdMeta childMeta = null;
            String name = newChild.getNodeName();
            int count = this.mMeta.getChildCount();
            for (int i = 0; i < count; ++i) {
                childMeta = this.mMeta.getChild(i);
                if (!childMeta.getName().equals(name)) continue;
                newCast.setMeta(childMeta);
                child = i;
                break;
            }
            if (child == -1 && !"#text".equals(name)) {
                throw new IllegalArgumentException("Child [" + name + "] is not allowed in parent[" + this.mMeta.getName());
            }
            if (!childMeta.isLeaf()) {
                OtdNode childOtd = null;
                if (childMeta.indexed()) {
                    int index = 0;
                    for (int i = 0; i < this.mChildren.size(); ++i) {
                        if (!((Node)this.mChildren.get(i)).getNodeName().equals(name)) continue;
                        ++index;
                    }
                    childOtd = (OtdNode)((OtdNode2)this.mOtdNode).let(child, index);
                } else {
                    childOtd = (OtdNode)((OtdNode2)this.mOtdNode).let(child);
                }
                newCast.setOtdNode(childOtd);
            }
            newCast.setOtdParent(this.mOtdParent);
            if (refChild == null) {
                this.mChildren.add(newChild);
                newCast.setIndex(this.mChildren.size() - 1);
            } else {
                int poc = this.mChildren.indexOf(newChild);
                this.mChildren.add(this.mChildren.indexOf(refChild), newChild);
                newCast.setIndex(poc);
                for (int rest = poc + 1; rest < this.mChildren.size(); ++rest) {
                    ((NodeImpl)this.mChildren.get(rest)).setIndex(rest);
                }
            }
            if (newChild instanceof NodeImpl) {
                newCast.setParent(this);
            }
        }
        if (newChild instanceof TextNodeImpl) {
            this.mChildren.add(newChild);
            ((TextNodeImpl)newChild).setParent(this);
        }
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.retrieveChildren();
        int poc = this.mChildren.indexOf(oldChild);
        this.mChildren.remove(poc);
        this.mChildren.add(poc, newChild);
        return oldChild;
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String aPrefix) throws DOMException {
    }

    public Document getOwnerDocument() {
        return this.mOwnerDoc;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean isSupported(String aFeature, String aVersion) {
        return false;
    }

    public boolean taint() {
        return this.mTaint;
    }

    public void setParent(Node parent) {
        this.mParent = parent;
    }

    public void setOtdParent(OtdNode otdParent) {
        this.mOtdParent = otdParent;
    }

    public void setMeta(OtdMeta meta) {
        this.mMeta = meta;
    }

    public void setOtdNode(OtdNode otd) {
        this.mOtdNode = otd;
    }

    private class NodeListImpl
    implements NodeList {
        private NodeListImpl() {
        }

        public int getLength() {
            return NodeImpl.this.mChildren.size();
        }

        public Node item(int aIndex) {
            return (Node)NodeImpl.this.mChildren.get(aIndex);
        }
    }
}

