/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime;

import com.stc.otd.runtime.OtdLocation;
import java.io.PrintStream;
import java.io.PrintWriter;

public class UnmarshalException
extends RuntimeException {
    private final Throwable mCause;
    private final OtdLocation mLocation;
    private long mOffset = -1L;
    private long mLineNumber = -1L;
    private long mColumnNumber = -1L;
    private String mMsg;

    public UnmarshalException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public UnmarshalException(String msg) {
        this(msg, null);
    }

    public UnmarshalException(String msg, Throwable cause) {
        super(msg);
        this.mLocation = null;
        this.mCause = cause;
        this.mMsg = msg;
    }

    public UnmarshalException(long offset, String msg) {
        this(offset, msg, null);
    }

    public UnmarshalException(long offset, String msg, Throwable cause) {
        super((offset < 0L ? "" : "at byte " + offset + ": ") + msg);
        this.mLocation = null;
        this.mCause = cause;
        this.mOffset = offset;
        this.mMsg = msg;
    }

    public UnmarshalException(long line, long column, String msg) {
        super(msg);
        this.mLocation = null;
        this.mCause = null;
        this.mLineNumber = line;
        this.mColumnNumber = column;
    }

    public UnmarshalException(OtdLocation loc, String msg) {
        super(msg);
        this.mLocation = loc;
        this.mCause = null;
    }

    public void printStackTrace(PrintStream stream) {
        if (this.mLocation != null) {
            stream.print("at " + this.mLocation.text() + ": ");
        }
        super.printStackTrace(stream);
        if (this.mCause != null) {
            stream.println("-- caused by --");
            this.mCause.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.mLocation != null) {
            writer.print("at " + this.mLocation.text() + ": ");
        }
        super.printStackTrace(writer);
        if (this.mCause != null) {
            writer.println("-- caused by --");
            this.mCause.printStackTrace(writer);
        }
    }

    public String getOriginalMessage() {
        return this.mMsg;
    }

    public OtdLocation getLocation() {
        return this.mLocation;
    }

    public boolean hasOffset() {
        return this.mOffset > -1L;
    }

    public boolean hasLineAndColumn() {
        return this.mLineNumber > -1L;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public long getLineNumber() {
        return this.mLineNumber;
    }

    public long getColumnNumber() {
        return this.mColumnNumber;
    }
}

