/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64Coder {
    private static final int END_OF_INPUT = -1;
    private static final int NON_BASE_64 = -1;
    protected static final byte[] BASE64CARS;
    protected static final byte[] DECODETABLE;

    public static String encode(String string) {
        return new String(Base64Coder.encode(string.getBytes()));
    }

    public static String encode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64Coder.encode(string.getBytes(enc)), enc);
    }

    public static byte[] encode(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 3;
        if (mod != 0) {
            length += 3 - mod;
        }
        length = length * 4 / 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64Coder.encode(in, out, false);
        }
        catch (IOException x) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static void encode(InputStream in, OutputStream out) throws IOException {
        Base64Coder.encode(in, out, true);
    }

    public static void encode(InputStream in, OutputStream out, boolean lineBreaks) throws IOException {
        int[] inBuffer = new int[3];
        int lineCount = 0;
        boolean done = false;
        while (!done && (inBuffer[0] = in.read()) != -1) {
            inBuffer[1] = in.read();
            inBuffer[2] = in.read();
            out.write(BASE64CARS[inBuffer[0] >> 2]);
            if (inBuffer[1] != -1) {
                out.write(BASE64CARS[inBuffer[0] << 4 & 0x30 | inBuffer[1] >> 4]);
                if (inBuffer[2] != -1) {
                    out.write(BASE64CARS[inBuffer[1] << 2 & 0x3C | inBuffer[2] >> 6]);
                    out.write(BASE64CARS[inBuffer[2] & 0x3F]);
                } else {
                    out.write(BASE64CARS[inBuffer[1] << 2 & 0x3C]);
                    out.write(61);
                    done = true;
                }
            } else {
                out.write(BASE64CARS[inBuffer[0] << 4 & 0x30]);
                out.write(61);
                out.write(61);
                done = true;
            }
            if (!lineBreaks || (lineCount += 4) < 76) continue;
            out.write(10);
            lineCount = 0;
        }
        if (lineBreaks && lineCount >= 1) {
            out.write(10);
            lineCount = 0;
        }
        out.flush();
    }

    public static String decode(String string) {
        return new String(Base64Coder.decode(string.getBytes()));
    }

    public static String decode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64Coder.decode(string.getBytes(enc)), enc);
    }

    public static byte[] decode(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 4;
        if (mod != 0) {
            length += 4 - mod;
        }
        length = length * 3 / 4;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64Coder.decode(in, out, false);
        }
        catch (IOException x) {
            // empty catch block
        }
        return out.toByteArray();
    }

    private static final int readBase64(InputStream in, boolean throwExceptions) throws IOException {
        int read;
        boolean numPadding = false;
        do {
            if ((read = in.read()) != -1) continue;
            return -1;
        } while ((read = DECODETABLE[(byte)read]) <= -1);
        return read;
    }

    public static void decode(InputStream in, OutputStream out) throws IOException {
        Base64Coder.decode(in, out, true);
    }

    public static void decode(InputStream in, OutputStream out, boolean throwExceptions) throws IOException {
        int[] inBuffer = new int[4];
        boolean done = false;
        while (!done && (inBuffer[0] = Base64Coder.readBase64(in, throwExceptions)) != -1 && (inBuffer[1] = Base64Coder.readBase64(in, throwExceptions)) != -1) {
            inBuffer[2] = Base64Coder.readBase64(in, throwExceptions);
            inBuffer[3] = Base64Coder.readBase64(in, throwExceptions);
            out.write(inBuffer[0] << 2 | inBuffer[1] >> 4);
            if (inBuffer[2] != -1) {
                out.write(inBuffer[1] << 4 | inBuffer[2] >> 2);
                if (inBuffer[3] != -1) {
                    out.write(inBuffer[2] << 6 | inBuffer[3]);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        out.flush();
    }

    static {
        int i;
        BASE64CARS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        DECODETABLE = new byte[256];
        for (i = 0; i < DECODETABLE.length; ++i) {
            Base64Coder.DECODETABLE[i] = -1;
        }
        for (i = 0; i < BASE64CARS.length; i = (int)((byte)(i + 1))) {
            Base64Coder.DECODETABLE[Base64Coder.BASE64CARS[i]] = i;
        }
    }
}

