/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.CoderException;
import com.stc.otd.runtime.StringCoder;
import com.stc.otd.runtime.provider.SharedCoder;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class BuiltInStringCoder
implements StringCoder {
    public static final String CODE = "code";
    public static final String PAD = "pad";
    private final String mEncoding;
    private final byte[] mPadding;
    private final ByteToCharConverter mDecoder;
    private final CharToByteConverter mEncoder;

    public BuiltInStringCoder(String enc) throws UnsupportedEncodingException {
        if (enc == null) {
            throw new UnsupportedEncodingException("null encoding name");
        }
        int at = enc.indexOf(",pad=");
        byte[] pad = null;
        if (0 <= at) {
            try {
                int value = Integer.parseInt(enc.substring(at + 5));
                pad = new byte[]{(byte)value};
            }
            catch (NumberFormatException n) {
                throw new IllegalArgumentException("invalid padding: [" + enc.substring(at + 5) + "]");
            }
        }
        this.mEncoding = enc;
        this.mPadding = pad;
        this.mDecoder = ByteToCharConverter.getConverter((String)enc);
        this.mEncoder = CharToByteConverter.getConverter((String)enc);
    }

    public BuiltInStringCoder(String enc, byte[] pad) throws UnsupportedEncodingException {
        if (enc == null) {
            throw new UnsupportedEncodingException("null encoding name");
        }
        if (pad == null || pad.length == 0) {
            pad = new byte[]{32};
        }
        this.mEncoding = enc;
        this.mPadding = pad;
        this.mDecoder = ByteToCharConverter.getConverter((String)enc);
        this.mEncoder = CharToByteConverter.getConverter((String)enc);
    }

    public byte[] encode(String s) throws CoderException {
        if (null == s) {
            return null;
        }
        this.mEncoder.reset();
        try {
            return this.mEncoder.convertAll(s.toCharArray());
        }
        catch (MalformedInputException e) {
            int at = this.mEncoder.nextCharIndex();
            throw new CoderException("Unable to convert string, char[" + at + "]=" + SharedCoder.uname(s.charAt(at)), e);
        }
    }

    public byte[] encode(String s, int min, int max) throws CoderException {
        if (null == s) {
            return null;
        }
        this.mEncoder.reset();
        try {
            char[] idata = s.toCharArray();
            int len = max < 0 ? this.mEncoder.getMaxBytesPerChar() * idata.length : max;
            byte[] buf = new byte[len];
            int done = this.mEncoder.convert(idata, 0, idata.length, buf, 0, max);
            if (done < idata.length) {
                throw new RuntimeException("incomplete output");
            }
            this.mEncoder.flush(buf, this.mEncoder.nextByteIndex(), max);
            int to = this.mEncoder.nextByteIndex();
            if (0 <= min) {
                while (to < min) {
                    for (int j = 0; j < this.mPadding.length && to < min; ++j) {
                        buf[to++] = this.mPadding[j];
                    }
                }
            }
            if (to < buf.length) {
                byte[] copy = new byte[to];
                System.arraycopy(buf, 0, copy, 0, to);
                buf = copy;
            }
            return buf;
        }
        catch (UnknownCharacterException e) {
            int at = this.mEncoder.nextCharIndex();
            throw new CoderException("String unencodable, char[" + at + "]=" + SharedCoder.uname(s.charAt(at)), e);
        }
        catch (MalformedInputException e) {
            int at = this.mEncoder.nextCharIndex();
            throw new CoderException("String malformed, char[" + at + "]=" + SharedCoder.uname(s.charAt(at)), e);
        }
        catch (ConversionBufferFullException e) {
            int at = this.mEncoder.nextCharIndex();
            throw new CoderException("String too big, did " + this.mEncoder.nextCharIndex() + " of " + s.length() + (max < 0 ? "" : ", max bytes=" + max));
        }
    }

    public String decode(byte[] b) throws CoderException {
        if (null == b) {
            return null;
        }
        this.mDecoder.reset();
        try {
            return new String(this.mDecoder.convertAll(b));
        }
        catch (MalformedInputException e) {
            throw new CoderException("Unable to convert string.", e);
        }
    }

    public String decode(byte[] b, int from, int length) throws CoderException {
        if (from < 0) {
            throw new IllegalArgumentException("negative offset: " + from);
        }
        if (length < 0) {
            throw new IllegalArgumentException("negative length: " + length);
        }
        if (b == null) {
            return null;
        }
        if (b.length < from + length) {
            throw new IllegalArgumentException("offset + length < size: " + from + ", " + length + ", " + b.length);
        }
        if (0 < from || length != b.length) {
            byte[] copy = new byte[length];
            System.arraycopy(b, from, copy, 0, length);
            b = copy;
        }
        return this.decode(b);
    }

    public void setProperty(String name, Object value) {
        throw new IllegalArgumentException(this.getClass() + " has no [" + name + "] property");
    }

    public Object getProperty(String name) {
        if (CODE.equals(name)) {
            return this.mEncoding;
        }
        if (PAD.equals(name)) {
            return this.mPadding;
        }
        throw new IllegalArgumentException(this.getClass() + " has no [" + name + "] property");
    }
}

