/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.OtdInputStream;
import com.stc.util.MessageManager;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CircularBuffer {
    private int minSize = 16;
    private int[] buffer;
    private OtdInputStream mOtdis;
    private int nbrOfChars;
    private int offset;
    private int sizeLessOne;

    public CircularBuffer(OtdInputStream otdis) {
        this.mOtdis = otdis;
        this.init(this.minSize);
        this.fillBuffer();
    }

    public final void append(int ch) {
        if (this.nbrOfChars == this.buffer.length) {
            this.expand();
        }
        this.buffer[this.offset + this.nbrOfChars & this.sizeLessOne] = ch;
        ++this.nbrOfChars;
    }

    public final int elementAt(int idx) {
        return this.buffer[this.offset + idx & this.sizeLessOne];
    }

    public final void removeFirst() {
        this.offset = this.offset + 1 & this.sizeLessOne;
        --this.nbrOfChars;
    }

    public final void reset() {
        this.offset = 0;
        this.nbrOfChars = 0;
    }

    public int consume() {
        int curr = this.elementAt(0);
        this.consumeChars(1);
        return curr;
    }

    public void consumeChars(int nbrChars) {
        try {
            for (int i = 0; i < nbrChars; ++i) {
                this.removeFirst();
                this.append(this.mOtdis.read());
            }
        }
        catch (IOException ioe) {
            MessageManager mMsg = MessageManager.getManager((String)this.getClass().getPackage().getName());
            String mesg = mMsg.getString("otd.parse.char.error");
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mesg, ioe);
        }
    }

    public void consumeDelimiter(char[] delimiter) {
        this.consumeChars(delimiter.length);
    }

    public boolean matchDelimiter(char[] delimiter) {
        for (int i = 0; i < delimiter.length; ++i) {
            if (delimiter[i] == this.elementAt(i)) continue;
            return false;
        }
        return true;
    }

    private final void expand() {
        int[] newBuffer = new int[this.buffer.length * 2];
        for (int i = 0; i < this.buffer.length; ++i) {
            newBuffer[i] = this.elementAt(i);
        }
        this.buffer = newBuffer;
        this.sizeLessOne = this.buffer.length - 1;
        this.offset = 0;
    }

    private void fillBuffer() {
        try {
            while (this.nbrOfChars < this.buffer.length) {
                this.append(this.mOtdis.read());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void init(int size) {
        this.buffer = new int[size];
        this.sizeLessOne = size - 1;
        this.offset = 0;
        this.nbrOfChars = 0;
    }
}

