/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.OtdInputStream;
import com.stc.util.MessageManager;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixedLengthReader {
    private OtdInputStream mOtdis;
    private String mEncoding = "UTF-8";

    public FixedLengthReader(OtdInputStream otdis) {
        this.mOtdis = otdis;
    }

    public FixedLengthReader(OtdInputStream otdis, String encoding) {
        this.mOtdis = otdis;
        if (encoding != null) {
            this.mEncoding = encoding;
        }
    }

    public String read(int length) {
        return this.read(length, this.mEncoding);
    }

    public String read(int length, String encoding) {
        try {
            String data;
            byte[] buffer = new byte[length];
            int bytesRead = this.mOtdis.read(buffer);
            if (bytesRead != length) {
                return null;
            }
            if (bytesRead > 0 && (data = new String(buffer, encoding)) != null) {
                return data.trim();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            MessageManager mMsg = MessageManager.getManager((String)this.getClass().getPackage().getName());
            String mesg = mMsg.getString("otd.parse.char.error");
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mesg, ioe);
        }
        return null;
    }
}

